/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.batch.converter.core.converters.openapi;

import com.oxygenxml.batch.converter.core.ConversionInputsProvider;
import com.oxygenxml.batch.converter.core.converters.Converter;
import com.oxygenxml.batch.converter.core.converters.PipelineConverter;
import com.oxygenxml.batch.converter.core.converters.json.YamlToJsonConverter;
import com.oxygenxml.batch.converter.core.converters.map.MapWithTopicsConverter;
import com.oxygenxml.batch.converter.core.converters.openapi.OpenApiPostProcessingConverter;
import com.oxygenxml.batch.converter.core.converters.openapi.OpenApiXmlToDITAConverter;
import com.oxygenxml.batch.converter.core.converters.yaml.JsonToXmlConverter;
import com.oxygenxml.batch.converter.core.extensions.FileExtensionType;
import com.oxygenxml.batch.converter.core.transformer.TransformerFactoryCreator;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import ro.sync.basic.util.URLUtil;

public class OpenApiToDITAConverter
extends PipelineConverter {
    private boolean shouldConvertExternalOpenApiReferences = true;

    @Override
    protected Converter[] getUsedConverters(File fileToConvert, ConversionInputsProvider userInputsProvider, TransformerFactoryCreator transformerCreator) {
        ArrayList<Converter> converters = new ArrayList<Converter>();
        String extension = URLUtil.getExtension((String)fileToConvert.getName());
        if (extension != null && Arrays.asList(FileExtensionType.INPUT_YAML_EXTENSIONS).contains(extension)) {
            converters.add(new YamlToJsonConverter());
        }
        converters.add(new JsonToXmlConverter());
        converters.add(new OpenApiXmlToDITAConverter());
        Boolean shouldForbidCreatingExternalContent = userInputsProvider.getAdditionalOptionValue("forbid.creating.external.content");
        this.shouldConvertExternalOpenApiReferences = this.shouldConvertExternalOpenApiReferences && (shouldForbidCreatingExternalContent == null || shouldForbidCreatingExternalContent == false);
        converters.add(new OpenApiPostProcessingConverter(transformerCreator, this.shouldConvertExternalOpenApiReferences));
        Boolean shouldCreateDitaMap = userInputsProvider.getAdditionalOptionValue("create.dita.map.from.open.api");
        if (shouldCreateDitaMap != null && shouldCreateDitaMap.booleanValue()) {
            converters.add(new MapWithTopicsConverter());
        }
        return converters.toArray(new Converter[0]);
    }

    public void setShouldConvertExternalOpenApiReferences(boolean shouldConvert) {
        this.shouldConvertExternalOpenApiReferences = shouldConvert;
    }
}

