/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.batch.converter.core.converters.openapi;

import com.oxygenxml.batch.converter.core.ConversionInputsProvider;
import com.oxygenxml.batch.converter.core.converters.ConversionResult;
import com.oxygenxml.batch.converter.core.converters.ConvertedFilesManager;
import com.oxygenxml.batch.converter.core.converters.openapi.OpenApiPostProcessingUtil;
import com.oxygenxml.batch.converter.core.converters.openapi.OpenApiToDITAConverter;
import com.oxygenxml.batch.converter.core.printers.ContentPrinter;
import com.oxygenxml.batch.converter.core.printers.ContentPrinterCreater;
import com.oxygenxml.batch.converter.core.transformer.TransformerFactoryCreator;
import com.oxygenxml.batch.converter.core.utils.ConverterFileUtils;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import javax.xml.transform.TransformerException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLFilterImpl;

public class OpenApiExternalReferenceHandler
extends XMLFilterImpl {
    private static final Logger logger = LoggerFactory.getLogger((String)OpenApiExternalReferenceHandler.class.getName());
    private static final String EXTERNAL_REFERENCE_OUTPUTCLASS = "oxy-external-openapi";
    private File currentInputFile;
    private File outputFolder;
    private List<String> problemsCollector;
    private TransformerFactoryCreator transformerCreator;
    private OpenApiToDITAConverter openApiConverter;
    private ContentPrinter contentPrinter;
    private ConvertedFilesManager convertedFilesManager;
    private final boolean shouldConvertExternalRefs;

    public OpenApiExternalReferenceHandler(boolean shouldConvertExternalRefs, File inputFile, TransformerFactoryCreator transformerCreator, File outputFolder, List<String> problemsCollector, XMLReader parentXmlReader) {
        super(parentXmlReader);
        this.currentInputFile = inputFile;
        this.transformerCreator = transformerCreator;
        this.convertedFilesManager = ConvertedFilesManager.getInstance();
        this.outputFolder = outputFolder;
        this.problemsCollector = problemsCollector;
        this.shouldConvertExternalRefs = shouldConvertExternalRefs;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        String currentOutputclassValue = atts.getValue("outputclass");
        if (currentOutputclassValue != null && currentOutputclassValue.contains(EXTERNAL_REFERENCE_OUTPUTCLASS)) {
            if (this.shouldConvertExternalRefs) {
                atts = this.handleExternalReference(atts);
            }
            atts = OpenApiPostProcessingUtil.removeTokenFromOutputClassAttributeValue(atts, EXTERNAL_REFERENCE_OUTPUTCLASS);
        }
        super.startElement(uri, localName, qName, atts);
    }

    private Attributes handleExternalReference(Attributes atts) {
        int hashCharIndex;
        String hrefValue = atts.getValue("href");
        if (hrefValue != null && (hashCharIndex = hrefValue.indexOf(35)) != -1) {
            File outputFile;
            String filePath = hrefValue.substring(0, hashCharIndex);
            File fileToConvert = new File(this.currentInputFile.getParentFile(), filePath);
            String anchor = hrefValue.substring(hashCharIndex);
            if (this.convertedFilesManager.isFileAlreadyConverted(fileToConvert)) {
                outputFile = this.convertedFilesManager.getOutputFile(fileToConvert);
            } else {
                outputFile = ConverterFileUtils.getUniqueOutputFile(fileToConvert, "dita", this.outputFolder);
                try {
                    this.convertOpenApiFile(fileToConvert, outputFile);
                }
                catch (TransformerException e) {
                    this.problemsCollector.add(e.getMessage());
                    logger.debug(e.getMessage(), (Throwable)e);
                }
                this.convertedFilesManager.addConvertedFile(fileToConvert, outputFile);
            }
            atts = OpenApiPostProcessingUtil.changeAttributeValue(atts, "href", outputFile.getName() + anchor);
        }
        return atts;
    }

    private void convertOpenApiFile(final File fileToConvert, File outputFile) throws TransformerException {
        if (this.openApiConverter == null) {
            this.openApiConverter = new OpenApiToDITAConverter();
        }
        if (this.contentPrinter == null) {
            this.contentPrinter = ContentPrinterCreater.create("_openapi.to.dita");
        }
        ConversionResult conversionTopicResult = this.openApiConverter.convert(fileToConvert, null, this.transformerCreator, new ConversionInputsProvider(){

            @Override
            public File getOutputFolder() {
                return OpenApiExternalReferenceHandler.this.outputFolder;
            }

            @Override
            public Integer getMaxHeadingLevelForCreatingTopics() {
                return null;
            }

            @Override
            public List<File> getInputFiles() {
                return Arrays.asList(fileToConvert);
            }

            @Override
            public Boolean getAdditionalOptionValue(String additionalOptionId) {
                return null;
            }

            @Override
            public String getFormatForSameTypeReferences() {
                return null;
            }
        });
        this.contentPrinter.print(conversionTopicResult, this.transformerCreator, "_openapi.to.dita", outputFile);
    }
}

