/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.batch.converter.core.converters.html;

import com.oxygenxml.batch.converter.core.ConversionInputsProvider;
import com.oxygenxml.batch.converter.core.converters.ConversionResult;
import com.oxygenxml.batch.converter.core.converters.Converter;
import com.oxygenxml.batch.converter.core.converters.ConverterDefaults;
import com.oxygenxml.batch.converter.core.transformer.TransformerFactoryCreator;
import java.io.File;
import java.io.Reader;
import java.io.StringWriter;
import java.net.URL;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import ro.sync.basic.util.URLUtil;
import ro.sync.basic.xml.BasicXmlUtil;

public class XHTMLToDITAConverter
implements Converter {
    private static final String TOPIC_ROOT_ELEMENT_NAME = "topic";
    private final boolean shouldUpdateLocalFileReferences;
    private final boolean shouldConvertClassToOutputclass;
    private boolean shouldFilterDivElements;

    public XHTMLToDITAConverter(boolean shouldUpdateLocalFileReferences, boolean shouldConvertClassToOutputclass, Boolean shouldFilterDivElements) {
        this.shouldUpdateLocalFileReferences = shouldUpdateLocalFileReferences;
        this.shouldConvertClassToOutputclass = shouldConvertClassToOutputclass;
        if (shouldFilterDivElements != null) {
            this.shouldFilterDivElements = shouldFilterDivElements;
        }
    }

    @Override
    public ConversionResult convert(File originalFile, Reader contentReader, TransformerFactoryCreator transformerCreator, ConversionInputsProvider userInputsProvider) throws TransformerException {
        ConversionResult conversionResult;
        URL xsltURL = this.getClass().getClassLoader().getResource("stylesheets/dita/xhtml2ditaDriver.xsl");
        StreamSource src = new StreamSource(xsltURL.toExternalForm());
        Transformer transformer = transformerCreator.createTransformer(src);
        String fileName = URLUtil.extractFileName((String)originalFile.getAbsolutePath());
        if (fileName != null) {
            fileName = URLUtil.removeExtension((String)fileName);
            transformer.setParameter("defaultDocumentTitle", BasicXmlUtil.escape((String)fileName));
        }
        transformer.setParameter("replace.entire.root.contents", Boolean.TRUE);
        transformer.setParameter("context.path.names", TOPIC_ROOT_ELEMENT_NAME);
        transformer.setParameter("wrapMultipleSectionsInARoot", Boolean.TRUE);
        transformer.setParameter("wrapElementsBeforeHeadingInSection", Boolean.TRUE);
        transformer.setParameter("generateSectionIds", Boolean.TRUE);
        if (this.shouldUpdateLocalFileReferences) {
            transformer.setParameter("updateExtensionAndPathOfLocalFileReferences", Boolean.TRUE);
        }
        if (this.shouldConvertClassToOutputclass) {
            transformer.setParameter("convertClassToOutputClass", Boolean.TRUE);
        }
        transformer.setParameter("filterDivElements", this.shouldFilterDivElements);
        int headingLevelToSet = ConverterDefaults.DEFAULT_MAX_HEADING_LEVEL_FOR_CREATING_TOPICS;
        if (userInputsProvider.getMaxHeadingLevelForCreatingTopics() != null && userInputsProvider.getMaxHeadingLevelForCreatingTopics() > 0) {
            headingLevelToSet = userInputsProvider.getMaxHeadingLevelForCreatingTopics();
        }
        transformer.setParameter("maxHeadingLevelForNestedTopics", headingLevelToSet);
        String format = userInputsProvider.getFormatForSameTypeReferences();
        if (format != null) {
            transformer.setParameter("local.references.format", format);
        }
        transformer.setParameter("addColspecWithAutoWidth", this.shouldAddAutoWidthColspecs());
        try {
            StringWriter sw = new StringWriter();
            transformer.transform(new StreamSource(contentReader, originalFile.toURI().toString()), new StreamResult(sw));
            String ditaContent = sw.toString();
            conversionResult = ditaContent.startsWith("<dita") ? new ConversionResult(ditaContent, "<!DOCTYPE dita PUBLIC \"-//OASIS//DTD DITA Composite//EN\" \"ditabase.dtd\">", "-//OASIS//DTD DITA Composite//EN", "ditabase.dtd") : new ConversionResult(ditaContent);
        }
        catch (TransformerException e) {
            Throwable exception = e;
            if (e.getException() != null) {
                exception = e.getException();
            }
            throw new TransformerException(exception.getMessage(), exception.getCause());
        }
        return conversionResult;
    }

    public boolean shouldAddAutoWidthColspecs() {
        return false;
    }
}

