/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.batch.converter.core.converters.html;

import com.oxygenxml.batch.converter.core.ConversionInputsProvider;
import com.oxygenxml.batch.converter.core.converters.Converter;
import com.oxygenxml.batch.converter.core.converters.PipelineConverter;
import com.oxygenxml.batch.converter.core.converters.html.CopyXHTMLResourcesConverter;
import com.oxygenxml.batch.converter.core.converters.html.HTML5Cleaner;
import com.oxygenxml.batch.converter.core.converters.html.HtmlToXhtmlConverter;
import com.oxygenxml.batch.converter.core.converters.html.XHTMLToDocbook5Converter;
import com.oxygenxml.batch.converter.core.transformer.TransformerFactoryCreator;
import java.io.File;
import java.util.ArrayList;

public class HtmlToDocbook5Converter
extends PipelineConverter {
    private final boolean shouldCopyResources;

    public HtmlToDocbook5Converter(boolean shoudCopyResources) {
        this.shouldCopyResources = shoudCopyResources;
    }

    @Override
    protected Converter[] getUsedConverters(File fileToConvert, ConversionInputsProvider userInputsProvider, TransformerFactoryCreator transformerCreator) {
        ArrayList<Converter> converters = new ArrayList<Converter>();
        converters.add(new HtmlToXhtmlConverter());
        converters.add(new HTML5Cleaner());
        Boolean shouldForbidCreatingExternalContent = userInputsProvider.getAdditionalOptionValue("forbid.creating.external.content");
        if (this.shouldCopyResources && (shouldForbidCreatingExternalContent == null || !shouldForbidCreatingExternalContent.booleanValue())) {
            converters.add(new CopyXHTMLResourcesConverter());
        }
        converters.add(new XHTMLToDocbook5Converter());
        return converters.toArray(new Converter[0]);
    }
}

