/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.batch.converter.core.converters.html;

import com.oxygenxml.batch.converter.core.ConversionInputsProvider;
import com.oxygenxml.batch.converter.core.converters.ConversionResult;
import com.oxygenxml.batch.converter.core.converters.Converter;
import com.oxygenxml.batch.converter.core.converters.ConverterUtils;
import com.oxygenxml.batch.converter.core.transformer.TransformerFactoryCreator;
import java.io.File;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;

public class HTML5Cleaner
implements Converter {
    @Override
    public ConversionResult convert(File originalFile, Reader contentReader, TransformerFactoryCreator transformerCreator, ConversionInputsProvider userInputsProvider) throws TransformerException {
        ConversionResult conversionResult;
        StringWriter sw = new StringWriter();
        StreamResult result = new StreamResult(sw);
        StreamSource src = new StreamSource(new StringReader("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<xsl:stylesheet xmlns:xsl=\"http://www.w3.org/1999/XSL/Transform\"\n    xmlns:xs=\"http://www.w3.org/2001/XMLSchema\"\n    exclude-result-prefixes=\"xs\"\n    version=\"2.0\">\n<xsl:output method=\"xml\" indent=\"no\"/>\n    <xsl:template match=\"node() | @*\">\n        <xsl:copy>\n            <xsl:apply-templates select=\"node() | @*\"/>\n        </xsl:copy>\n    </xsl:template>\n    \n    <xsl:template match=\"*[local-name()='article'] | *[local-name()='main']\">\n        <xsl:apply-templates/>\n    </xsl:template>\n</xsl:stylesheet>"));
        Transformer transformer = transformerCreator.createTransformer(src);
        try {
            transformer.transform(new StreamSource(contentReader, originalFile.getAbsolutePath()), result);
            conversionResult = new ConversionResult(sw.toString());
        }
        catch (TransformerException e) {
            if (e.getException() != null) {
                throw ConverterUtils.getTransformerException(e.getException());
            }
            throw e;
        }
        return conversionResult;
    }
}

