/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.batch.converter.core.converters.html;

import com.oxygenxml.batch.converter.core.ConversionInputsProvider;
import com.oxygenxml.batch.converter.core.converters.AbstractCopyResourcesConverter;
import com.oxygenxml.batch.converter.core.utils.ConverterFileUtils;
import com.oxygenxml.batch.converter.core.utils.HTMLConstants;
import com.oxygenxml.batch.converter.core.utils.ResourceTypes;
import java.io.File;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.List;
import java.util.Locale;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLFilterImpl;

public class CopyXHTMLResourcesConverter
extends AbstractCopyResourcesConverter {
    @Override
    protected XMLReader createXMLFilterImp(XMLReader xmlReader, final File inputFile, final ConversionInputsProvider userInputsProvider, final List<String> problemsCollector) {
        return new XMLFilterImpl(xmlReader){
            final File inputDir;
            private Deque<String> parentElementsStack;
            {
                super(arg0);
                this.inputDir = inputFile.getParentFile();
                this.parentElementsStack = new ArrayDeque<String>();
            }

            @Override
            public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
                if (atts != null) {
                    if (HTMLConstants.MULTIMEDIA_ELEMS.contains(localName)) {
                        atts = this.processMultimediaElem(atts, localName);
                    } else if ("a".equals(localName) || "object".equals(localName) || "iframe".equals(localName)) {
                        atts = this.processAnchorObjectIFrame(atts);
                    } else if ("source".equals(localName)) {
                        atts = this.processSource(atts);
                    }
                }
                this.parentElementsStack.push(localName);
                super.startElement(uri, localName, qName, atts);
            }

            private Attributes processMultimediaElem(Attributes atts, String localName) {
                String posterValue;
                String srcValue = atts.getValue("src");
                if (CopyXHTMLResourcesConverter.isAlowedToCopy(srcValue)) {
                    atts = CopyXHTMLResourcesConverter.this.copyResourceAndGetUpdatedAttribute(new File(this.inputDir, srcValue), "img".equals(localName) ? ResourceTypes.IMAGE : ResourceTypes.MEDIA, atts, "src", userInputsProvider.getOutputFolder(), problemsCollector);
                }
                if ("video".equals(localName) && CopyXHTMLResourcesConverter.isAlowedToCopy(posterValue = atts.getValue("poster"))) {
                    atts = CopyXHTMLResourcesConverter.this.copyResourceAndGetUpdatedAttribute(new File(this.inputDir, posterValue), ResourceTypes.MEDIA, atts, "poster", userInputsProvider.getOutputFolder(), problemsCollector);
                }
                return atts;
            }

            private Attributes processAnchorObjectIFrame(Attributes atts) {
                String resourceAttr = null;
                String resourceValue = null;
                String[] resAttrs = new String[]{"href", "data", "src"};
                for (int i = 0; i < resAttrs.length && resourceValue == null; ++i) {
                    resourceAttr = resAttrs[i];
                    resourceValue = atts.getValue(resourceAttr);
                }
                if (CopyXHTMLResourcesConverter.isAlowedToCopy(resourceValue)) {
                    File resourceFile = new File(this.inputDir, resourceValue);
                    ResourceTypes resourceType = ResourceTypes.RESOURCE;
                    boolean isAllowedResourceToCopy = false;
                    String resourceFileExtension = ConverterFileUtils.getFileExtension(resourceFile).toLowerCase(Locale.ENGLISH);
                    if (IMAGE_FILES_EXTENSIONS.contains(resourceFileExtension)) {
                        resourceType = ResourceTypes.IMAGE;
                        isAllowedResourceToCopy = true;
                    }
                    if (MEDIA_FILES_EXTENSION.contains(resourceFileExtension)) {
                        resourceType = ResourceTypes.MEDIA;
                        isAllowedResourceToCopy = true;
                    }
                    if (BINARY_FILES_EXTENSIONS.contains(resourceFileExtension)) {
                        isAllowedResourceToCopy = true;
                    }
                    if (isAllowedResourceToCopy) {
                        atts = CopyXHTMLResourcesConverter.this.copyResourceAndGetUpdatedAttribute(resourceFile, resourceType, atts, resourceAttr, userInputsProvider.getOutputFolder(), problemsCollector);
                    }
                }
                return atts;
            }

            private Attributes processSource(Attributes atts) {
                String parentElement = this.parentElementsStack.peek();
                ResourceTypes resourceType = CopyXHTMLResourcesConverter.this.getResourceType(parentElement);
                String srcValue = atts.getValue("src");
                String srcType = "src";
                if (srcValue == null) {
                    srcValue = atts.getValue("srcset");
                    srcType = "srcset";
                }
                if (srcValue != null && CopyXHTMLResourcesConverter.isAlowedToCopy(srcValue)) {
                    File resourceFile = new File(this.inputDir, srcValue);
                    atts = CopyXHTMLResourcesConverter.this.copyResourceAndGetUpdatedAttribute(resourceFile, resourceType, atts, srcType, userInputsProvider.getOutputFolder(), problemsCollector);
                }
                return atts;
            }

            @Override
            public void endElement(String uri, String localName, String qName) throws SAXException {
                this.parentElementsStack.pop();
                super.endElement(uri, localName, qName);
            }
        };
    }

    @Override
    protected ResourceTypes getResourceType(String parentElement) {
        ResourceTypes resourceType = parentElement.equals("picture") ? ResourceTypes.IMAGE : (parentElement.equals("audio") || parentElement.equals("video") ? ResourceTypes.MEDIA : ResourceTypes.RESOURCE);
        return resourceType;
    }
}

