/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.batch.converter.core.converters.docbook;

import com.oxygenxml.batch.converter.core.ConversionInputsProvider;
import com.oxygenxml.batch.converter.core.converters.AbstractCopyResourcesConverter;
import com.oxygenxml.batch.converter.core.utils.ResourceTypes;
import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLFilterImpl;

public class CopyDocbookResourcesConverter
extends AbstractCopyResourcesConverter {
    private static final String IMAGE_DATA = "imagedata";
    private static final String GRAPHIC = "graphic";
    private static final String AUDIO_DATA = "audiodata";
    private static final String VIDEO_DATA = "videodata";
    private static final Set<String> MULTIMEDIA_ELEMS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("imagedata", "graphic", "audiodata", "videodata")));
    private static final String FILEREF_ATTR = "fileref";

    @Override
    protected XMLReader createXMLFilterImp(XMLReader xmlReader, final File inputFile, final ConversionInputsProvider userInputsProvider, final List<String> problemsCollector) {
        return new XMLFilterImpl(xmlReader){
            final File inputDir;
            {
                super(arg0);
                this.inputDir = inputFile.getParentFile();
            }

            @Override
            public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
                if (atts != null && MULTIMEDIA_ELEMS.contains(localName)) {
                    atts = this.processMultimediaElem(atts, localName);
                }
                super.startElement(uri, localName, qName, atts);
            }

            private Attributes processMultimediaElem(Attributes atts, String localName) {
                String srcValue = atts.getValue(CopyDocbookResourcesConverter.FILEREF_ATTR);
                if (CopyDocbookResourcesConverter.isAlowedToCopy(srcValue)) {
                    File imageFile = new File(this.inputDir, srcValue);
                    ResourceTypes resourceType = CopyDocbookResourcesConverter.this.getResourceType(localName);
                    atts = CopyDocbookResourcesConverter.this.copyResourceAndGetUpdatedAttribute(imageFile, resourceType, atts, CopyDocbookResourcesConverter.FILEREF_ATTR, userInputsProvider.getOutputFolder(), problemsCollector);
                }
                return atts;
            }
        };
    }

    @Override
    protected ResourceTypes getResourceType(String parentElement) {
        ResourceTypes resourceType = IMAGE_DATA.equals(parentElement) || GRAPHIC.equals(parentElement) ? ResourceTypes.IMAGE : (AUDIO_DATA.equals(parentElement) || VIDEO_DATA.equals(parentElement) ? ResourceTypes.MEDIA : ResourceTypes.RESOURCE);
        return resourceType;
    }
}

