/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.batch.converter.core.converters;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ro.sync.basic.util.URLUtil;

public final class ConvertedFilesManager {
    private final Map<File, File> convertedFiles = new HashMap<File, File>();
    private static ConvertedFilesManager instance;

    private ConvertedFilesManager() {
    }

    public static ConvertedFilesManager getInstance() {
        if (instance == null) {
            instance = new ConvertedFilesManager();
        }
        return instance;
    }

    public void clearConvertedFiles() {
        this.convertedFiles.clear();
    }

    public boolean isFileAlreadyConverted(File fileToCheck) {
        return this.convertedFiles.containsKey(URLUtil.getCanonicalFile((File)fileToCheck));
    }

    public void addConvertedFile(File inputFile, File outputFile) {
        this.convertedFiles.put(URLUtil.getCanonicalFile((File)inputFile), outputFile);
    }

    public File getOutputFile(File inputFile) {
        return this.convertedFiles.get(URLUtil.getCanonicalFile((File)inputFile));
    }

    public List<File> getAllOutputFiles() {
        return new ArrayList<File>(this.convertedFiles.values());
    }
}

