/*
 * Decompiled with CFR 0.152.
 */
package com.xmlcalabash.util;

import com.xmlcalabash.core.XProcConstants;
import com.xmlcalabash.core.XProcException;
import com.xmlcalabash.core.XProcRuntime;
import com.xmlcalabash.util.S9apiUtils;
import com.xmlcalabash.util.URIUtils;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.Configuration;
import net.sf.saxon.lib.ModuleURIResolver;
import net.sf.saxon.lib.ResourceRequest;
import net.sf.saxon.lib.ResourceResolver;
import net.sf.saxon.lib.StandardModuleURIResolver;
import net.sf.saxon.lib.StandardUnparsedTextResolver;
import net.sf.saxon.lib.UnparsedTextURIResolver;
import net.sf.saxon.s9api.DocumentBuilder;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.XdmNode;
import net.sf.saxon.trans.XPathException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;
import org.xmlresolver.Resolver;
import org.xmlresolver.sources.ResolverSAXSource;

public class XProcURIResolver
implements URIResolver,
EntityResolver,
ModuleURIResolver,
UnparsedTextURIResolver,
ResourceResolver {
    private Logger logger = LoggerFactory.getLogger(XProcURIResolver.class);
    private URIResolver uriResolver = null;
    private EntityResolver entityResolver = null;
    private ModuleURIResolver moduleURIResolver = null;
    private UnparsedTextURIResolver unparsedTextResolver = null;
    private XProcRuntime runtime = null;
    private HashMap<String, XdmNode> cache = new HashMap();
    private Resolver catalogResolver = null;
    private static boolean useCache = true;

    public XProcURIResolver(XProcRuntime runtime) {
        this.runtime = runtime;
    }

    public void setUnderlyingURIResolver(URIResolver resolver) {
        this.uriResolver = resolver;
        if (this.catalogResolver == null && resolver instanceof Resolver) {
            this.catalogResolver = (Resolver)resolver;
        }
    }

    public URIResolver getUnderlyingURIResolver() {
        return this.uriResolver;
    }

    public void setUnderlyingEntityResolver(EntityResolver resolver) {
        this.entityResolver = resolver;
    }

    public EntityResolver getUnderlyingEntityResolver() {
        return this.entityResolver;
    }

    public void setUnderlyingUnparsedTextURIResolver(UnparsedTextURIResolver resolver) {
        this.unparsedTextResolver = resolver;
    }

    public UnparsedTextURIResolver getUnderlyingUnparsedTextURIResolver() {
        return this.unparsedTextResolver;
    }

    public void setUnderlyingModuleURIResolver(ModuleURIResolver resolver) {
        this.moduleURIResolver = resolver;
    }

    public ModuleURIResolver getUnderlyingModuleURIResolver() {
        return this.moduleURIResolver;
    }

    public void addCatalogs(List<String> catalogs) {
        if (this.catalogResolver == null) {
            this.logger.info("Not adding catalogs to resolver, no catalog resolver is known");
            return;
        }
        String resolverVersion = null;
        try {
            Method version = Resolver.class.getMethod("version", new Class[0]);
            resolverVersion = (String)version.invoke(null, new Object[0]);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException ex) {
            resolverVersion = "1.0";
        }
        try {
            if (resolverVersion.startsWith("1") || resolverVersion.startsWith("2")) {
                Class<?> catsourceClass = Class.forName("org.xmlresolver.CatalogSource");
                Class<?> cl = Class.forName("org.xmlresolver.CatalogSource$InputSourceCatalogSource");
                Constructor<?> catsourceConstructor = cl.getDeclaredConstructor(InputSource.class);
                cl = Class.forName("org.xmlresolver.Resolver");
                Method getCatalogMethod = cl.getMethod("getCatalog", new Class[0]);
                Object getCatalog = getCatalogMethod.invoke((Object)this.catalogResolver, new Object[0]);
                cl = Class.forName("org.xmlresolver.Catalog");
                Method addSource = cl.getMethod("addSource", catsourceClass);
                for (String catalog : catalogs) {
                    this.logger.debug("Adding catalog to resolver: " + catalog);
                    try {
                        URL cat = new URL(catalog);
                        InputSource source = new InputSource(cat.openStream());
                        source.setSystemId(catalog);
                        Object catsource = catsourceConstructor.newInstance(source);
                        addSource.invoke(getCatalog, catsource);
                    }
                    catch (MalformedURLException e) {
                        this.logger.info("Malformed catalog URI in jar file: " + catalog);
                    }
                    catch (IOException e) {
                        this.logger.info("I/O error reading catalog URI in jar file: " + catalog);
                    }
                }
            } else {
                Class<?> resolverClass = Class.forName("org.xmlresolver.Resolver");
                Class<?> configClass = Class.forName("org.xmlresolver.XMLResolverConfiguration");
                Class<?> resolverFeatureClass = Class.forName("org.xmlresolver.ResolverFeature");
                Method getConfig = resolverClass.getMethod("getConfiguration", new Class[0]);
                Method getFeature = configClass.getMethod("getFeature", resolverFeatureClass);
                Method setFeature = configClass.getMethod("setFeature", resolverFeatureClass, Object.class);
                Field catalogFilesField = resolverFeatureClass.getField("CATALOG_FILES");
                Object catalogFilesFeature = catalogFilesField.get(null);
                Object config = getConfig.invoke((Object)this.catalogResolver, new Object[0]);
                Object catalogFiles = getFeature.invoke(config, catalogFilesFeature);
                ArrayList<String> curCatalogs = new ArrayList<String>((List)catalogFiles);
                for (String catalog : catalogs) {
                    this.logger.debug("Adding catalog to resolver: " + catalog);
                    try {
                        URL cat = new URL(catalog);
                        curCatalogs.add(cat.toString());
                    }
                    catch (MalformedURLException e) {
                        this.logger.info("Malformed catalog URI in jar file: " + catalog);
                    }
                }
                setFeature.invoke(config, catalogFilesFeature, curCatalogs);
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchFieldException | NoSuchMethodException | InvocationTargetException ex) {
            this.logger.info("Failed to add catalog to resolver: " + ex.getMessage());
        }
    }

    public void cache(XdmNode doc, URI baseURI) {
        XdmNode root = S9apiUtils.getDocumentElement(doc);
        URI docURI = baseURI.resolve(root.getBaseURI());
        if (useCache) {
            this.cache.put(docURI.toASCIIString(), doc);
        }
    }

    @Override
    public Source resolve(String href, String base) throws TransformerException {
        this.logger.trace("URIResolver(" + href + "," + base + ")");
        String uri = null;
        if (base == null) {
            try {
                URL url = new URL(href);
                uri = url.toURI().toASCIIString();
            }
            catch (MalformedURLException mue) {
                this.logger.trace("MalformedURLException on " + href);
            }
            catch (URISyntaxException use) {
                this.logger.trace("URISyntaxException on " + href);
            }
        } else {
            try {
                URI baseURI = new URI(base);
                uri = baseURI.resolve(href).toASCIIString();
            }
            catch (URISyntaxException use) {
                this.logger.trace("URISyntaxException resolving base and href: " + base + " : " + href);
            }
        }
        this.logger.trace("Resolved: " + uri);
        if (this.cache.containsKey(uri)) {
            this.logger.trace("Returning cached document.");
            return this.cache.get(uri).asSource();
        }
        if (this.uriResolver != null) {
            SAXSource ssource;
            XMLReader reader;
            this.logger.trace("uriResolver.resolve(" + href + "," + base + ")");
            Source resolved = this.uriResolver.resolve(href, base);
            if (resolved != null && resolved instanceof SAXSource && (reader = (ssource = (SAXSource)resolved).getXMLReader()) == null) {
                try {
                    SAXParserFactory saxParserFactory = SAXParserFactory.newInstance();
                    saxParserFactory.setNamespaceAware(true);
                    reader = saxParserFactory.newSAXParser().getXMLReader();
                    reader.setEntityResolver(this);
                    ssource.setXMLReader(reader);
                }
                catch (SAXException sAXException) {
                }
                catch (ParserConfigurationException parserConfigurationException) {
                    // empty catch block
                }
            }
            return resolved;
        }
        return null;
    }

    public XdmNode parse(String href, String base) {
        return this.parse(href, base, false);
    }

    public XdmNode parse(String href, String base, boolean dtdValidate) {
        Source source = null;
        href = URIUtils.encode(href);
        this.logger.trace("Attempting to parse: " + href + " (" + base + ")");
        try {
            source = this.resolve(href, base);
        }
        catch (TransformerException te) {
            throw new XProcException(XProcConstants.dynamicError(9), (Throwable)te);
        }
        if (source == null) {
            try {
                XMLReader reader;
                URI baseURI = new URI(base);
                URI resURI = baseURI.resolve(href);
                String path = baseURI.toASCIIString();
                int pos = path.indexOf("!");
                if (pos > 0 && (path.startsWith("jar:file:") || path.startsWith("jar:http:") || path.startsWith("jar:https:"))) {
                    String fakeURIstr = "http://example.com";
                    String subpath = path.substring(pos + 1);
                    fakeURIstr = subpath.startsWith("/") ? fakeURIstr + subpath : fakeURIstr + "/" + subpath;
                    URI fakeURI = new URI(fakeURIstr);
                    resURI = fakeURI.resolve(href);
                    fakeURIstr = path.substring(0, pos + 1) + resURI.getPath();
                    resURI = new URI(fakeURIstr);
                }
                if ((reader = ((SAXSource)(source = new SAXSource(new InputSource(resURI.toASCIIString())))).getXMLReader()) == null) {
                    try {
                        reader = XMLReaderFactory.createXMLReader();
                        ((SAXSource)source).setXMLReader(reader);
                        reader.setEntityResolver(this);
                    }
                    catch (SAXException sAXException) {}
                }
            }
            catch (URISyntaxException use) {
                throw new XProcException(use);
            }
        }
        DocumentBuilder builder = this.runtime.getProcessor().newDocumentBuilder();
        builder.setDTDValidation(dtdValidate);
        builder.setLineNumbering(true);
        try {
            return builder.build(source);
        }
        catch (SaxonApiException sae) {
            String msg = sae.getMessage();
            if (msg.contains("validation")) {
                throw XProcException.stepError(27, (Exception)((Object)sae));
            }
            if (msg.contains("HTTP response code: 403 ")) {
                throw XProcException.dynamicError(21);
            }
            throw XProcException.dynamicError(11, (Exception)((Object)sae));
        }
    }

    public XdmNode parse(InputSource isource) {
        try {
            XMLReader reader = XMLReaderFactory.createXMLReader();
            reader.setEntityResolver(this);
            SAXSource source = new SAXSource(reader, isource);
            DocumentBuilder builder = this.runtime.getProcessor().newDocumentBuilder();
            builder.setLineNumbering(true);
            builder.setDTDValidation(false);
            return builder.build((Source)source);
        }
        catch (SaxonApiException sae) {
            String msg = sae.getMessage();
            if (msg.contains("validation")) {
                throw XProcException.stepError(27, (Exception)((Object)sae));
            }
            if (msg.contains("HTTP response code: 403 ")) {
                throw XProcException.dynamicError(21);
            }
            throw XProcException.dynamicError(11, (Exception)((Object)sae));
        }
        catch (SAXException e) {
            throw new XProcException(e);
        }
    }

    @Override
    public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
        this.logger.trace("ResolveEntity(" + publicId + "," + systemId + ")");
        if (systemId == null) {
            return null;
        }
        try {
            URI baseURI = new URI(systemId);
            String uri = baseURI.toASCIIString();
            if (this.cache.containsKey(uri)) {
                this.logger.trace("Returning cached document.");
                return S9apiUtils.xdmToInputSource(this.runtime, this.cache.get(uri));
            }
        }
        catch (URISyntaxException use) {
            this.logger.trace("URISyntaxException resolving entityResolver systemId: " + systemId);
        }
        catch (SaxonApiException sae) {
            throw new XProcException(sae);
        }
        if (this.entityResolver != null) {
            InputSource r = this.entityResolver.resolveEntity(publicId, systemId);
            return r;
        }
        return null;
    }

    public StreamSource[] resolve(String moduleURI, String baseURI, String[] locations) throws XPathException {
        if (this.moduleURIResolver != null) {
            return this.moduleURIResolver.resolve(moduleURI, baseURI, locations);
        }
        StandardModuleURIResolver resolver = new StandardModuleURIResolver(this.runtime.getProcessor().getUnderlyingConfiguration());
        return resolver.resolve(moduleURI, baseURI, locations);
    }

    public Reader resolve(URI uri, String encoding, Configuration configuration) throws XPathException {
        this.unparsedTextResolver = this.catalogResolver != null ? new CatalogUnparsedTextURIResolver(this.catalogResolver) : new StandardUnparsedTextResolver();
        return this.unparsedTextResolver.resolve(uri, encoding, configuration);
    }

    public Source resolve(ResourceRequest request) throws XPathException {
        if (request.uriIsNamespace) {
            try {
                Source source = this.catalogResolver.resolveNamespace(request.uri, request.nature, request.purpose);
                if (source == null && request.baseUri != null) {
                    URI baseURI = new URI(request.baseUri);
                    source = this.catalogResolver.resolveNamespace(baseURI.resolve(request.uri).toString(), request.nature, request.purpose);
                }
                return source;
            }
            catch (IllegalArgumentException | URISyntaxException | TransformerException e) {
                throw new XPathException("Exception from catalog resolver resolveNamespace(): ", (Throwable)e);
            }
        }
        if ("https://www.iana.org/assignments/media-types/application/xml-dtd".equals(request.nature)) {
            return null;
        }
        if ("https://www.iana.org/assignments/media-types/application/xml-external-parsed-entity".equals(request.nature)) {
            try {
                InputSource source = this.catalogResolver.resolveEntity(request.entityName, request.publicId, request.baseUri, request.uri);
                if (source != null) {
                    return new SAXSource(source);
                }
                return null;
            }
            catch (IOException | IllegalArgumentException | SAXException e) {
                throw new XPathException("Exception from catalog resolver resolveEntity():", (Throwable)e);
            }
        }
        String href = request.relativeUri == null ? request.uri : request.relativeUri;
        String baseUri = request.baseUri == null ? request.uri : request.baseUri;
        try {
            Source source = this.catalogResolver.resolve(href, baseUri);
            if ("https://www.iana.org/assignments/media-types/text/plain".equals(request.nature) || "https://www.iana.org/assignments/media-types/application/binary".equals(request.nature)) {
                try {
                    URL url = new URL(source.getSystemId());
                    return new StreamSource(url.openStream(), source.getSystemId());
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return source;
        }
        catch (IllegalArgumentException | TransformerException e) {
            throw new XPathException("Exception from catalog resolver resolverURI()", (Throwable)e);
        }
    }

    private class CatalogUnparsedTextURIResolver
    implements UnparsedTextURIResolver {
        private final Resolver resolver;

        public CatalogUnparsedTextURIResolver(Resolver resolver) {
            this.resolver = resolver;
        }

        public Reader resolve(URI uri, String encoding, Configuration configuration) throws XPathException {
            InputStreamReader reader = null;
            try {
                Source source = this.resolver.resolveNamespace(uri.toString(), "https://www.iana.org/assignments/media-types/text/plain", null);
                if (source instanceof ResolverSAXSource) {
                    InputSource isource = ((ResolverSAXSource)source).getInputSource();
                    reader = new InputStreamReader(isource.getByteStream());
                } else if (source != null) {
                    URL url = new URL(source.getSystemId());
                    reader = new InputStreamReader(url.openStream());
                }
            }
            catch (IOException | TransformerException ex) {
                reader = null;
            }
            return reader;
        }
    }
}

