/*
 * Decompiled with CFR 0.152.
 */
package com.xmlcalabash.util;

import com.xmlcalabash.core.XProcConfiguration;
import com.xmlcalabash.core.XProcConstants;
import com.xmlcalabash.core.XProcException;
import com.xmlcalabash.core.XProcRuntime;
import com.xmlcalabash.runtime.XLibrary;
import com.xmlcalabash.util.Closer;
import com.xmlcalabash.util.Input;
import com.xmlcalabash.util.JSONtoXML;
import com.xmlcalabash.util.LogOptions;
import com.xmlcalabash.util.Output;
import com.xmlcalabash.util.TreeWriter;
import com.xmlcalabash.util.TypeUtils;
import com.xmlcalabash.util.URIUtils;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URLConnection;
import java.nio.channels.Channels;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.transform.Source;
import javax.xml.transform.sax.SAXSource;
import net.sf.saxon.om.AttributeInfo;
import net.sf.saxon.om.AttributeMap;
import net.sf.saxon.om.EmptyAttributeMap;
import net.sf.saxon.om.NamespaceMap;
import net.sf.saxon.om.NamespaceUri;
import net.sf.saxon.om.SingletonAttributeMap;
import net.sf.saxon.s9api.DocumentBuilder;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.XdmNode;
import org.xml.sax.InputSource;

public class UserArgs {
    protected boolean needsCheck = false;
    protected Boolean debug = null;
    protected Boolean showMessages = null;
    protected Output profile = null;
    protected boolean showVersion = false;
    protected String saxonProcessor = null;
    protected Input saxonConfig = null;
    protected boolean schemaAware = false;
    protected Boolean safeMode = null;
    protected Input config = null;
    protected String logStyle = null;
    protected String entityResolverClass = null;
    protected String uriResolverClass = null;
    protected Input pipeline = null;
    protected List<Input> libraries = new ArrayList<Input>();
    protected Map<String, Output> outputs = new HashMap<String, Output>();
    protected Map<String, NamespaceUri> bindings = new HashMap<String, NamespaceUri>();
    protected List<StepArgs> steps = new ArrayList<StepArgs>();
    protected StepArgs curStep = new StepArgs();
    protected StepArgs lastStep = null;
    protected boolean extensionValues = false;
    protected boolean allowXPointerOnText = false;
    protected boolean allowTextResults = false;
    protected boolean useXslt10 = false;
    protected boolean htmlSerializer = false;
    protected boolean ignoreInvalidXmlBase = false;
    protected boolean transparentJSON = false;
    protected String jsonFlavor = null;
    protected Integer piperackPort = null;
    protected Integer piperackExpires = null;
    protected Map<String, String> serParams = new HashMap<String, String>();

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public void setShowMessages(boolean show) {
        this.showMessages = show;
    }

    protected void setProfile(Output profile) {
        this.needsCheck = true;
        if (this.profile != null && profile != null) {
            throw new XProcException("Multiple profile are not supported.");
        }
        this.profile = profile;
    }

    public void setProfile(String profile) {
        if ("-".equals(profile)) {
            this.setProfile(new Output(System.out));
        } else {
            this.setProfile(new Output("file://" + this.fixUpURI(profile)));
        }
    }

    public void setProfile(OutputStream outputStream) {
        this.setProfile(new Output(outputStream));
    }

    public boolean isShowVersion() {
        return this.showVersion;
    }

    public void setShowVersion(boolean showVersion) {
        this.showVersion = showVersion;
    }

    public void setPiperackPort(int port) {
        this.piperackPort = port;
    }

    public void setPiperackExpires(int seconds) {
        this.piperackExpires = seconds;
    }

    public void setSaxonProcessor(String saxonProcessor) {
        this.needsCheck = true;
        this.saxonProcessor = saxonProcessor;
        if (!("he".equals(saxonProcessor) || "pe".equals(saxonProcessor) || "ee".equals(saxonProcessor))) {
            throw new XProcException("Invalid Saxon processor option: '" + saxonProcessor + "'. Must be 'he' (default), 'pe' or 'ee'.");
        }
    }

    protected void setSaxonConfig(Input saxonConfig) {
        this.needsCheck = true;
        if (this.saxonConfig != null && saxonConfig != null) {
            throw new XProcException("Multiple saxonConfig are not supported.");
        }
        this.saxonConfig = saxonConfig;
    }

    public void setSaxonConfig(String saxonConfig) {
        if ("-".equals(saxonConfig)) {
            this.setSaxonConfig(new Input(System.in, "<stdin>"));
        } else {
            this.setSaxonConfig(new Input("file://" + this.fixUpURI(saxonConfig)));
        }
    }

    public void setSaxonConfig(InputStream inputStream, String uri) {
        this.setSaxonConfig(new Input(inputStream, uri));
    }

    public void setSchemaAware(boolean schemaAware) {
        this.needsCheck = true;
        this.schemaAware = schemaAware;
    }

    public void setSafeMode(boolean safeMode) {
        this.safeMode = safeMode;
    }

    protected void setConfig(Input config) {
        if (this.config != null && config != null) {
            throw new XProcException("Multiple config are not supported.");
        }
        this.config = config;
    }

    public void setConfig(String config) {
        if ("-".equals(config)) {
            this.setConfig(new Input(System.in, "<stdin>"));
        } else {
            this.setConfig(new Input("file://" + this.fixUpURI(config)));
        }
    }

    public void setConfig(InputStream inputStream, String uri) {
        this.setConfig(new Input(inputStream, uri));
    }

    public void setLogStyle(String logStyle) {
        this.logStyle = logStyle;
        if (!("off".equals(logStyle) || "plain".equals(logStyle) || "wrapped".equals(logStyle) || "directory".equals(logStyle))) {
            throw new XProcException("Invalid log style: '" + logStyle + "'. Must be 'off', 'plain', 'wrapped' (default) or 'directory'.");
        }
    }

    public void setEntityResolverClass(String entityResolverClass) {
        this.entityResolverClass = entityResolverClass;
    }

    public void setUriResolverClass(String uriResolverClass) {
        this.uriResolverClass = uriResolverClass;
    }

    public Input getPipeline() {
        this.checkArgs();
        return this.pipeline;
    }

    protected void setPipeline(Input pipeline) {
        this.needsCheck = true;
        if (this.pipeline != null && pipeline != null) {
            throw new XProcException("Multiple pipelines are not supported.");
        }
        this.pipeline = pipeline;
    }

    public void setPipeline(String uri) {
        this.setPipeline(new Input(uri));
    }

    public void setPipeline(InputStream inputStream, String uri) {
        this.setPipeline(new Input(inputStream, uri));
    }

    public void addLibrary(String libraryURI) {
        this.needsCheck = true;
        this.libraries.add(new Input(libraryURI));
    }

    public void addLibrary(InputStream libraryInputStream, String libraryURI) {
        this.needsCheck = true;
        this.libraries.add(new Input(libraryInputStream, libraryURI));
    }

    public Map<String, Output> getOutputs() {
        this.checkArgs();
        return Collections.unmodifiableMap(this.outputs);
    }

    public void addOutput(String port, String uri) {
        if (this.outputs.containsKey(port)) {
            if (port == null) {
                throw new XProcException("Duplicate output binding for default output port.");
            }
            throw new XProcException("Duplicate output binding: '" + port + "'.");
        }
        if ("-".equals(uri)) {
            this.outputs.put(port, new Output(uri));
        } else {
            URI cwd = URIUtils.cwdAsURI();
            this.outputs.put(port, new Output(cwd.resolve(uri).toASCIIString()));
        }
    }

    public void addOutput(String port, OutputStream outputStream) {
        if (this.outputs.containsKey(port)) {
            if (port == null) {
                throw new XProcException("Duplicate output binding for default output port.");
            }
            throw new XProcException("Duplicate output binding: '" + port + "'.");
        }
        this.outputs.put(port, new Output(outputStream));
    }

    public void addBinding(String prefix, NamespaceUri uri) {
        if (this.bindings.containsKey(prefix)) {
            throw new XProcException("Duplicate prefix binding: '" + prefix + "'.");
        }
        this.bindings.put(prefix, uri);
    }

    public void setCurStepName(String name) {
        this.needsCheck = true;
        this.curStep.setName(name);
        this.steps.add(this.curStep);
        this.lastStep = this.curStep;
        this.curStep = new StepArgs();
    }

    public Set<String> getInputPorts() {
        this.checkArgs();
        if (this.steps.size() != 0) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(this.curStep.inputs.keySet());
    }

    public List<Input> getInputs(String port) {
        this.checkArgs();
        if (this.steps.size() != 0) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.curStep.inputs.get(port));
    }

    public void addInput(String port, String uri, Input.Type type) {
        this.addInput(port, uri, type, null);
    }

    public void addInput(String port, String uri, Input.Type type, String contentType) {
        if ("-".equals(uri) || "p:empty".equals(uri)) {
            this.curStep.addInput(port, uri, type, contentType);
        } else {
            URI cwd = URIUtils.cwdAsURI();
            this.curStep.addInput(port, cwd.resolve(uri).toASCIIString(), type, contentType);
        }
    }

    public void addInput(String port, InputStream inputStream, String uri, Input.Type type) throws IOException {
        this.addInput(port, inputStream, uri, type, null);
    }

    public void addInput(String port, InputStream inputStream, String uri, Input.Type type, String contentType) throws IOException {
        inputStream = new BufferedInputStream(inputStream);
        contentType = contentType == null || "content/unknown".equals(contentType) ? URLConnection.guessContentTypeFromStream(inputStream) : contentType;
        contentType = contentType == null || "content/unknown".equals(contentType) ? URLConnection.guessContentTypeFromName(uri) : contentType;
        this.curStep.addInput(port, inputStream, uri, type, contentType);
    }

    public void setDefaultInputPort(String port) {
        if (this.curStep.inputs.containsKey(null)) {
            this.curStep.inputs.put(port, this.curStep.inputs.remove(null));
        }
    }

    public Set<String> getParameterPorts() {
        this.checkArgs();
        if (this.steps.size() != 0) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(this.curStep.params.keySet());
    }

    public Map<QName, String> getParameters(String port) {
        this.checkArgs();
        if (this.steps.size() != 0) {
            return Collections.emptyMap();
        }
        return Collections.unmodifiableMap(this.curStep.params.get(port));
    }

    public void addParam(String name, String value) {
        this.needsCheck = true;
        String port = "*";
        int cpos = name.indexOf("@");
        if (cpos > 0) {
            port = name.substring(0, cpos);
            name = name.substring(cpos + 1);
        }
        this.curStep.addParameter(port, name, value);
    }

    public void addParam(String port, String name, String value) {
        this.needsCheck = true;
        this.curStep.addParameter(port, name, value);
    }

    public Set<QName> getOptionNames() {
        this.checkArgs();
        if (this.steps.size() != 0) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(this.curStep.options.keySet());
    }

    public String getOption(QName name) {
        this.checkArgs();
        if (this.steps.size() != 0) {
            return null;
        }
        return this.curStep.options.get(name);
    }

    public void addOption(String name, String value) {
        this.needsCheck = true;
        if (this.lastStep != null) {
            this.lastStep.addOption(name, value);
        } else {
            this.curStep.addOption(name, value);
        }
    }

    public void setExtensionValues(boolean extensionValues) {
        this.extensionValues = extensionValues;
    }

    public void setAllowXPointerOnText(boolean allowXPointerOnText) {
        this.allowXPointerOnText = allowXPointerOnText;
    }

    public void setAllowTextResults(boolean allowTextResults) {
        this.allowTextResults = allowTextResults;
    }

    public void setUseXslt10(boolean useXslt10) {
        this.useXslt10 = useXslt10;
    }

    public void setHtmlSerializer(boolean htmlSerializer) {
        this.htmlSerializer = htmlSerializer;
    }

    public void setIgnoreInvalidXmlBase(boolean ignore) {
        this.ignoreInvalidXmlBase = ignore;
    }

    public void setTransparentJSON(boolean transparentJSON) {
        this.transparentJSON = transparentJSON;
    }

    public void setJsonFlavor(String jsonFlavor) {
        this.jsonFlavor = jsonFlavor;
        if (jsonFlavor != null && !JSONtoXML.knownFlavor(jsonFlavor)) {
            throw new XProcException("Unknown JSON flavor: '" + jsonFlavor + "'.");
        }
    }

    public void setSerializationParameter(String port, String param, String value) {
        if (port == null) {
            port = "*";
        }
        if (!(param.equals("byte-order-mark") || param.equals("cdata-section-elements") || param.equals("escape-uri-attributes") || param.equals("include-content-type") || param.equals("indent") || param.equals("omit-xml-declaration") || param.equals("undeclare-prefixes") || param.equals("method") || param.equals("doctype-public") || param.equals("doctype-system") || param.equals("encoding") || param.equals("media-type") || param.equals("normalization-form") || param.equals("standalone") || param.equals("version"))) {
            throw new XProcException("Unsupported or unrecognized serialization parameter: " + param);
        }
        this.serParams.put(port + ":" + param, value);
    }

    public String getSerializationParameter(String port, String param) {
        return this.serParams.getOrDefault(port + ":" + param, null);
    }

    public String getSerializationParameter(String param) {
        return this.serParams.getOrDefault("*:" + param, null);
    }

    public void checkArgs() {
        if (this.needsCheck) {
            if (this.hasImplicitPipelineInternal() && this.pipeline != null) {
                throw new XProcException("You can specify a library and / or steps or a pipeline, but not both.");
            }
            if (this.saxonConfig != null) {
                if (this.schemaAware) {
                    throw new XProcException("Specifying schema-aware processing is an error if you specify a Saxon configuration file.");
                }
                if (this.saxonProcessor != null) {
                    throw new XProcException("Specifying a processor type is an error if you specify a Saxon configuration file.");
                }
            }
            if (this.schemaAware && this.saxonProcessor != null && !"ee".equals(this.saxonProcessor)) {
                throw new XProcException("Schema-aware processing can only be used with saxon processor \"ee\".");
            }
            for (StepArgs step : this.steps) {
                step.checkArgs();
            }
            if (!this.steps.contains(this.curStep)) {
                this.curStep.checkArgs();
            }
            this.needsCheck = false;
        }
    }

    public XProcConfiguration createConfiguration() {
        this.checkArgs();
        XProcConfiguration config = null;
        try {
            String proc = this.saxonProcessor;
            if (this.schemaAware) {
                proc = "ee";
            }
            config = this.saxonConfig != null ? new XProcConfiguration(this.saxonConfig) : (proc != null ? new XProcConfiguration(proc, this.schemaAware) : new XProcConfiguration());
        }
        catch (Exception e) {
            System.err.println("FATAL: Failed to parse Saxon configuration file.");
            System.err.println(e);
            System.exit(2);
        }
        if (this.config != null) {
            try {
                InputStream instream;
                switch (this.config.getKind()) {
                    case URI: {
                        URI furi = URI.create(this.config.getUri());
                        instream = new FileInputStream(new File(furi));
                        break;
                    }
                    case INPUT_STREAM: {
                        instream = this.config.getInputStream();
                        break;
                    }
                    default: {
                        throw new UnsupportedOperationException(String.format("Unsupported config kind '%s'", new Object[]{this.config.getKind()}));
                    }
                }
                SAXSource source = new SAXSource(new InputSource(instream));
                DocumentBuilder builder = config.getProcessor().newDocumentBuilder();
                XdmNode doc = builder.build((Source)source);
                config.parse(doc);
            }
            catch (Exception e) {
                System.err.println("FATAL: Failed to parse configuration file.");
                System.err.println(e);
                System.exit(3);
            }
        }
        if (this.logStyle != null) {
            switch (this.logStyle) {
                case "off": {
                    config.logOpt = LogOptions.OFF;
                    break;
                }
                case "plain": {
                    config.logOpt = LogOptions.PLAIN;
                    break;
                }
                case "directory": {
                    config.logOpt = LogOptions.DIRECTORY;
                    break;
                }
                default: {
                    config.logOpt = LogOptions.WRAPPED;
                }
            }
        }
        if (this.uriResolverClass != null) {
            config.uriResolver = this.uriResolverClass;
        }
        if (this.entityResolverClass != null) {
            config.entityResolver = this.entityResolverClass;
        }
        if (this.safeMode != null) {
            config.safeMode = this.safeMode;
        }
        if (this.debug != null) {
            config.debug = this.debug;
        }
        if (this.showMessages != null) {
            config.showMessages = this.showMessages;
        }
        if (this.profile != null) {
            config.profile = this.profile;
        }
        config.extensionValues |= this.extensionValues;
        config.xpointerOnText |= this.allowXPointerOnText;
        config.ignoreInvalidXmlBase |= this.ignoreInvalidXmlBase;
        config.transparentJSON |= this.transparentJSON;
        if (this.jsonFlavor != null && !JSONtoXML.knownFlavor(this.jsonFlavor)) {
            config.jsonFlavor = this.jsonFlavor;
        }
        config.allowTextResults |= this.allowTextResults;
        config.useXslt10 |= this.useXslt10;
        config.htmlSerializer |= this.htmlSerializer;
        if (this.piperackPort != null) {
            config.piperackPort = this.piperackPort;
        }
        if (this.piperackExpires != null) {
            config.piperackDefaultExpires = this.piperackExpires;
        }
        return config;
    }

    private boolean hasImplicitPipelineInternal() {
        return this.steps.size() > 0 || this.libraries.size() > 0;
    }

    public boolean hasImplicitPipeline() {
        this.checkArgs();
        return this.hasImplicitPipelineInternal();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XdmNode getImplicitPipeline(XProcRuntime runtime) throws IOException {
        this.checkArgs();
        if (this.steps.size() == 0 && this.libraries.size() > 0) {
            try {
                Input library = this.libraries.get(0);
                if (library.getKind() == Input.Kind.INPUT_STREAM) {
                    InputStream libraryInputStream = library.getInputStream();
                    FileOutputStream fileOutputStream = null;
                    try {
                        Iterator<Input> tempLibrary = File.createTempFile("calabashLibrary", null);
                        ((File)((Object)tempLibrary)).deleteOnExit();
                        fileOutputStream = new FileOutputStream((File)((Object)tempLibrary));
                        fileOutputStream.getChannel().transferFrom(Channels.newChannel(libraryInputStream), 0L, Long.MAX_VALUE);
                        this.libraries.set(0, new Input(((File)((Object)tempLibrary)).toURI().toASCIIString()));
                    }
                    catch (Throwable throwable) {
                        Closer.close(fileOutputStream);
                        libraryInputStream.close();
                        throw throwable;
                    }
                    Closer.close(fileOutputStream);
                    libraryInputStream.close();
                }
                XLibrary xLibrary = runtime.loadLibrary(this.libraries.get(0));
                this.curStep.setName(xLibrary.getFirstPipelineType().getClarkName());
                this.curStep.checkArgs();
                this.steps.add(this.curStep);
            }
            catch (SaxonApiException sae) {
                throw new XProcException(sae);
            }
        }
        TreeWriter tree = new TreeWriter(runtime);
        tree.startDocument(runtime.getStaticBaseURI());
        tree.addStartElement(XProcConstants.p_declare_step, (AttributeMap)SingletonAttributeMap.of((AttributeInfo)TypeUtils.attributeInfo(new QName("version"), "1.0")));
        EmptyAttributeMap attr = EmptyAttributeMap.getInstance();
        attr = attr.put(TypeUtils.attributeInfo(new QName("port"), "parameters"));
        attr = attr.put(TypeUtils.attributeInfo(new QName("kind"), "parameter"));
        tree.addStartElement(XProcConstants.p_input, (AttributeMap)attr);
        tree.addEndElement();
        if (this.outputs.size() == 0) {
            this.outputs.put("result", new Output("-"));
        }
        String lastStepName = "cmdlineStep" + this.steps.size();
        for (String port : this.outputs.keySet()) {
            if (port == null) {
                port = "result";
            }
            tree.addStartElement(XProcConstants.p_output, (AttributeMap)SingletonAttributeMap.of((AttributeInfo)TypeUtils.attributeInfo(new QName("port"), port)));
            attr = EmptyAttributeMap.getInstance();
            attr = attr.put(TypeUtils.attributeInfo(new QName("step"), lastStepName));
            attr = attr.put(TypeUtils.attributeInfo(new QName("port"), port));
            tree.addStartElement(XProcConstants.p_pipe, (AttributeMap)attr);
            tree.addEndElement();
            tree.addEndElement();
        }
        for (Input library : this.libraries) {
            switch (library.getKind()) {
                case URI: {
                    tree.addStartElement(XProcConstants.p_import, (AttributeMap)SingletonAttributeMap.of((AttributeInfo)TypeUtils.attributeInfo(new QName("href"), library.getUri())));
                    tree.addEndElement();
                    break;
                }
                case INPUT_STREAM: {
                    InputStream libraryInputStream = library.getInputStream();
                    FileOutputStream fileOutputStream = null;
                    try {
                        File tempLibrary = File.createTempFile("calabashLibrary", null);
                        tempLibrary.deleteOnExit();
                        fileOutputStream = new FileOutputStream(tempLibrary);
                        fileOutputStream.getChannel().transferFrom(Channels.newChannel(libraryInputStream), 0L, Long.MAX_VALUE);
                        tree.addStartElement(XProcConstants.p_import, (AttributeMap)SingletonAttributeMap.of((AttributeInfo)TypeUtils.attributeInfo(new QName("href"), tempLibrary.toURI().toASCIIString())));
                        tree.addEndElement();
                    }
                    catch (Throwable throwable) {
                        Closer.close(fileOutputStream);
                        libraryInputStream.close();
                        throw throwable;
                    }
                    Closer.close(fileOutputStream);
                    libraryInputStream.close();
                    break;
                }
                default: {
                    throw new UnsupportedOperationException(String.format("Unsupported library kind '%s'", new Object[]{library.getKind()}));
                }
            }
        }
        int stepNum = 0;
        for (StepArgs step : this.steps) {
            attr = EmptyAttributeMap.getInstance();
            attr = attr.put(TypeUtils.attributeInfo(new QName("name"), "cmdlineStep" + ++stepNum));
            for (QName optname : step.options.keySet()) {
                attr = attr.put(TypeUtils.attributeInfo(optname, step.options.get(optname)));
            }
            tree.addStartElement(step.stepName, (AttributeMap)attr);
            for (String port : step.inputs.keySet()) {
                tree.addStartElement(XProcConstants.p_input, (AttributeMap)SingletonAttributeMap.of((AttributeInfo)TypeUtils.attributeInfo(new QName("port"), port == null ? "source" : port)));
                for (Input input : step.inputs.get(port)) {
                    QName qname = input.getType() == Input.Type.DATA ? XProcConstants.p_data : XProcConstants.p_document;
                    switch (input.getKind()) {
                        case URI: {
                            String uri = input.getUri();
                            if ("p:empty".equals(uri)) {
                                tree.addStartElement(XProcConstants.p_empty);
                            } else {
                                attr = EmptyAttributeMap.getInstance();
                                attr = attr.put(TypeUtils.attributeInfo(new QName("href"), uri));
                                if (input.getType() == Input.Type.DATA) {
                                    attr = attr.put(TypeUtils.attributeInfo(new QName("content-type"), input.getContentType()));
                                }
                                tree.addStartElement(qname, (AttributeMap)attr);
                            }
                            tree.addEndElement();
                            break;
                        }
                        case INPUT_STREAM: {
                            InputStream inputStream = input.getInputStream();
                            if (System.in.equals(inputStream)) {
                                attr = EmptyAttributeMap.getInstance();
                                attr = attr.put(TypeUtils.attributeInfo(new QName("href"), "-"));
                                if (input.getType() == Input.Type.DATA) {
                                    attr = attr.put(TypeUtils.attributeInfo(new QName("content-type"), input.getContentType()));
                                }
                                tree.addStartElement(qname, (AttributeMap)attr);
                                tree.addEndElement();
                                break;
                            }
                            FileOutputStream fileOutputStream = null;
                            try {
                                File tempInput = File.createTempFile("calabashInput", null);
                                tempInput.deleteOnExit();
                                fileOutputStream = new FileOutputStream(tempInput);
                                fileOutputStream.getChannel().transferFrom(Channels.newChannel(inputStream), 0L, Long.MAX_VALUE);
                                attr = EmptyAttributeMap.getInstance();
                                attr = attr.put(TypeUtils.attributeInfo(new QName("href"), tempInput.toURI().toASCIIString()));
                                if (input.getType() == Input.Type.DATA) {
                                    attr = attr.put(TypeUtils.attributeInfo(new QName("content-type"), input.getContentType()));
                                }
                                tree.addStartElement(qname, (AttributeMap)attr);
                                tree.addEndElement();
                            }
                            catch (Throwable throwable) {
                                Closer.close(fileOutputStream);
                                inputStream.close();
                                throw throwable;
                            }
                            Closer.close(fileOutputStream);
                            inputStream.close();
                            break;
                        }
                        default: {
                            throw new UnsupportedOperationException(String.format("Unsupported input kind '%s'", new Object[]{input.getKind()}));
                        }
                    }
                }
                tree.addEndElement();
            }
            for (String port : step.params.keySet()) {
                for (QName pname : step.params.get(port).keySet()) {
                    String value = step.params.get(port).get(pname);
                    value = "'" + value.replace("'", "''") + "'";
                    NamespaceMap nsmap = NamespaceMap.emptyMap();
                    attr = EmptyAttributeMap.getInstance();
                    attr = attr.put(TypeUtils.attributeInfo(new QName("name"), pname.toString()));
                    attr = attr.put(TypeUtils.attributeInfo(new QName("select"), value));
                    if (!"*".equals(port)) {
                        attr = attr.put(TypeUtils.attributeInfo(new QName("port"), port));
                    }
                    if (!pname.getPrefix().isEmpty() || !pname.getNamespaceUri().isEmpty()) {
                        nsmap = nsmap.put(pname.getPrefix(), pname.getNamespaceUri());
                    }
                    tree.addStartElement(XProcConstants.p_with_param, (AttributeMap)attr, nsmap);
                    tree.addEndElement();
                }
            }
            tree.addEndElement();
        }
        tree.addEndElement();
        tree.endDocument();
        return tree.getResult();
    }

    private String fixUpURI(String uri) {
        File f = new File(uri);
        String fn = URIUtils.encode(f.getAbsolutePath());
        if ("\\".equals(System.getProperty("file.separator"))) {
            fn = "/" + fn;
        }
        return fn;
    }

    private class StepArgs {
        public String plainStepName = null;
        public QName stepName = null;
        public Map<String, List<Input>> inputs = new HashMap<String, List<Input>>();
        public Map<String, Map<String, String>> plainParams = new HashMap<String, Map<String, String>>();
        public Map<String, Map<QName, String>> params = new HashMap<String, Map<QName, String>>();
        public Map<String, String> plainOptions = new HashMap<String, String>();
        public Map<QName, String> options = new HashMap<QName, String>();

        private StepArgs() {
        }

        public void setName(String name) {
            UserArgs.this.needsCheck = true;
            this.plainStepName = name;
        }

        public void addInput(String port, String uri, Input.Type type, String contentType) {
            if (!this.inputs.containsKey(port)) {
                this.inputs.put(port, new ArrayList());
            }
            this.inputs.get(port).add(new Input(uri, type, contentType));
        }

        public void addInput(String port, InputStream inputStream, String uri, Input.Type type, String contentType) {
            if (!this.inputs.containsKey(port)) {
                this.inputs.put(port, new ArrayList());
            }
            this.inputs.get(port).add(new Input(inputStream, uri, type, contentType));
        }

        public void addOption(String optname, String value) {
            UserArgs.this.needsCheck = true;
            if (this.plainOptions.containsKey(optname)) {
                throw new XProcException("Duplicate option name: '" + optname + "'.");
            }
            this.plainOptions.put(optname, value);
        }

        public void addParameter(String port, String name, String value) {
            UserArgs.this.needsCheck = true;
            Map<Object, Object> portParams = !this.plainParams.containsKey(port) ? new HashMap() : this.plainParams.get(port);
            if (portParams.containsKey(name)) {
                throw new XProcException("Duplicate parameter name: '" + name + "'.");
            }
            portParams.put(name, value);
            this.plainParams.put(port, portParams);
        }

        private QName makeQName(String name) {
            QName qname;
            if (name == null) {
                qname = new QName("");
            } else if (name.indexOf("{") == 0) {
                qname = QName.fromClarkName((String)name);
            } else {
                int cpos = name.indexOf(":");
                if (cpos > 0) {
                    String prefix = name.substring(0, cpos);
                    if (!UserArgs.this.bindings.containsKey(prefix)) {
                        throw new XProcException("Unbound prefix '" + prefix + "' in: '" + name + "'.");
                    }
                    NamespaceUri uri = UserArgs.this.bindings.get(prefix);
                    qname = XProcConstants.qNameFor(prefix, uri, name.substring(cpos + 1));
                } else {
                    qname = new QName("", name);
                }
            }
            return qname;
        }

        public void checkArgs() {
            if (!UserArgs.this.bindings.containsKey("p")) {
                UserArgs.this.bindings.put("p", XProcConstants.NS_XPROC);
            }
            this.stepName = this.makeQName(this.plainStepName);
            if (this.stepName.getNamespaceUri() == NamespaceUri.NULL) {
                this.stepName = XProcConstants.qNameFor(XProcConstants.NS_XPROC, this.stepName.getLocalName());
            }
            this.options.clear();
            for (Map.Entry<String, String> entry : this.plainOptions.entrySet()) {
                QName name = this.makeQName(entry.getKey());
                if (this.options.containsKey(name)) {
                    throw new XProcException("Duplicate option name: '" + name + "'.");
                }
                this.options.put(name, entry.getValue());
            }
            this.params.clear();
            for (Map.Entry<String, Object> entry : this.plainParams.entrySet()) {
                HashMap<QName, String> portParams = new HashMap<QName, String>();
                for (Map.Entry portParam : ((Map)entry.getValue()).entrySet()) {
                    QName name = this.makeQName((String)portParam.getKey());
                    if (portParams.containsKey(name)) {
                        throw new XProcException("Duplicate parameter name: '" + name + "'.");
                    }
                    portParams.put(name, (String)portParam.getValue());
                }
                this.params.put(entry.getKey(), portParams);
            }
        }
    }
}

