/*
 * Decompiled with CFR 0.152.
 */
package com.xmlcalabash.util;

import com.xmlcalabash.core.XProcConstants;
import com.xmlcalabash.core.XProcException;
import com.xmlcalabash.core.XProcRuntime;
import net.sf.saxon.om.AttributeInfo;
import net.sf.saxon.om.FingerprintedQName;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.s9api.ItemType;
import net.sf.saxon.s9api.ItemTypeFactory;
import net.sf.saxon.s9api.Location;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.XdmAtomicValue;
import net.sf.saxon.s9api.XdmNode;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.SimpleType;

public class TypeUtils {
    private static final QName _XSLTMatchPattern = new QName("XSLTMatchPattern");
    private static final QName _RegularExpression = new QName("RegularExpression");
    private static final QName _ListOfQNames = new QName("ListOfQNames");
    private static final QName _XPathExpression = new QName("XPathExpression");
    private static final QName _NormalizationForm = new QName("NormalizationForm");
    private static final QName err_XD0045 = XProcConstants.qNameFor(XProcConstants.NS_XPROC_ERROR, "XD0045");
    private static int anonTypeCount = 0;

    public static QName generateUniqueType(String baseName) {
        String localName = baseName + "_" + ++anonTypeCount;
        return XProcConstants.qNameFor(XProcConstants.NS_CALABASH_EX, localName);
    }

    public static QName generateUniqueType() {
        return TypeUtils.generateUniqueType("anonymousType");
    }

    public static void checkLiteral(String value, String literals) {
        String[] values;
        for (String v : values = literals.split("\\|")) {
            if (!v.equals(value)) continue;
            return;
        }
        throw XProcException.dynamicError(45, "Invalid value: \"" + value + "\" must be one of \"" + literals + "\".");
    }

    public static void checkType(XProcRuntime runtime, String value, QName type, XdmNode node) {
        TypeUtils.checkType(runtime, value, type, node, err_XD0045);
    }

    public static void checkType(XProcRuntime runtime, String value, QName type, XdmNode node, QName error) {
        if (XProcConstants.xs_string.equals((Object)type) || XProcConstants.xs_untypedAtomic.equals((Object)type)) {
            return;
        }
        if (_XSLTMatchPattern.equals((Object)type) || _RegularExpression.equals((Object)type) || _ListOfQNames.equals((Object)type) || _XPathExpression.equals((Object)type) || _NormalizationForm.equals((Object)type)) {
            return;
        }
        if (XProcConstants.xs_QName.equals((Object)type)) {
            try {
                QName qName = new QName(value, node);
            }
            catch (Exception e) {
                throw new XProcException(error, (Throwable)e);
            }
            return;
        }
        ItemTypeFactory typeFactory = new ItemTypeFactory(runtime.getProcessor());
        ItemType itype = null;
        try {
            itype = typeFactory.getAtomicType(type);
        }
        catch (SaxonApiException sae) {
            throw new XProcException("Unexpected type: " + type);
        }
        try {
            XdmAtomicValue sae = new XdmAtomicValue(value, itype);
        }
        catch (SaxonApiException sae) {
            throw new XProcException(error, (Throwable)sae);
        }
    }

    public static FingerprintedQName fqName(QName name) {
        return new FingerprintedQName(name.getPrefix(), name.getNamespaceUri(), name.getLocalName());
    }

    public static AttributeInfo attributeInfo(QName name, String value) {
        return TypeUtils.attributeInfo(name, value, null);
    }

    public static AttributeInfo attributeInfo(QName name, String value, Location location) {
        return new AttributeInfo((NodeName)TypeUtils.fqName(name), (SimpleType)BuiltInAtomicType.ANY_ATOMIC, value, location, 0);
    }
}

