/*
 * Decompiled with CFR 0.152.
 */
package com.xmlcalabash.util;

import com.xmlcalabash.core.XProcConstants;
import com.xmlcalabash.core.XProcRuntime;
import com.xmlcalabash.util.S9apiUtils;
import com.xmlcalabash.util.TreeWriter;
import com.xmlcalabash.util.TypeUtils;
import java.net.URI;
import java.util.ArrayList;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.SourceLocator;
import javax.xml.transform.TransformerException;
import net.sf.saxon.om.AttributeInfo;
import net.sf.saxon.om.NamespaceMap;
import net.sf.saxon.om.NamespaceUri;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.XdmNode;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.SimpleType;

public class StepErrorListener
implements ErrorListener {
    private static final QName c_error = XProcConstants.qNameFor(XProcConstants.NS_XPROC_STEP, "error");
    private static final StructuredQName err_sxxp0003 = new StructuredQName("err", NamespaceUri.of((String)"http://www.w3.org/2005/xqt-errors"), "SXXP0003");
    private static final QName _type = new QName("", "type");
    private static final QName _href = new QName("", "href");
    private static final QName _line = new QName("", "line");
    private static final QName _column = new QName("", "column");
    private static final QName _code = new QName("", "code");
    private XProcRuntime runtime = null;
    private URI baseURI = null;

    public StepErrorListener(XProcRuntime runtime) {
        this.runtime = runtime;
        this.baseURI = runtime.getStaticBaseURI();
    }

    @Override
    public void error(TransformerException exception) throws TransformerException {
        if (!this.report("error", exception)) {
            this.runtime.error(exception);
        }
    }

    @Override
    public void fatalError(TransformerException exception) throws TransformerException {
        if (!this.report("fatal-error", exception)) {
            this.runtime.error(exception);
        }
    }

    @Override
    public void warning(TransformerException exception) throws TransformerException {
        if (!this.report("warning", exception)) {
            this.runtime.warning(exception);
        }
    }

    private boolean report(String type, TransformerException exception) {
        XPathException e;
        StructuredQName errqn;
        if (this.runtime.transparentJSON() && exception instanceof XPathException && (errqn = (e = (XPathException)((Object)exception)).getErrorCodeQName()) != null && errqn.equals((Object)err_sxxp0003)) {
            return true;
        }
        TreeWriter writer = new TreeWriter(this.runtime);
        writer.startDocument(this.baseURI);
        String message = exception.toString();
        StructuredQName qCode = null;
        if (exception instanceof XPathException) {
            XPathException xxx = (XPathException)((Object)exception);
            qCode = xxx.getErrorCodeQName();
            Throwable underlying = exception.getException();
            if (underlying == null) {
                underlying = exception.getCause();
            }
            if (underlying != null) {
                message = underlying.toString();
            }
        }
        if (qCode == null && exception.getException() instanceof XPathException) {
            qCode = ((XPathException)exception.getException()).getErrorCodeQName();
        }
        ArrayList<AttributeInfo> alist = new ArrayList<AttributeInfo>();
        NamespaceMap nsmap = NamespaceMap.emptyMap();
        if (qCode != null) {
            nsmap = nsmap.put(qCode.getPrefix(), qCode.getNamespaceBinding().getNamespaceUri());
            alist.add(new AttributeInfo((NodeName)TypeUtils.fqName(_code), (SimpleType)BuiltInAtomicType.ANY_ATOMIC, qCode.getDisplayName(), null, 0));
        }
        alist.add(new AttributeInfo((NodeName)TypeUtils.fqName(_type), (SimpleType)BuiltInAtomicType.ANY_ATOMIC, type, null, 0));
        if (exception.getLocator() != null) {
            SourceLocator loc = exception.getLocator();
            boolean done = false;
            while (!done && loc == null) {
                if (exception.getException() instanceof TransformerException) {
                    exception = (TransformerException)exception.getException();
                    loc = exception.getLocator();
                    continue;
                }
                if (exception.getCause() instanceof TransformerException) {
                    exception = (TransformerException)exception.getCause();
                    loc = exception.getLocator();
                    continue;
                }
                done = true;
            }
            if (loc != null) {
                if (loc.getSystemId() != null && !"".equals(loc.getSystemId())) {
                    alist.add(new AttributeInfo((NodeName)TypeUtils.fqName(_href), (SimpleType)BuiltInAtomicType.ANY_ATOMIC, loc.getSystemId(), null, 0));
                }
                if (loc.getLineNumber() != -1) {
                    alist.add(new AttributeInfo((NodeName)TypeUtils.fqName(_line), (SimpleType)BuiltInAtomicType.ANY_ATOMIC, "" + loc.getLineNumber(), null, 0));
                }
                if (loc.getColumnNumber() != -1) {
                    alist.add(new AttributeInfo((NodeName)TypeUtils.fqName(_type), (SimpleType)BuiltInAtomicType.ANY_ATOMIC, "" + loc.getColumnNumber(), null, 0));
                }
            }
        }
        writer.addStartElement(c_error, S9apiUtils.mapFromList(alist), nsmap);
        writer.addText(message);
        writer.addEndElement();
        writer.endDocument();
        XdmNode node = writer.getResult();
        return this.runtime.getXProcData().catchError(node);
    }
}

