/*
 * Decompiled with CFR 0.152.
 */
package com.xmlcalabash.util;

import com.xmlcalabash.core.XProcRuntime;
import com.xmlcalabash.model.Binding;
import com.xmlcalabash.model.DataBinding;
import com.xmlcalabash.model.DocumentBinding;
import com.xmlcalabash.model.Input;
import com.xmlcalabash.model.Option;
import com.xmlcalabash.model.Output;
import com.xmlcalabash.model.Parameter;
import com.xmlcalabash.model.PipeNameBinding;
import com.xmlcalabash.model.Serialization;
import com.xmlcalabash.model.Step;
import com.xmlcalabash.model.Variable;
import java.io.PrintStream;
import net.sf.saxon.s9api.QName;

public class Reporter {
    private XProcRuntime runtime;
    private PrintStream pr;
    private boolean xmlReport;

    public Reporter(XProcRuntime runtime, PrintStream pr) {
        this.runtime = runtime;
        this.pr = pr;
        this.xmlReport = true;
    }

    public void report(Step step) {
        if (this.xmlReport) {
            this.pr.println("<pipeline-report xmlns='http://xmlcalabash.com/ns/pipeline-report'>");
            this.pr.println("<version>" + this.runtime.getXProcVersion() + "</version>");
            this.pr.println("<product-name>" + this.runtime.getProductName() + "</product-name>");
            this.pr.println("<product-version>" + this.runtime.getProductVersion() + "</product-version>");
            this.pr.println("<episode>" + this.runtime.getEpisode() + "</episode>");
            this.xmlReport(step);
            this.pr.println("</pipeline-report>");
        }
    }

    private void xmlReport(Step step) {
        this.pr.print("<step xml:base='" + step.getNode().getBaseURI() + "'");
        this.pr.print(" type='" + step.getType().getClarkName() + "'");
        if (step.getDeclaredType() != null) {
            this.pr.print(" declared-type='" + step.getDeclaredType().getClarkName() + "'");
        }
        this.pr.print(" name='" + step.getName() + "'");
        this.pr.println(">");
        for (Input input : step.inputs()) {
            this.xmlReport(input);
        }
        for (Output output : step.outputs()) {
            this.xmlReport(output);
        }
        for (Parameter param : step.parameters()) {
            this.xmlReport(param);
        }
        for (Option option : step.options()) {
            this.xmlReport(option);
        }
        for (Variable var : step.getVariables()) {
            this.xmlReport(var);
        }
        for (Step substep : step.subpipeline()) {
            this.xmlReport(substep);
        }
        this.pr.println("</step>");
    }

    private void xmlReport(Input input) {
        if (!input.getPort().startsWith("|")) {
            this.pr.print("  <input port='" + input.getPort() + "'");
            if (input.getParameterInput()) {
                this.pr.print(" kind='parameter'");
            }
            if (input.getSelect() != null) {
                this.pr.print(" select='" + input.getSelect() + "'");
            }
            this.pr.println(">");
            for (Binding binding : input.getBinding()) {
                this.xmlReport(binding);
            }
            this.pr.println("  </input>");
        }
    }

    private void xmlReport(Output output) {
        if (!output.getPort().endsWith("|")) {
            this.pr.println("  <output port='" + output.getPort() + "'>");
            Serialization ser = output.getSerialization();
            if (ser != null) {
                this.pr.println("    <serialization method='" + ser.getMethod() + "'/>");
            }
            for (Binding binding : output.getBinding()) {
                this.xmlReport(binding);
            }
            this.pr.println("  </output>");
        }
    }

    private void xmlReport(Binding binding) {
        switch (binding.getBindingType()) {
            case 0: {
                this.pr.println("    <no-binding/>");
                break;
            }
            case 1: {
                this.xmlReport((PipeNameBinding)binding);
                break;
            }
            case 2: {
                this.pr.println("    <inline-binding/>");
                break;
            }
            case 3: 
            case 6: {
                this.xmlReport((DocumentBinding)binding);
                break;
            }
            case 8: {
                this.xmlReport((DataBinding)binding);
                break;
            }
            case 4: {
                this.pr.println("    <pipe-binding/>");
                break;
            }
            case 5: {
                this.pr.println("    <no-binding/>");
                break;
            }
            case 7: {
                this.pr.println("    <error-binding/>");
                break;
            }
            default: {
                this.pr.println("    <unknown-binding type='" + binding.getBindingType() + "'/>");
            }
        }
    }

    private void xmlReport(PipeNameBinding binding) {
        this.pr.println("    <pipe-name-binding step='" + binding.getStep() + "' port='" + binding.getPort() + "'/>");
    }

    private void xmlReport(DocumentBinding binding) {
        String href = binding.getHref();
        if (href == null) {
            this.pr.println("    <stdio-binding/>");
        } else {
            this.pr.println("    <document-binding href='" + href + "'/>");
        }
    }

    private void xmlReport(DataBinding binding) {
        String href = binding.getHref();
        QName wrapper = binding.getWrapper();
        this.pr.println("    <data-binding href='" + href + "' wrapper='" + wrapper.getClarkName() + "'/>");
    }

    private void xmlReport(Parameter param) {
        String select = param.getSelect();
        this.pr.print("  <parameter name='" + param.getName().getClarkName() + "'");
        if (select != null) {
            this.pr.print(" select=\"" + select.replaceAll("\"", "&quot;") + "\"");
        }
        this.pr.println("/>");
    }

    private void xmlReport(Option option) {
        String type = option.getType();
        boolean req = option.getRequired();
        String select = option.getSelect();
        this.pr.print("  <option name='" + option.getName().getClarkName() + "' required='" + req + "'");
        if (type != null) {
            this.pr.print(" type='" + type + '\"');
        }
        if (select != null) {
            this.pr.print(" select=\"" + select.replaceAll("\"", "&quot;") + "\"");
        }
        this.pr.println("/>");
    }

    private void xmlReport(Variable var) {
        String select = var.getSelect();
        this.pr.print("  <variable name='" + var.getName().getClarkName() + "'");
        if (select != null) {
            this.pr.print(" select=\"" + select.replaceAll("\"", "&quot;") + "\"");
        }
        this.pr.println("/>");
    }
}

