/*
 * Decompiled with CFR 0.152.
 */
package com.xmlcalabash.util;

import com.xmlcalabash.core.XProcConstants;
import com.xmlcalabash.core.XProcException;
import com.xmlcalabash.core.XProcRuntime;
import com.xmlcalabash.util.Base64;
import com.xmlcalabash.util.JSONtoXML;
import com.xmlcalabash.util.S9apiUtils;
import com.xmlcalabash.util.XMLtoJSON;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import net.sf.saxon.om.NamespaceUri;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.Serializer;
import net.sf.saxon.s9api.XdmNode;

public class NodeToBytes {
    private static final QName _encoding = new QName("encoding");
    private static final QName _content_type = new QName("content-type");
    private static final QName c_encoding = XProcConstants.qNameFor(XProcConstants.NS_XPROC_STEP, "encoding");
    private static final QName c_body = XProcConstants.qNameFor(XProcConstants.NS_XPROC_STEP, "body");
    private static final QName c_json = XProcConstants.qNameFor(XProcConstants.NS_XPROC_STEP, "json");
    private static final QName cx_decode = XProcConstants.qNameFor(XProcConstants.NS_CALABASH_EX, "decode");

    private NodeToBytes() {
    }

    public static byte[] convert(XProcRuntime runtime, XdmNode doc, boolean decode) {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        XdmNode root = S9apiUtils.getDocumentElement(doc);
        assert (root != null);
        if (decode && XProcConstants.NS_XPROC_STEP == root.getNodeName().getNamespaceUri() && "base64".equals(root.getAttributeValue(_encoding)) || root.getNodeName().getNamespaceUri() == NamespaceUri.NULL && "base64".equals(root.getAttributeValue(c_encoding))) {
            NodeToBytes.storeBinary(doc, stream);
        } else if (runtime.transparentJSON() && (c_body.equals((Object)root.getNodeName()) && ("application/json".equals(root.getAttributeValue(_content_type)) || "text/json".equals(root.getAttributeValue(_content_type))) || c_json.equals((Object)root.getNodeName()) || JSONtoXML.JSONX_NS == root.getNodeName().getNamespaceUri() || JSONtoXML.JXML_NS == root.getNodeName().getNamespaceUri() || JSONtoXML.MLJS_NS == root.getNodeName().getNamespaceUri())) {
            NodeToBytes.storeJSON(doc, stream);
        } else {
            NodeToBytes.storeXML(runtime, doc, stream);
        }
        return stream.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void storeXML(XProcRuntime runtime, XdmNode doc, OutputStream stream) {
        try {
            try {
                Serializer serializer = runtime.getProcessor().newSerializer();
                serializer.setOutputProperty(Serializer.Property.ENCODING, "utf-8");
                serializer.setOutputProperty(Serializer.Property.INDENT, "no");
                serializer.setOutputProperty(Serializer.Property.OMIT_XML_DECLARATION, "yes");
                serializer.setOutputProperty(Serializer.Property.METHOD, "xml");
                serializer.setOutputStream(stream);
                S9apiUtils.serialize(runtime, doc, serializer);
            }
            finally {
                stream.close();
            }
        }
        catch (IOException ioe) {
            throw new XProcException("Failed to serialize as XML: " + doc, (Throwable)ioe);
        }
        catch (SaxonApiException sae) {
            throw new XProcException("Failed to serialize as XML: " + doc, (Throwable)sae);
        }
    }

    private static void storeBinary(XdmNode doc, OutputStream stream) {
        try {
            try {
                byte[] decoded = Base64.decode(doc.getStringValue());
                stream.write(decoded);
            }
            finally {
                stream.close();
            }
        }
        catch (IOException ioe) {
            throw new XProcException(ioe);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void storeJSON(XdmNode doc, OutputStream stream) {
        try {
            try {
                PrintWriter writer = new PrintWriter(new OutputStreamWriter(stream, "UTF-8"));
                String json = XMLtoJSON.convert(doc);
                writer.print(json);
            }
            finally {
                stream.close();
            }
        }
        catch (IOException ioe) {
            throw XProcException.stepError(50, ioe);
        }
    }
}

