/*
 * Decompiled with CFR 0.152.
 */
package com.xmlcalabash.util;

import com.xmlcalabash.core.XProcConstants;
import com.xmlcalabash.core.XProcException;
import com.xmlcalabash.util.TreeWriter;
import com.xmlcalabash.util.TypeUtils;
import java.util.Iterator;
import net.sf.saxon.om.AttributeInfo;
import net.sf.saxon.om.AttributeMap;
import net.sf.saxon.om.EmptyAttributeMap;
import net.sf.saxon.om.NamespaceUri;
import net.sf.saxon.om.SingletonAttributeMap;
import net.sf.saxon.s9api.Processor;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.XdmNode;
import net.sf.saxon.serialize.charcode.XMLCharacterData;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;

public class JSONtoXML {
    public static final String CALABASH_DEPRECATED = "calabash-deprecated";
    public static final String CALABASH = "calabash";
    public static final String JSONX = "jsonx";
    public static final String JXML = "jxml";
    public static final String MARKLOGIC = "marklogic";
    public static final NamespaceUri JSONX_NS = NamespaceUri.of((String)"http://www.ibm.com/xmlns/prod/2009/jsonx");
    public static final NamespaceUri MLJS_NS = NamespaceUri.of((String)"http://marklogic.com/json");
    public static final NamespaceUri JXML_NS = NamespaceUri.of((String)"http://www.xmlsh.org/jxml");
    private static final QName _type = new QName("", "type");
    private static final QName _name = new QName("", "name");
    private static final QName c_json = XProcConstants.qNameFor(XProcConstants.NS_XPROC_STEP, "json");
    private static final QName c_pair = XProcConstants.qNameFor(XProcConstants.NS_XPROC_STEP, "pair");
    private static final QName c_item = XProcConstants.qNameFor(XProcConstants.NS_XPROC_STEP, "item");
    private static final QName _json = new QName("json");
    private static final QName _pair = new QName("pair");
    private static final QName _item = new QName("item");
    private static final QName j_object = XProcConstants.qNameFor("j", JSONX_NS, "object");
    private static final QName j_array = XProcConstants.qNameFor("j", JSONX_NS, "array");
    private static final QName j_string = XProcConstants.qNameFor("j", JSONX_NS, "string");
    private static final QName j_number = XProcConstants.qNameFor("j", JSONX_NS, "number");
    private static final QName j_boolean = XProcConstants.qNameFor("j", JSONX_NS, "boolean");
    private static final QName j_null = XProcConstants.qNameFor("j", JSONX_NS, "null");
    private static final QName mj_json = XProcConstants.qNameFor("j", MLJS_NS, "json");
    private static final QName jx_object = XProcConstants.qNameFor("j", JXML_NS, "object");
    private static final QName jx_member = XProcConstants.qNameFor("j", JXML_NS, "member");
    private static final QName jx_boolean = XProcConstants.qNameFor("j", JXML_NS, "boolean");
    private static final QName jx_array = XProcConstants.qNameFor("j", JXML_NS, "array");
    private static final QName jx_string = XProcConstants.qNameFor("j", JXML_NS, "string");
    private static final QName jx_number = XProcConstants.qNameFor("j", JXML_NS, "number");
    private static final QName jx_null = XProcConstants.qNameFor("j", JXML_NS, "null");

    public static boolean knownFlavor(String jsonFlavor) {
        return CALABASH_DEPRECATED.equals(jsonFlavor) || CALABASH.equals(jsonFlavor) || JSONX.equals(jsonFlavor) || JXML.equals(jsonFlavor) || MARKLOGIC.equals(jsonFlavor);
    }

    public static XdmNode convert(Processor processor, JSONTokener jt, String flavor) {
        TreeWriter tree = new TreeWriter(processor);
        tree.startDocument(null);
        if (JSONX.equals(flavor)) {
            JSONtoXML.buildJsonX(tree, jt);
        } else if (MARKLOGIC.equals(flavor)) {
            JSONtoXML.buildMarkLogic(tree, jt);
        } else if (JXML.equals(flavor)) {
            JSONtoXML.buildJxml(tree, jt);
        } else if (CALABASH.equals(flavor)) {
            JSONtoXML.buildMine(tree, jt, true);
        } else {
            JSONtoXML.buildMine(tree, jt, false);
        }
        tree.endDocument();
        return tree.getResult();
    }

    private static void buildJsonX(TreeWriter tree, JSONTokener jt) {
        try {
            char ch = jt.next();
            jt.back();
            if (ch == '{') {
                tree.addStartElement(j_object);
                JSONtoXML.buildJsonXPairs(tree, new JSONObject(jt));
            } else {
                tree.addStartElement(j_array);
                JSONtoXML.buildJsonXArray(tree, new JSONArray(jt));
            }
        }
        catch (JSONException je) {
            throw new XProcException(je);
        }
        tree.addEndElement();
    }

    private static void buildJsonXPairs(TreeWriter tree, JSONObject jo) {
        try {
            Iterator<String> keys = jo.keys();
            while (keys.hasNext()) {
                String name = keys.next();
                Object json = jo.get(name);
                JSONtoXML.serializeJsonX(tree, json, name);
            }
        }
        catch (JSONException je) {
            throw new XProcException(je);
        }
    }

    private static void buildJsonXArray(TreeWriter tree, JSONArray arr) {
        try {
            for (int pos = 0; pos < arr.length(); ++pos) {
                Object json = arr.get(pos);
                JSONtoXML.serializeJsonX(tree, json, null);
            }
        }
        catch (JSONException je) {
            throw new XProcException(je);
        }
    }

    private static void serializeJsonX(TreeWriter tree, Object json, String name) {
        EmptyAttributeMap attr = EmptyAttributeMap.getInstance();
        if (name != null) {
            attr = attr.put(TypeUtils.attributeInfo(_name, name));
        }
        if (json instanceof JSONObject) {
            tree.addStartElement(j_object, (AttributeMap)attr);
            JSONtoXML.buildJsonXPairs(tree, (JSONObject)json);
            tree.addEndElement();
        } else if (json instanceof JSONArray) {
            tree.addStartElement(j_array, (AttributeMap)attr);
            JSONtoXML.buildJsonXArray(tree, (JSONArray)json);
            tree.addEndElement();
        } else if (json instanceof Integer || json instanceof Double || json instanceof Long) {
            tree.addStartElement(j_number, (AttributeMap)attr);
            tree.addText(json.toString());
            tree.addEndElement();
        } else if (json instanceof String) {
            tree.addStartElement(j_string, (AttributeMap)attr);
            tree.addText(json.toString());
            tree.addEndElement();
        } else if (json instanceof Boolean) {
            tree.addStartElement(j_boolean, (AttributeMap)attr);
            tree.addText(json.toString());
            tree.addEndElement();
        } else if (json == JSONObject.NULL) {
            tree.addStartElement(j_null, (AttributeMap)attr);
            tree.addEndElement();
        } else {
            throw new XProcException("Unexpected type in JSON conversion.");
        }
    }

    private static void buildMarkLogic(TreeWriter tree, JSONTokener jt) {
        try {
            char ch = jt.next();
            jt.back();
            if (ch == '{') {
                tree.addStartElement(mj_json, (AttributeMap)SingletonAttributeMap.of((AttributeInfo)TypeUtils.attributeInfo(_type, "object")));
                JSONtoXML.buildMarkLogicPairs(tree, new JSONObject(jt));
            } else {
                tree.addStartElement(mj_json, (AttributeMap)SingletonAttributeMap.of((AttributeInfo)TypeUtils.attributeInfo(_type, "array")));
                JSONtoXML.buildMarkLogicArray(tree, new JSONArray(jt));
            }
        }
        catch (JSONException je) {
            throw new XProcException(je);
        }
        tree.addEndElement();
    }

    private static void buildMarkLogicPairs(TreeWriter tree, JSONObject jo) {
        try {
            Iterator<String> keys = jo.keys();
            while (keys.hasNext()) {
                String name = keys.next();
                Object json = jo.get(name);
                JSONtoXML.serializeMarkLogic(tree, json, name);
            }
        }
        catch (JSONException je) {
            throw new XProcException(je);
        }
    }

    private static void buildMarkLogicArray(TreeWriter tree, JSONArray arr) {
        try {
            for (int pos = 0; pos < arr.length(); ++pos) {
                Object json = arr.get(pos);
                JSONtoXML.serializeMarkLogic(tree, json, null);
            }
        }
        catch (JSONException je) {
            throw new XProcException(je);
        }
    }

    private static void serializeMarkLogic(TreeWriter tree, Object json, String name) {
        StringBuilder localName = new StringBuilder("item");
        if (name != null) {
            if ("".equals(name)) {
                localName = new StringBuilder("_");
            } else {
                localName = new StringBuilder();
                for (int pos = 0; pos < name.length(); ++pos) {
                    char ch = name.charAt(pos);
                    if ('_' != ch && (pos == 0 && XMLCharacterData.isNCNameStart10((int)ch) || pos > 0 && XMLCharacterData.isNCName10((int)ch))) {
                        localName.append(ch);
                        continue;
                    }
                    localName.append(String.format("_%04x", ch));
                }
            }
        }
        QName elemName = XProcConstants.qNameFor("j", MLJS_NS, localName.toString());
        if (json instanceof JSONObject) {
            tree.addStartElement(elemName, (AttributeMap)SingletonAttributeMap.of((AttributeInfo)TypeUtils.attributeInfo(_type, "object")));
            JSONtoXML.buildMarkLogicPairs(tree, (JSONObject)json);
        } else if (json instanceof JSONArray) {
            tree.addStartElement(elemName, (AttributeMap)SingletonAttributeMap.of((AttributeInfo)TypeUtils.attributeInfo(_type, "array")));
            JSONtoXML.buildMarkLogicArray(tree, (JSONArray)json);
        } else if (json instanceof Integer || json instanceof Double || json instanceof Long) {
            tree.addStartElement(elemName, (AttributeMap)SingletonAttributeMap.of((AttributeInfo)TypeUtils.attributeInfo(_type, "number")));
            tree.addText(json.toString());
        } else if (json instanceof String) {
            tree.addStartElement(elemName, (AttributeMap)SingletonAttributeMap.of((AttributeInfo)TypeUtils.attributeInfo(_type, "string")));
            tree.addText(json.toString());
        } else if (json instanceof Boolean) {
            tree.addStartElement(elemName, (AttributeMap)SingletonAttributeMap.of((AttributeInfo)TypeUtils.attributeInfo(_type, "boolean")));
            tree.addText(json.toString());
        } else if (json == JSONObject.NULL) {
            tree.addStartElement(elemName, (AttributeMap)SingletonAttributeMap.of((AttributeInfo)TypeUtils.attributeInfo(_type, "null")));
        } else {
            throw new XProcException("Unexpected type in JSON conversion.");
        }
        tree.addEndElement();
    }

    private static void buildJxml(TreeWriter tree, JSONTokener jt) {
        try {
            char ch = jt.next();
            jt.back();
            if (ch == '{') {
                tree.addStartElement(jx_object);
                JSONtoXML.buildJxmlPairs(tree, new JSONObject(jt));
            } else {
                tree.addStartElement(jx_array);
                JSONtoXML.buildJxmlArray(tree, new JSONArray(jt));
            }
        }
        catch (JSONException je) {
            throw new XProcException(je);
        }
        tree.addEndElement();
    }

    private static void buildJxmlPairs(TreeWriter tree, JSONObject jo) {
        try {
            Iterator<String> keys = jo.keys();
            while (keys.hasNext()) {
                String name = keys.next();
                Object json = jo.get(name);
                JSONtoXML.serializeJxml(tree, json, name);
            }
        }
        catch (JSONException je) {
            throw new XProcException(je);
        }
    }

    private static void buildJxmlArray(TreeWriter tree, JSONArray arr) {
        try {
            for (int pos = 0; pos < arr.length(); ++pos) {
                Object json = arr.get(pos);
                JSONtoXML.serializeJxml(tree, json, null);
            }
        }
        catch (JSONException je) {
            throw new XProcException(je);
        }
    }

    private static void serializeJxml(TreeWriter tree, Object json, String name) {
        if (name != null) {
            tree.addStartElement(jx_member, (AttributeMap)SingletonAttributeMap.of((AttributeInfo)TypeUtils.attributeInfo(_name, name)));
        }
        if (json instanceof JSONObject) {
            tree.addStartElement(jx_object);
            JSONtoXML.buildJxmlPairs(tree, (JSONObject)json);
            tree.addEndElement();
        } else if (json instanceof JSONArray) {
            tree.addStartElement(jx_array);
            JSONtoXML.buildJxmlArray(tree, (JSONArray)json);
            tree.addEndElement();
        } else if (json instanceof Integer || json instanceof Double || json instanceof Long) {
            tree.addStartElement(jx_number);
            tree.addText(json.toString());
            tree.addEndElement();
        } else if (json instanceof String) {
            tree.addStartElement(jx_string);
            tree.addText(json.toString());
            tree.addEndElement();
        } else if (json instanceof Boolean) {
            tree.addStartElement(jx_boolean);
            tree.addText(json.toString());
            tree.addEndElement();
        } else if (json == JSONObject.NULL) {
            tree.addStartElement(jx_null);
            tree.addEndElement();
        } else {
            throw new XProcException("Unexpected type in JSON conversion.");
        }
        if (name != null) {
            tree.addEndElement();
        }
    }

    private static void buildMine(TreeWriter tree, JSONTokener jt, boolean usens) {
        try {
            char ch = jt.next();
            jt.back();
            if (ch == '{') {
                tree.addStartElement(usens ? c_json : _json, (AttributeMap)SingletonAttributeMap.of((AttributeInfo)TypeUtils.attributeInfo(_type, "object")));
                JSONtoXML.buildMyPairs(tree, new JSONObject(jt), usens);
            } else {
                tree.addStartElement(usens ? c_json : _json, (AttributeMap)SingletonAttributeMap.of((AttributeInfo)TypeUtils.attributeInfo(_type, "array")));
                JSONtoXML.buildMyArray(tree, new JSONArray(jt), usens);
            }
        }
        catch (JSONException je) {
            throw new XProcException(je);
        }
        tree.addEndElement();
    }

    private static void buildMyPairs(TreeWriter tree, JSONObject jo, boolean usens) {
        try {
            Iterator<String> keys = jo.keys();
            while (keys.hasNext()) {
                String name = keys.next();
                Object json = jo.get(name);
                EmptyAttributeMap attr = EmptyAttributeMap.getInstance();
                attr = attr.put(TypeUtils.attributeInfo(_name, name));
                if (json instanceof JSONObject) {
                    attr = attr.put(TypeUtils.attributeInfo(_type, "object"));
                    tree.addStartElement(usens ? c_pair : _pair, (AttributeMap)attr);
                    JSONtoXML.buildMyPairs(tree, (JSONObject)json, usens);
                } else if (json instanceof JSONArray) {
                    attr = attr.put(TypeUtils.attributeInfo(_type, "array"));
                    tree.addStartElement(usens ? c_pair : _pair, (AttributeMap)attr);
                    JSONtoXML.buildMyArray(tree, (JSONArray)json, usens);
                } else if (json instanceof Integer || json instanceof Double || json instanceof Long) {
                    attr = attr.put(TypeUtils.attributeInfo(_type, "number"));
                    tree.addStartElement(usens ? c_pair : _pair, (AttributeMap)attr);
                    tree.addText(json.toString());
                } else if (json instanceof String) {
                    attr = attr.put(TypeUtils.attributeInfo(_type, "string"));
                    tree.addStartElement(usens ? c_pair : _pair, (AttributeMap)attr);
                    tree.addText(json.toString());
                } else if (json instanceof Boolean) {
                    attr = attr.put(TypeUtils.attributeInfo(_type, "boolean"));
                    tree.addStartElement(usens ? c_pair : _pair, (AttributeMap)attr);
                    tree.addText(json.toString());
                } else if (json == JSONObject.NULL) {
                    attr = attr.put(TypeUtils.attributeInfo(_type, "null"));
                    tree.addStartElement(usens ? c_pair : _pair, (AttributeMap)attr);
                } else {
                    throw new XProcException("Unexpected type in JSON conversion.");
                }
                tree.addEndElement();
            }
        }
        catch (JSONException je) {
            throw new XProcException(je);
        }
    }

    private static void buildMyArray(TreeWriter tree, JSONArray arr, boolean usens) {
        try {
            for (int pos = 0; pos < arr.length(); ++pos) {
                Object json = arr.get(pos);
                if (json instanceof JSONObject) {
                    tree.addStartElement(usens ? c_item : _item, (AttributeMap)SingletonAttributeMap.of((AttributeInfo)TypeUtils.attributeInfo(_type, "object")));
                    JSONtoXML.buildMyPairs(tree, (JSONObject)json, usens);
                } else if (json instanceof JSONArray) {
                    tree.addStartElement(usens ? c_item : _item, (AttributeMap)SingletonAttributeMap.of((AttributeInfo)TypeUtils.attributeInfo(_type, "array")));
                    JSONtoXML.buildMyArray(tree, (JSONArray)json, usens);
                } else if (json instanceof Integer || json instanceof Double || json instanceof Long) {
                    tree.addStartElement(usens ? c_item : _item, (AttributeMap)SingletonAttributeMap.of((AttributeInfo)TypeUtils.attributeInfo(_type, "number")));
                    tree.addText(json.toString());
                } else if (json instanceof String) {
                    tree.addStartElement(usens ? c_item : _item, (AttributeMap)SingletonAttributeMap.of((AttributeInfo)TypeUtils.attributeInfo(_type, "string")));
                    tree.addText(json.toString());
                } else if (json instanceof Boolean) {
                    tree.addStartElement(usens ? c_item : _item, (AttributeMap)SingletonAttributeMap.of((AttributeInfo)TypeUtils.attributeInfo(_type, "boolean")));
                    tree.addText(json.toString());
                } else if (json == JSONObject.NULL) {
                    tree.addStartElement(usens ? c_item : _item, (AttributeMap)SingletonAttributeMap.of((AttributeInfo)TypeUtils.attributeInfo(_type, "null")));
                } else {
                    throw new XProcException("Unexpected type in JSON conversion.");
                }
                tree.addEndElement();
            }
        }
        catch (JSONException je) {
            throw new XProcException(je);
        }
    }
}

