/*
 * Decompiled with CFR 0.152.
 */
package com.xmlcalabash.util;

import com.xmlcalabash.core.XProcException;
import com.xmlcalabash.util.Base64;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.zip.CRC32;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public class HashUtils {
    private static final String HMAC_SHA1_ALGORITHM = "HmacSHA1";

    public static String crc(byte[] bytes, String version) {
        if (version != null && !"32".equals(version)) {
            throw XProcException.dynamicError(36);
        }
        CRC32 crc = new CRC32();
        crc.update(bytes);
        return Long.toHexString(crc.getValue());
    }

    public static String md(byte[] bytes, String version) {
        version = version == null ? "MD5" : "MD" + version;
        MessageDigest digest = null;
        try {
            digest = MessageDigest.getInstance(version);
        }
        catch (NoSuchAlgorithmException nsae) {
            throw XProcException.dynamicError(36);
        }
        byte[] hash = digest.digest(bytes);
        return HashUtils.byteString(hash);
    }

    public static String sha(byte[] bytes, String version) {
        version = version == null ? "SHA-1" : "SHA-" + version;
        MessageDigest digest = null;
        try {
            digest = MessageDigest.getInstance(version);
        }
        catch (NoSuchAlgorithmException nsae) {
            throw XProcException.dynamicError(36);
        }
        byte[] hash = digest.digest(bytes);
        return HashUtils.byteString(hash);
    }

    public static String hmac(byte[] bytes, String key) {
        String result = "";
        try {
            SecretKeySpec signingKey = new SecretKeySpec(key.getBytes(), HMAC_SHA1_ALGORITHM);
            Mac mac = Mac.getInstance(HMAC_SHA1_ALGORITHM);
            mac.init(signingKey);
            byte[] rawHmac = mac.doFinal(bytes);
            result = Base64.encodeBytes(rawHmac);
        }
        catch (Exception e) {
            throw XProcException.dynamicError(36, "Failed to generate HMAC : " + e.getMessage());
        }
        return result;
    }

    private static String byteString(byte[] hash) {
        String result = "";
        for (byte b : hash) {
            String str = Integer.toHexString(b & 0xFF);
            if (str.length() < 2) {
                str = "0" + str;
            }
            result = result + str;
        }
        return result;
    }
}

