/*
 * Decompiled with CFR 0.152.
 */
package com.xmlcalabash.runtime;

import com.xmlcalabash.core.XProcConstants;
import com.xmlcalabash.core.XProcException;
import com.xmlcalabash.core.XProcRuntime;
import com.xmlcalabash.io.WritablePipe;
import com.xmlcalabash.model.DeclareStep;
import com.xmlcalabash.model.Output;
import com.xmlcalabash.model.RuntimeValue;
import com.xmlcalabash.model.Step;
import com.xmlcalabash.model.Variable;
import com.xmlcalabash.runtime.XCatch;
import com.xmlcalabash.runtime.XCompoundStep;
import com.xmlcalabash.runtime.XGroup;
import com.xmlcalabash.runtime.XInput;
import com.xmlcalabash.runtime.XOutput;
import com.xmlcalabash.runtime.XStep;
import com.xmlcalabash.util.MessageFormatter;
import com.xmlcalabash.util.S9apiUtils;
import com.xmlcalabash.util.TreeWriter;
import com.xmlcalabash.util.TypeUtils;
import java.util.ArrayList;
import java.util.Vector;
import net.sf.saxon.om.AttributeInfo;
import net.sf.saxon.om.NamespaceMap;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.XdmNode;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.SimpleType;

public class XTry
extends XCompoundStep {
    private static final QName c_errors = XProcConstants.qNameFor(XProcConstants.NS_XPROC_STEP, "errors");
    private static final QName c_error = XProcConstants.qNameFor(XProcConstants.NS_XPROC_STEP, "error");
    private static final QName _href = new QName("", "href");
    private static final QName _line = new QName("", "line");
    private static final QName _column = new QName("", "column");
    private static final QName _code = new QName("", "code");
    private final Vector<XdmNode> errors = new Vector();

    public XTry(XProcRuntime runtime, Step step, XCompoundStep parent) {
        super(runtime, step, parent);
    }

    @Override
    public void instantiate(Step step) {
        this.parent.addStep(this);
        DeclareStep decl = step.getDeclaration();
        for (Step substep : decl.subpipeline()) {
            XCompoundStep newstep;
            if (XProcConstants.p_group.equals((Object)substep.getType())) {
                newstep = new XGroup(this.runtime, substep, this);
                newstep.instantiate(substep);
                continue;
            }
            if (XProcConstants.p_catch.equals((Object)substep.getType())) {
                newstep = new XCatch(this.runtime, substep, this);
                newstep.instantiate(substep);
                continue;
            }
            throw new XProcException(step.getNode(), "This can't happen, can it? try contains something that isn't a group or a catch?");
        }
        for (Output output : step.outputs()) {
            String port = output.getPort();
            if (port.endsWith("|")) {
                String rport = port.substring(0, port.length() - 1);
                XInput xinput = this.getInput(rport);
                WritablePipe wpipe = xinput.getWriter();
                this.outputs.put(port, wpipe);
                this.logger.trace(MessageFormatter.nodeMessage(step.getNode(), " writes to " + wpipe + " for " + port));
                continue;
            }
            XOutput xoutput = new XOutput(this.runtime, output);
            this.addOutput(xoutput);
            WritablePipe wpipe = xoutput.getWriter();
            this.outputs.put(port, wpipe);
            this.logger.trace(MessageFormatter.nodeMessage(step.getNode(), " writes to " + wpipe + " for " + port));
        }
    }

    @Override
    public void run() throws SaxonApiException {
        this.inScopeOptions = this.parent.getInScopeOptions();
        for (Variable variable : this.step.getVariables()) {
            RuntimeValue value = this.computeValue(variable);
            this.inScopeOptions.put(variable.getName(), value);
        }
        XGroup xgroup = (XGroup)this.subpipeline.get(0);
        for (String port : this.inputs.keySet()) {
            if (port.startsWith("|")) continue;
            xgroup.inputs.put(port, (Vector)this.inputs.get(port));
        }
        for (String port : this.outputs.keySet()) {
            if (port.endsWith("|")) continue;
            xgroup.outputs.put(port, (WritablePipe)this.outputs.get(port));
        }
        try {
            xgroup.run();
        }
        catch (Exception exception) {
            TreeWriter treeWriter = new TreeWriter(this.runtime);
            treeWriter.startDocument(this.step.getNode().getBaseURI());
            treeWriter.addStartElement(c_errors);
            boolean reported = false;
            for (XdmNode doc : this.runtime.getXProcData().errors()) {
                treeWriter.addSubtree(doc);
                reported = true;
            }
            for (XdmNode doc : this.errors) {
                treeWriter.addSubtree(doc);
                reported = true;
            }
            if (!reported) {
                XStep step;
                Throwable xxx;
                StructuredQName qCode = null;
                String message = exception.getMessage();
                ArrayList<AttributeInfo> alist = new ArrayList<AttributeInfo>();
                NamespaceMap nsmap = NamespaceMap.emptyMap();
                if (exception instanceof XPathException) {
                    xxx = (XPathException)((Object)exception);
                    qCode = xxx.getErrorCodeQName();
                    Throwable underlying = exception.getCause();
                    if (underlying != null) {
                        message = underlying.toString();
                    }
                }
                if (exception instanceof XProcException) {
                    xxx = (XProcException)exception;
                    QName code = ((XProcException)xxx).getErrorCode();
                    message = xxx.getMessage();
                    Throwable underlying = exception.getCause();
                    if (underlying != null) {
                        message = underlying.getMessage();
                    }
                    if (code != null) {
                        qCode = new StructuredQName(code.getPrefix(), code.getNamespaceUri(), code.getLocalName());
                    }
                }
                if (qCode != null) {
                    nsmap = nsmap.put(qCode.getPrefix(), qCode.getNamespaceBinding().getNamespaceUri());
                    alist.add(new AttributeInfo((NodeName)TypeUtils.fqName(_code), (SimpleType)BuiltInAtomicType.ANY_ATOMIC, qCode.getDisplayName(), null, 0));
                }
                if ((step = this.runtime.runningStep()) != null && step.getNode() != null) {
                    XdmNode node = step.getNode();
                    if (node.getBaseURI() != null) {
                        alist.add(new AttributeInfo((NodeName)TypeUtils.fqName(_href), (SimpleType)BuiltInAtomicType.ANY_ATOMIC, node.getBaseURI().toString(), null, 0));
                    }
                    if (node.getLineNumber() > 0) {
                        alist.add(new AttributeInfo((NodeName)TypeUtils.fqName(_line), (SimpleType)BuiltInAtomicType.ANY_ATOMIC, "" + node.getLineNumber(), null, 0));
                    }
                    if (node.getColumnNumber() > 0) {
                        alist.add(new AttributeInfo((NodeName)TypeUtils.fqName(_column), (SimpleType)BuiltInAtomicType.ANY_ATOMIC, "" + node.getColumnNumber(), null, 0));
                    }
                }
                if (message == null) {
                    message = "";
                }
                treeWriter.addStartElement(c_error, S9apiUtils.mapFromList(alist), nsmap);
                treeWriter.addText(message);
                treeWriter.addEndElement();
            }
            treeWriter.addEndElement();
            treeWriter.endDocument();
            XCatch xcatch = (XCatch)this.subpipeline.get(1);
            xcatch.writeError(treeWriter.getResult());
            for (String port : this.inputs.keySet()) {
                if (port.startsWith("|")) continue;
                xcatch.inputs.put(port, (Vector)this.inputs.get(port));
            }
            for (String port : this.outputs.keySet()) {
                if (port.endsWith("|")) continue;
                xcatch.outputs.put(port, (WritablePipe)this.outputs.get(port));
            }
            xcatch.run();
        }
    }

    @Override
    public void reportError(XdmNode doc) {
        this.errors.add(doc);
    }
}

