/*
 * Decompiled with CFR 0.152.
 */
package com.xmlcalabash.runtime;

import com.xmlcalabash.core.XProcData;
import com.xmlcalabash.core.XProcException;
import com.xmlcalabash.core.XProcRuntime;
import com.xmlcalabash.io.Pipe;
import com.xmlcalabash.io.ReadablePipe;
import com.xmlcalabash.io.WritablePipe;
import com.xmlcalabash.model.RuntimeValue;
import com.xmlcalabash.model.Step;
import com.xmlcalabash.model.Variable;
import com.xmlcalabash.runtime.XCompoundStep;
import com.xmlcalabash.runtime.XStep;
import com.xmlcalabash.util.MessageFormatter;
import java.util.Vector;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.XdmNode;

public class XForEach
extends XCompoundStep {
    private Pipe current = null;
    private int sequencePosition = 0;
    private int sequenceLength = 0;

    public XForEach(XProcRuntime runtime, Step step, XCompoundStep parent) {
        super(runtime, step, parent);
    }

    @Override
    public ReadablePipe getBinding(String stepName, String portName) {
        if (this.name.equals(stepName) && ("#current".equals(portName) || "current".equals(portName))) {
            if (this.current == null) {
                this.current = new Pipe(this.runtime);
            }
            return new Pipe(this.runtime, this.current.documents());
        }
        return super.getBinding(stepName, portName);
    }

    @Override
    protected void copyInputs() throws SaxonApiException {
    }

    @Override
    public void reset() {
        super.reset();
        this.sequenceLength = 0;
        this.sequencePosition = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() throws SaxonApiException {
        this.logger.trace("Running p:for-each " + this.step.getName());
        XProcData data = this.runtime.getXProcData();
        data.openFrame(this);
        if (this.current == null) {
            this.current = new Pipe(this.runtime);
        }
        String iport = "#iteration-source";
        this.sequencePosition = 0;
        this.sequenceLength = 0;
        this.inScopeOptions = this.parent.getInScopeOptions();
        Vector<XdmNode> nodes = new Vector<XdmNode>();
        for (ReadablePipe is_reader : (Vector)this.inputs.get(iport)) {
            while (is_reader.moreDocuments()) {
                XdmNode is_doc = is_reader.read();
                this.logger.trace(MessageFormatter.nodeMessage(this.step.getNode(), "Input copy from " + is_reader));
                this.logger.trace(MessageFormatter.nodeMessage(this.step.getNode(), is_doc.toString()));
                nodes.add(is_doc);
                ++this.sequenceLength;
            }
        }
        this.runtime.getXProcData().setIterationSize(this.sequenceLength);
        this.runtime.start(this);
        try {
            for (XdmNode is_doc : nodes) {
                RuntimeValue value;
                this.current.resetWriter();
                this.current.write(is_doc);
                this.logger.trace(MessageFormatter.nodeMessage(this.step.getNode(), "Copy to current"));
                ++this.sequencePosition;
                this.runtime.getXProcData().setIterationPosition(this.sequencePosition);
                for (Variable var : this.step.getVariables()) {
                    value = this.computeValue(var);
                    this.inScopeOptions.put(var.getName(), value);
                }
                this.inScopeOptions = this.parent.getInScopeOptions();
                for (Variable var : this.step.getVariables()) {
                    value = this.computeValue(var);
                    this.inScopeOptions.put(var.getName(), value);
                }
                for (XStep step : this.subpipeline) {
                    step.run();
                }
                for (String port : this.inputs.keySet()) {
                    if (!port.startsWith("|")) continue;
                    String wport = port.substring(1);
                    boolean seqOk = this.step.getOutput(wport).getSequence();
                    int docsCopied = 0;
                    WritablePipe pipe = (WritablePipe)this.outputs.get(wport);
                    pipe.canWriteSequence(true);
                    for (ReadablePipe reader : (Vector)this.inputs.get(port)) {
                        reader.canReadSequence(true);
                        while (reader.moreDocuments()) {
                            XdmNode doc = reader.read();
                            pipe.write(doc);
                            ++docsCopied;
                            this.logger.trace(MessageFormatter.nodeMessage(this.step.getNode(), "Output copy from " + reader + " to " + pipe));
                        }
                        reader.resetReader();
                    }
                    if (docsCopied == true || seqOk) continue;
                    throw XProcException.dynamicError(6, "Writing to " + wport + " on " + this.getStep().getName());
                }
                for (XStep step : this.subpipeline) {
                    step.reset();
                }
            }
        }
        finally {
            for (String port : this.inputs.keySet()) {
                if (!port.startsWith("|")) continue;
                String wport = port.substring(1);
                WritablePipe pipe = (WritablePipe)this.outputs.get(wport);
                pipe.close();
            }
            this.runtime.finish(this);
            data.closeFrame();
        }
    }
}

