/*
 * Decompiled with CFR 0.152.
 */
package com.xmlcalabash.runtime;

import com.xmlcalabash.core.XProcConstants;
import com.xmlcalabash.core.XProcData;
import com.xmlcalabash.core.XProcException;
import com.xmlcalabash.core.XProcRuntime;
import com.xmlcalabash.io.Pipe;
import com.xmlcalabash.io.ReadableEmpty;
import com.xmlcalabash.io.ReadablePipe;
import com.xmlcalabash.io.WritablePipe;
import com.xmlcalabash.model.DeclareStep;
import com.xmlcalabash.model.Output;
import com.xmlcalabash.model.RuntimeValue;
import com.xmlcalabash.model.Step;
import com.xmlcalabash.model.Variable;
import com.xmlcalabash.runtime.XCompoundStep;
import com.xmlcalabash.runtime.XInput;
import com.xmlcalabash.runtime.XOtherwise;
import com.xmlcalabash.runtime.XOutput;
import com.xmlcalabash.runtime.XStep;
import com.xmlcalabash.runtime.XWhen;
import com.xmlcalabash.util.MessageFormatter;
import java.util.Vector;
import net.sf.saxon.s9api.SaxonApiException;

public class XChoose
extends XCompoundStep {
    public XChoose(XProcRuntime runtime, Step step, XCompoundStep parent) {
        super(runtime, step, parent);
    }

    @Override
    public void instantiate(Step step) {
        this.instantiateReaders(step);
        this.parent.addStep(this);
        DeclareStep decl = step.getDeclaration();
        for (Step substep : decl.subpipeline()) {
            XCompoundStep newstep;
            if (XProcConstants.p_when.equals((Object)substep.getType())) {
                newstep = new XWhen(this.runtime, substep, this);
                newstep.instantiate(substep);
                continue;
            }
            if (XProcConstants.p_otherwise.equals((Object)substep.getType())) {
                newstep = new XOtherwise(this.runtime, substep, this);
                newstep.instantiate(substep);
                continue;
            }
            throw new XProcException(step.getNode(), "This can't happen, can it? choose contains something that isn't a when or an otherwise?");
        }
        for (Output output : step.outputs()) {
            String port = output.getPort();
            if (port.endsWith("|")) {
                String rport = port.substring(0, port.length() - 1);
                XInput xinput = this.getInput(rport);
                WritablePipe wpipe = xinput.getWriter();
                this.outputs.put(port, wpipe);
                this.logger.trace(MessageFormatter.nodeMessage(step.getNode(), " writes to " + wpipe + " for " + port));
                continue;
            }
            XOutput xoutput = new XOutput(this.runtime, output);
            this.addOutput(xoutput);
            WritablePipe wpipe = xoutput.getWriter();
            this.outputs.put(port, wpipe);
            this.logger.trace(MessageFormatter.nodeMessage(step.getNode(), " writes to " + wpipe + " for " + port));
        }
    }

    @Override
    public ReadablePipe getBinding(String stepName, String portName) {
        if (this.name.equals(stepName) && "#xpath-context".equals(portName)) {
            Vector xpc = (Vector)this.inputs.get("#xpath-context");
            if (xpc.size() == 0) {
                return new ReadableEmpty();
            }
            ReadablePipe pipe = (ReadablePipe)xpc.get(0);
            return new Pipe(this.runtime, pipe.documents());
        }
        return super.getBinding(stepName, portName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() throws SaxonApiException {
        XProcData data = this.runtime.getXProcData();
        int ipos = data.getIterationPosition();
        int isize = data.getIterationSize();
        data.openFrame(this);
        data.setIterationPosition(ipos);
        data.setIterationSize(isize);
        this.inScopeOptions = this.parent.getInScopeOptions();
        for (Variable var : this.step.getVariables()) {
            RuntimeValue value = this.computeValue(var);
            this.inScopeOptions.put(var.getName(), value);
        }
        this.runtime.start(this);
        XCompoundStep xstep = null;
        for (XStep step : this.subpipeline) {
            if (step instanceof XWhen) {
                XWhen when = (XWhen)step;
                if (!when.shouldRun()) continue;
                xstep = when;
                break;
            }
            xstep = (XOtherwise)step;
            break;
        }
        if (xstep == null) {
            throw XProcException.dynamicError(4);
        }
        for (String port : this.inputs.keySet()) {
            if (port.startsWith("|") || "#xpath-context".equals(port)) continue;
            xstep.inputs.put(port, (Vector)this.inputs.get(port));
        }
        for (String port : this.outputs.keySet()) {
            if (port.endsWith("|")) continue;
            xstep.outputs.put(port, (WritablePipe)this.outputs.get(port));
        }
        try {
            xstep.run();
        }
        finally {
            this.runtime.finish(this);
            data.closeFrame();
        }
    }
}

