/*
 * Decompiled with CFR 0.152.
 */
package com.xmlcalabash.model;

import com.xmlcalabash.core.XProcConstants;
import com.xmlcalabash.core.XProcRuntime;
import com.xmlcalabash.model.DeclareStep;
import com.xmlcalabash.model.Environment;
import com.xmlcalabash.model.Input;
import com.xmlcalabash.model.Output;
import com.xmlcalabash.model.RuntimeValue;
import java.util.HashSet;
import net.sf.saxon.om.NamespaceUri;
import net.sf.saxon.s9api.XdmNode;

public class Viewport
extends DeclareStep {
    RuntimeValue match = null;

    public Viewport(XProcRuntime xproc, XdmNode node, String name) {
        super(xproc, node, name);
        this.declaration = this;
        this.stepType = XProcConstants.p_viewport;
        Output current = new Output(xproc, node);
        current.setPort("#current");
        this.addOutput(current);
    }

    @Override
    public boolean isPipeline() {
        return false;
    }

    @Override
    public DeclareStep getDeclaration() {
        return this.declaration;
    }

    @Override
    public HashSet<NamespaceUri> getExcludeInlineNamespaces() {
        return ((DeclareStep)this.parent).getExcludeInlineNamespaces();
    }

    @Override
    public boolean loops() {
        return true;
    }

    public void setMatch(RuntimeValue match) {
        this.match = match;
    }

    public RuntimeValue getMatch() {
        return this.match;
    }

    @Override
    protected void augmentIO() {
        if (this.getInput("#viewport-source") == null) {
            Input isource = new Input(this.runtime, this.node);
            isource.setPort("#viewport-source");
            this.addInput(isource);
        }
        super.augmentIO();
    }

    @Override
    public Output getOutput(String portName) {
        if ("current".equals(portName)) {
            return this.getOutput("#current");
        }
        if ("result".equals(portName)) {
            for (Output output : this.outputs) {
                if ("#current".equals(output.getPort())) continue;
                return output;
            }
            return null;
        }
        return super.getOutput(portName);
    }

    @Override
    public void patchEnvironment(Environment env) {
        env.setDefaultReadablePort(this.getOutput("#current"));
    }

    @Override
    public boolean valid() {
        boolean valid = true;
        if (this.match == null || "".equals(this.match)) {
            this.error(this.node, "Match expression on p:viewport must be specified.", XProcConstants.staticError(38));
            valid = false;
        }
        if (this.outputs.size() == 1) {
            this.error(this.node, "A viewport step must have a primary output", XProcConstants.staticError(6));
        }
        if (!super.valid()) {
            valid = false;
        }
        return valid;
    }
}

