/*
 * Decompiled with CFR 0.152.
 */
package com.xmlcalabash.library;

import com.xmlcalabash.config.FoProcessor;
import com.xmlcalabash.core.XMLCalabash;
import com.xmlcalabash.core.XProcConstants;
import com.xmlcalabash.core.XProcException;
import com.xmlcalabash.core.XProcRuntime;
import com.xmlcalabash.io.DataStore;
import com.xmlcalabash.io.ReadablePipe;
import com.xmlcalabash.io.WritablePipe;
import com.xmlcalabash.library.DefaultStep;
import com.xmlcalabash.model.RuntimeValue;
import com.xmlcalabash.runtime.XAtomicStep;
import com.xmlcalabash.util.TreeWriter;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.util.Properties;
import java.util.Vector;
import net.sf.saxon.om.NamespaceUri;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;

@XMLCalabash(name="p:xsl-formatter", type="{http://www.w3.org/ns/xproc}xsl-formatter")
public class XSLFormatter
extends DefaultStep {
    private static final QName _href = new QName("", "href");
    private static final QName _content_type = new QName("", "content-type");
    private ReadablePipe source = null;
    private WritablePipe result = null;
    private final Properties options = new Properties();

    public XSLFormatter(XProcRuntime runtime, XAtomicStep step) {
        super(runtime, step);
    }

    @Override
    public void setInput(String port, ReadablePipe pipe) {
        this.source = pipe;
    }

    @Override
    public void setOutput(String port, WritablePipe pipe) {
        this.result = pipe;
    }

    @Override
    public void setParameter(QName name, RuntimeValue value) {
        if (name.getNamespaceUri() != NamespaceUri.NULL) {
            throw new XProcException(this.step.getNode(), "The p:xsl-formatter parameters are in no namespace: " + name + " (" + name.getNamespaceUri() + ")");
        }
        this.options.setProperty(name.getLocalName(), value.getString());
    }

    @Override
    public void reset() {
        this.result.resetWriter();
    }

    @Override
    public void run() throws SaxonApiException {
        super.run();
        Vector<String> foClasses = new Vector<String>();
        if (this.runtime.getConfiguration().foProcessor != null) {
            foClasses.add(this.runtime.getConfiguration().foProcessor);
        }
        foClasses.add("com.xmlcalabash.util.FoFOP");
        FoProcessor provider = null;
        Throwable pexcept = null;
        for (String className : foClasses) {
            if (provider != null) continue;
            try {
                provider = (FoProcessor)Class.forName(className).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                provider.initialize(this.runtime, this.step, this.options);
                break;
            }
            catch (NoClassDefFoundError ncdfe) {
                this.logger.debug("No FO processor class available: " + className);
                if (this.runtime.getDebug()) {
                    ncdfe.printStackTrace();
                }
                pexcept = ncdfe;
                provider = null;
            }
            catch (Exception e) {
                this.logger.debug("Failed to instantiate FO processor class: " + className);
                pexcept = e;
                provider = null;
            }
        }
        if (provider == null) {
            throw new XProcException(this.step.getNode(), "Failed to instantiate FO provider", pexcept);
        }
        final String contentType = this.getOption(_content_type) != null ? this.getOption(_content_type).getString() : "application/octet-stream";
        String base = this.getOption(_href).getBaseURI().toASCIIString();
        String href = this.getOption(_href).getString();
        try {
            final FoProcessor processor = provider;
            DataStore store = this.runtime.getDataStore();
            URI id = store.writeEntry(href, base, contentType, new DataStore.DataWriter(){

                @Override
                public void store(OutputStream content) throws IOException {
                    BufferedOutputStream out = new BufferedOutputStream(content);
                    processor.format(XSLFormatter.this.source.read(), out, contentType);
                    ((OutputStream)out).close();
                }
            });
            TreeWriter tree = new TreeWriter(this.runtime);
            tree.startDocument(this.step.getNode().getBaseURI());
            tree.addStartElement(XProcConstants.c_result);
            tree.addText(id.toASCIIString());
            tree.addEndElement();
            tree.endDocument();
            this.result.write(tree.getResult());
        }
        catch (XProcException e) {
            throw e;
        }
        catch (Exception e) {
            throw new XProcException(this.step.getNode(), "Failed to process FO document", (Throwable)e);
        }
    }
}

