/*
 * Decompiled with CFR 0.152.
 */
package com.xmlcalabash.library;

import com.xmlcalabash.core.XMLCalabash;
import com.xmlcalabash.core.XProcConstants;
import com.xmlcalabash.core.XProcException;
import com.xmlcalabash.core.XProcRuntime;
import com.xmlcalabash.io.ReadablePipe;
import com.xmlcalabash.io.WritablePipe;
import com.xmlcalabash.library.DefaultStep;
import com.xmlcalabash.model.RuntimeValue;
import com.xmlcalabash.runtime.XAtomicStep;
import com.xmlcalabash.util.Base64;
import com.xmlcalabash.util.S9apiUtils;
import com.xmlcalabash.util.TreeWriter;
import com.xmlcalabash.util.TypeUtils;
import com.xmlcalabash.util.XProcCollectionFinder;
import java.util.HashMap;
import java.util.Vector;
import net.sf.saxon.Configuration;
import net.sf.saxon.lib.CollectionFinder;
import net.sf.saxon.lib.ModuleURIResolver;
import net.sf.saxon.om.AttributeMap;
import net.sf.saxon.om.EmptyAttributeMap;
import net.sf.saxon.s9api.Processor;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.XQueryCompiler;
import net.sf.saxon.s9api.XQueryEvaluator;
import net.sf.saxon.s9api.XQueryExecutable;
import net.sf.saxon.s9api.XdmItem;
import net.sf.saxon.s9api.XdmNode;
import net.sf.saxon.s9api.XdmNodeKind;
import net.sf.saxon.s9api.XdmValue;

@XMLCalabash(name="p:xquery", type="{http://www.w3.org/ns/xproc}xquery")
public class XQuery
extends DefaultStep {
    private static final QName _content_type = new QName("content-type");
    private static final QName cx_decode = XProcConstants.qNameFor(XProcConstants.NS_CALABASH_EX, "decode");
    private ReadablePipe source = null;
    private final HashMap<QName, RuntimeValue> params = new HashMap();
    private ReadablePipe query = null;
    private WritablePipe result = null;

    public XQuery(XProcRuntime runtime, XAtomicStep step) {
        super(runtime, step);
    }

    @Override
    public void setInput(String port, ReadablePipe pipe) {
        if ("source".equals(port)) {
            this.source = pipe;
        } else if ("query".equals(port)) {
            this.query = pipe;
        }
    }

    @Override
    public void setOutput(String port, WritablePipe pipe) {
        this.result = pipe;
    }

    @Override
    public void setParameter(QName name, RuntimeValue value) {
        this.params.put(name, value);
    }

    @Override
    public void reset() {
        this.query.resetReader();
        this.result.resetWriter();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void run() throws SaxonApiException {
        super.run();
        Vector<XdmNode> defaultCollection = new Vector<XdmNode>();
        while (this.source.moreDocuments()) {
            defaultCollection.add(this.source.read());
        }
        XdmNode document = null;
        if (defaultCollection.size() > 0) {
            document = (XdmNode)defaultCollection.firstElement();
        }
        XdmNode root = S9apiUtils.getDocumentElement(this.query.read());
        assert (root != null);
        String queryString = null;
        if (XProcConstants.c_data.equals((Object)root.getNodeName()) && "application/octet-stream".equals(root.getAttributeValue(_content_type)) || "base64".equals(root.getAttributeValue(_encoding))) {
            byte[] decoded = Base64.decode(root.getStringValue());
            queryString = new String(decoded);
        } else {
            queryString = root.getStringValue();
        }
        Configuration config = this.runtime.getProcessor().getUnderlyingConfiguration();
        this.runtime.getConfigurer().getSaxonConfigurer().configXQuery(config);
        CollectionFinder collectionFinder = config.getCollectionFinder();
        config.setDefaultCollection("http://xmlcalabash.com/saxon-default-collection");
        config.setCollectionFinder((CollectionFinder)new XProcCollectionFinder(this.runtime, defaultCollection, collectionFinder));
        try {
            Processor qtproc = this.runtime.getProcessor();
            XQueryCompiler xqcomp = qtproc.newXQueryCompiler();
            xqcomp.setBaseURI(root.getBaseURI());
            if (xqcomp.getModuleURIResolver() == null) {
                xqcomp.setModuleURIResolver((ModuleURIResolver)this.runtime.getResolver());
            }
            XQueryExecutable xqexec = xqcomp.compile(queryString);
            XQueryEvaluator xqeval = xqexec.load();
            if (document != null) {
                xqeval.setContextItem((XdmItem)document);
            }
            for (QName name : this.params.keySet()) {
                RuntimeValue v = this.params.get(name);
                if (this.runtime.getAllowGeneralExpressions()) {
                    xqeval.setExternalVariable(name, v.getValue());
                    continue;
                }
                xqeval.setExternalVariable(name, (XdmValue)v.getUntypedAtomic(this.runtime));
            }
            for (XdmItem item : xqeval) {
                XdmNode node = null;
                if (item.isAtomicValue()) {
                    if (!this.runtime.getAllowTextResults()) throw new XProcException(this.step.getNode(), "p:xquery returned atomic value");
                    TreeWriter tree = new TreeWriter(this.runtime);
                    tree.startDocument(this.step.getNode().getBaseURI());
                    EmptyAttributeMap attr = EmptyAttributeMap.getInstance();
                    attr = attr.put(TypeUtils.attributeInfo(_content_type, "text/plain"));
                    attr = attr.put(TypeUtils.attributeInfo(cx_decode, "true"));
                    tree.addStartElement(XProcConstants.c_result, (AttributeMap)attr);
                    tree.addText(item.getStringValue());
                    tree.addEndElement();
                    tree.endDocument();
                    node = tree.getResult();
                } else {
                    node = (XdmNode)item;
                    try {
                        S9apiUtils.assertDocument(node);
                    }
                    catch (XProcException e) {
                        if (!this.runtime.getAllowTextResults()) throw new XProcException(this.step.getStep(), "p:xquery returned non-XML result", e.getCause());
                        TreeWriter tree = new TreeWriter(this.runtime);
                        tree.startDocument(this.step.getNode().getBaseURI());
                        EmptyAttributeMap attr = EmptyAttributeMap.getInstance();
                        attr = attr.put(TypeUtils.attributeInfo(_content_type, "text/plain"));
                        attr = attr.put(TypeUtils.attributeInfo(cx_decode, "true"));
                        tree.addStartElement(XProcConstants.c_result, (AttributeMap)attr);
                        tree.addText(node.toString());
                        tree.addEndElement();
                        tree.endDocument();
                        node = tree.getResult();
                    }
                }
                if (node.getNodeKind() != XdmNodeKind.DOCUMENT) {
                    TreeWriter treeWriter = new TreeWriter(this.runtime);
                    treeWriter.startDocument(this.step.getNode().getBaseURI());
                    treeWriter.addSubtree(node);
                    treeWriter.endDocument();
                    node = treeWriter.getResult();
                }
                this.result.write(node);
            }
            return;
        }
        finally {
            config.setCollectionFinder(collectionFinder);
        }
    }
}

