/*
 * Decompiled with CFR 0.152.
 */
package com.xmlcalabash.library;

import com.xmlcalabash.core.XMLCalabash;
import com.xmlcalabash.core.XProcException;
import com.xmlcalabash.core.XProcRuntime;
import com.xmlcalabash.io.ReadablePipe;
import com.xmlcalabash.io.WritablePipe;
import com.xmlcalabash.library.DefaultStep;
import com.xmlcalabash.model.RuntimeValue;
import com.xmlcalabash.runtime.XAtomicStep;
import com.xmlcalabash.util.DocumentSequenceIterator;
import com.xmlcalabash.util.TreeWriter;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.FocusIterator;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.XPathCompiler;
import net.sf.saxon.s9api.XPathExecutable;
import net.sf.saxon.s9api.XdmNode;
import net.sf.saxon.sxpath.XPathDynamicContext;
import net.sf.saxon.sxpath.XPathExpression;
import net.sf.saxon.trans.XPathException;

@XMLCalabash(name="p:wrap-sequence", type="{http://www.w3.org/ns/xproc}wrap-sequence")
public class WrapSequence
extends DefaultStep {
    private static QName _wrapper = new QName("", "wrapper");
    private static QName _wrapper_prefix = new QName("", "wrapper-prefix");
    private static QName _wrapper_namespace = new QName("", "wrapper-namespace");
    private static QName _group_adjacent = new QName("", "group-adjacent");
    private ReadablePipe source = null;
    private WritablePipe result = null;
    private QName wrapper = null;
    private RuntimeValue groupAdjacent = null;

    public WrapSequence(XProcRuntime runtime, XAtomicStep step) {
        super(runtime, step);
    }

    @Override
    public void setInput(String port, ReadablePipe pipe) {
        this.source = pipe;
    }

    @Override
    public void setOutput(String port, WritablePipe pipe) {
        this.result = pipe;
    }

    @Override
    public void reset() {
        this.source.resetReader();
        this.result.resetWriter();
    }

    @Override
    public void run() throws SaxonApiException {
        super.run();
        RuntimeValue wrapperNameValue = this.getOption(_wrapper);
        String wrapperNameStr = wrapperNameValue.getString();
        String wpfx = this.getOption(_wrapper_prefix, (String)null);
        String wns = this.getOption(_wrapper_namespace, (String)null);
        if (wpfx != null && wns == null) {
            throw XProcException.dynamicError(34, this.step.getNode(), "You can't specify a prefix without a namespace");
        }
        if (wns != null && wrapperNameStr.contains(":")) {
            throw XProcException.dynamicError(34, this.step.getNode(), "You can't specify a namespace if the wrapper name contains a colon");
        }
        this.wrapper = wrapperNameStr.contains(":") ? new QName(wrapperNameStr, wrapperNameValue.getNode()) : new QName(wpfx == null ? "" : wpfx, wns, wrapperNameStr);
        this.groupAdjacent = this.getOption(_group_adjacent);
        if (this.groupAdjacent != null) {
            this.runAdjacent();
        } else {
            this.runSimple();
        }
    }

    private void runSimple() {
        TreeWriter treeWriter = new TreeWriter(this.runtime);
        treeWriter.startDocument(this.step.getNode().getBaseURI());
        treeWriter.addStartElement(this.wrapper);
        while (this.source.moreDocuments()) {
            XdmNode node = this.source.read();
            treeWriter.addSubtree(node);
        }
        treeWriter.addEndElement();
        treeWriter.endDocument();
        XdmNode doc = treeWriter.getResult();
        this.result.write(doc);
    }

    private void runAdjacent() throws SaxonApiException {
        TreeWriter treeWriter = null;
        String last = null;
        boolean open = false;
        int count = 0;
        while (this.source.moreDocuments()) {
            ++count;
            this.source.read();
        }
        this.source.resetReader();
        DocumentSequenceIterator xsi = new DocumentSequenceIterator();
        xsi.setLast(count);
        int pos = 0;
        while (this.source.moreDocuments()) {
            XdmNode node = this.source.read();
            ++pos;
            Item item = null;
            try {
                XPathCompiler xcomp = this.runtime.newXPathCompiler(this.step.getNode().getBaseURI(), this.groupAdjacent.getNamespaceBindings());
                XPathExecutable xexec = xcomp.compile(this.groupAdjacent.getString());
                XPathExpression xexpr = xexec.getUnderlyingExpression();
                XPathDynamicContext xdc = xexpr.createDynamicContext((Item)node.getUnderlyingNode());
                XPathContext xc = xdc.getXPathContextObject();
                xsi.setPosition(pos);
                xsi.setItem((Item)node.getUnderlyingNode());
                xc.setCurrentIterator((FocusIterator)xsi);
                SequenceIterator results = xexpr.iterate(xdc);
                item = results.next();
                if (item == null) {
                    throw new XProcException(this.step.getNode(), "The group-adjacent expression returned nothing.");
                }
                if (results.next() != null) {
                    throw new XProcException(this.step.getNode(), "Didn't expect group-adjacent to return a sequence!");
                }
            }
            catch (XPathException xe) {
                throw new XProcException(xe);
            }
            String cur = item.getStringValue();
            if (last != null) {
                if (last.equals(cur)) {
                    treeWriter.addSubtree(node);
                } else if (open) {
                    open = false;
                    treeWriter.addEndElement();
                    treeWriter.endDocument();
                    this.result.write(treeWriter.getResult());
                }
            }
            if (last != null && last.equals(cur)) continue;
            last = cur;
            open = true;
            treeWriter = new TreeWriter(this.runtime);
            treeWriter.startDocument(this.step.getNode().getBaseURI());
            treeWriter.addStartElement(this.wrapper);
            treeWriter.addSubtree(node);
        }
        if (open) {
            open = false;
            treeWriter.addEndElement();
            treeWriter.endDocument();
            this.result.write(treeWriter.getResult());
        }
    }
}

