/*
 * Decompiled with CFR 0.152.
 */
package com.xmlcalabash.library;

import com.xmlcalabash.core.XMLCalabash;
import com.xmlcalabash.core.XProcException;
import com.xmlcalabash.core.XProcRuntime;
import com.xmlcalabash.io.ReadablePipe;
import com.xmlcalabash.io.WritablePipe;
import com.xmlcalabash.library.DefaultStep;
import com.xmlcalabash.model.RuntimeValue;
import com.xmlcalabash.runtime.XAtomicStep;
import com.xmlcalabash.util.ProcessMatch;
import com.xmlcalabash.util.ProcessMatchingNodes;
import com.xmlcalabash.util.S9apiUtils;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Vector;
import net.sf.saxon.om.AttributeInfo;
import net.sf.saxon.om.AttributeMap;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.XdmNode;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.SimpleType;

@XMLCalabash(name="p:www-form-urlencode", type="{http://www.w3.org/ns/xproc}www-form-urlencode")
public class WWWFormURLEncode
extends DefaultStep
implements ProcessMatchingNodes {
    private ReadablePipe source = null;
    private WritablePipe result = null;
    private Vector<Tuple> params = new Vector();
    private static final QName _match = new QName("", "match");
    private ProcessMatch matcher = null;
    private String encoded = "";

    public WWWFormURLEncode(XProcRuntime runtime, XAtomicStep step) {
        super(runtime, step);
    }

    @Override
    public void setInput(String port, ReadablePipe pipe) {
        this.source = pipe;
    }

    @Override
    public void setOutput(String port, WritablePipe pipe) {
        this.result = pipe;
    }

    @Override
    public void setParameter(QName name, RuntimeValue value) {
        int pos = -1;
        int count = -1;
        for (Tuple t : this.params) {
            ++count;
            if (!name.equals((Object)t.name)) continue;
            pos = count;
        }
        if (pos >= 0) {
            this.params.remove(pos);
        }
        this.params.add(new Tuple(name, value));
    }

    @Override
    public void reset() {
        this.source.resetReader();
        this.result.resetWriter();
    }

    @Override
    public void run() throws SaxonApiException {
        super.run();
        for (Tuple t : this.params) {
            if (!"".equals(this.encoded)) {
                this.encoded = this.encoded + "&";
            }
            this.encoded = this.encoded + t.name.getLocalName() + "=" + this.encode(t.value.getString());
        }
        this.matcher = new ProcessMatch(this.runtime, this);
        this.matcher.match(this.source.read(), this.getOption(_match));
        if (this.source.moreDocuments()) {
            throw XProcException.dynamicError(6, "Reading source on " + this.getStep().getName());
        }
        this.result.write(this.matcher.getResult());
    }

    @Override
    public boolean processStartDocument(XdmNode node) {
        return true;
    }

    @Override
    public void processEndDocument(XdmNode node) {
    }

    @Override
    public AttributeMap processAttributes(XdmNode node, AttributeMap matchingAttributes, AttributeMap nonMatchingAttributes) {
        ArrayList<AttributeInfo> alist = new ArrayList<AttributeInfo>();
        for (AttributeInfo attr : nonMatchingAttributes) {
            alist.add(attr);
        }
        for (AttributeInfo attr : matchingAttributes) {
            alist.add(new AttributeInfo(attr.getNodeName(), (SimpleType)BuiltInAtomicType.ANY_ATOMIC, this.encoded, attr.getLocation(), 0));
        }
        return S9apiUtils.mapFromList(alist);
    }

    @Override
    public boolean processStartElement(XdmNode node, AttributeMap attributes) {
        this.matcher.addText(this.encoded);
        return false;
    }

    @Override
    public void processEndElement(XdmNode node) {
    }

    @Override
    public void processText(XdmNode node) {
        this.matcher.addText(this.encoded);
    }

    @Override
    public void processComment(XdmNode node) {
        this.matcher.addComment(this.encoded);
    }

    @Override
    public void processPI(XdmNode node) {
        this.matcher.addPI(node.getNodeName().getLocalName(), this.encoded);
    }

    private String encode(String src) {
        byte[] bytes;
        String genDelims = ":/?#[]@";
        String subDelims = "!$'()*,;=";
        String unreserved = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz-._~";
        String okChars = genDelims + subDelims + unreserved;
        StringBuilder encoded = new StringBuilder();
        for (byte aByte : bytes = src.getBytes(StandardCharsets.UTF_8)) {
            if (okChars.indexOf(aByte) >= 0) {
                encoded.append((char)aByte);
                continue;
            }
            if (aByte == 32) {
                encoded.append("+");
                continue;
            }
            encoded.append(String.format("%%%02X", aByte));
        }
        return encoded.toString();
    }

    private static class Tuple {
        public QName name;
        public RuntimeValue value;

        public Tuple(QName name, RuntimeValue value) {
            this.name = name;
            this.value = value;
        }
    }
}

