/*
 * Decompiled with CFR 0.152.
 */
package com.xmlcalabash.library;

import com.xmlcalabash.core.XMLCalabash;
import com.xmlcalabash.core.XProcConstants;
import com.xmlcalabash.core.XProcException;
import com.xmlcalabash.core.XProcRuntime;
import com.xmlcalabash.io.ReadablePipe;
import com.xmlcalabash.io.WritablePipe;
import com.xmlcalabash.library.DefaultStep;
import com.xmlcalabash.model.RuntimeValue;
import com.xmlcalabash.runtime.XAtomicStep;
import com.xmlcalabash.util.MessageFormatter;
import com.xmlcalabash.util.ProcessMatch;
import com.xmlcalabash.util.ProcessMatchingNodes;
import com.xmlcalabash.util.S9apiUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Vector;
import net.sf.saxon.om.AttributeInfo;
import net.sf.saxon.om.AttributeMap;
import net.sf.saxon.om.NamespaceBinding;
import net.sf.saxon.om.NamespaceUri;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.XdmAtomicValue;
import net.sf.saxon.s9api.XdmItem;
import net.sf.saxon.s9api.XdmNode;
import net.sf.saxon.s9api.XdmNodeKind;

@XMLCalabash(name="p:template", type="{http://www.w3.org/ns/xproc}template {http://www.w3.org/ns/xproc}document-template")
public class Template
extends DefaultStep
implements ProcessMatchingNodes {
    private ReadablePipe source = null;
    private ReadablePipe template = null;
    private WritablePipe result = null;
    private HashMap<QName, RuntimeValue> params = new HashMap();
    private ProcessMatch matcher = null;
    private XdmNode context = null;
    private static final int START = 0;
    private static final int XPATHMODE = 1;
    private static final int SQUOTEMODE = 2;
    private static final int DQUOTEMODE = 3;
    private static final int END = 4;

    public Template(XProcRuntime runtime, XAtomicStep step) {
        super(runtime, step);
    }

    @Override
    public void setInput(String port, ReadablePipe pipe) {
        if ("source".equals(port)) {
            this.source = pipe;
        } else if ("template".equals(port)) {
            this.template = pipe;
        } else {
            throw new UnsupportedOperationException("WTF?");
        }
    }

    @Override
    public void setOutput(String port, WritablePipe pipe) {
        this.result = pipe;
    }

    @Override
    public void setParameter(QName name, RuntimeValue value) {
        this.params.put(name, value);
    }

    @Override
    public void reset() {
        this.source.resetReader();
        this.result.resetWriter();
        this.template.resetReader();
    }

    @Override
    public void run() throws SaxonApiException {
        if (this.step.getNode().getNodeName().equals((Object)XProcConstants.p_document_template)) {
            this.logger.trace(MessageFormatter.nodeMessage(this.step.getNode(), "The template step should be named p:template, the name p:document-template is deprecated."));
        }
        super.run();
        if (this.source.documentCount() > 1) {
            throw XProcException.stepError(68);
        }
        this.context = this.source.read();
        this.matcher = new ProcessMatch(this.runtime, this);
        this.matcher.match(this.template.read(), new RuntimeValue("node()", this.step.getNode()));
        this.result.write(this.matcher.getResult());
    }

    @Override
    public boolean processStartDocument(XdmNode node) {
        this.matcher.startDocument(node.getBaseURI());
        return true;
    }

    @Override
    public void processEndDocument(XdmNode node) {
        this.matcher.endDocument();
    }

    @Override
    public AttributeMap processAttributes(XdmNode node, AttributeMap matchingAttributes, AttributeMap nonMatchingAttributes) {
        return null;
    }

    @Override
    public boolean processStartElement(XdmNode node, AttributeMap attributes) {
        ArrayList<AttributeInfo> alist = new ArrayList<AttributeInfo>();
        for (AttributeInfo attr : attributes) {
            String value = attr.getValue();
            if (value.contains("{") || value.contains("}")) {
                Vector<XdmItem> items = this.parse(node, value);
                StringBuilder newvalue = new StringBuilder();
                for (XdmItem item : items) {
                    newvalue.append(item.getStringValue());
                }
                alist.add(new AttributeInfo(attr.getNodeName(), attr.getType(), newvalue.toString(), attr.getLocation(), attr.getProperties()));
                continue;
            }
            alist.add(attr);
        }
        this.matcher.addStartElement(node, S9apiUtils.mapFromList(alist));
        return true;
    }

    @Override
    public void processEndElement(XdmNode node) {
        this.matcher.addEndElement();
    }

    @Override
    public void processText(XdmNode node) {
        String value = node.getStringValue();
        if (value.contains("{") || value.contains("}")) {
            Vector<XdmItem> items = this.parse(node, value);
            block5: for (XdmItem item : items) {
                if (item.isAtomicValue()) {
                    this.matcher.addText(item.getStringValue());
                    continue;
                }
                XdmNode nitem = (XdmNode)item;
                switch (nitem.getNodeKind()) {
                    case ELEMENT: {
                        this.matcher.addSubtree(nitem);
                        continue block5;
                    }
                    case PROCESSING_INSTRUCTION: {
                        this.matcher.addSubtree(nitem);
                        continue block5;
                    }
                    case COMMENT: {
                        this.matcher.addComment(nitem.getStringValue());
                        continue block5;
                    }
                }
                this.matcher.addText(nitem.getStringValue());
            }
        } else {
            this.matcher.addText(value);
        }
    }

    private Vector<XdmItem> parse(XdmNode node, String value) {
        Vector<XdmItem> items = new Vector<XdmItem>();
        int state = 0;
        String ptext = "";
        String ch = "";
        HashMap<String, NamespaceUri> nsbindings = new HashMap<String, NamespaceUri>();
        XdmNode parent = node;
        while (parent != null && parent.getNodeKind() != XdmNodeKind.ELEMENT && parent.getNodeKind() != XdmNodeKind.DOCUMENT) {
            parent = S9apiUtils.getParent(parent);
        }
        assert (parent != null);
        if (parent.getNodeKind() == XdmNodeKind.ELEMENT) {
            NodeInfo inode = parent.getUnderlyingNode();
            for (NamespaceBinding bind : inode.getAllNamespaces().getNamespaceBindings()) {
                nsbindings.put(bind.getPrefix(), bind.getNamespaceUri());
            }
        }
        String peek = "";
        block20: for (int pos = 0; pos < value.length(); ++pos) {
            ch = value.substring(pos, pos + 1);
            switch (state) {
                case 0: {
                    peek = pos + 1 < value.length() ? value.substring(pos + 1, pos + 2) : "";
                    if ("{".equals(ch)) {
                        if ("{".equals(peek)) {
                            ptext = ptext + "{";
                            ++pos;
                            continue block20;
                        }
                        if (!"".equals(ptext)) {
                            items.add((XdmItem)new XdmAtomicValue(ptext));
                            ptext = "";
                        }
                        state = 1;
                        continue block20;
                    }
                    if ("}".equals(ch)) {
                        if ("}".equals(peek)) {
                            ptext = ptext + "}";
                            ++pos;
                            continue block20;
                        }
                        throw XProcException.stepError(67);
                    }
                    ptext = ptext + ch;
                    continue block20;
                }
                case 1: {
                    switch (ch) {
                        case "{": {
                            throw XProcException.stepError(67);
                        }
                        case "'": {
                            ptext = ptext + "'";
                            state = 2;
                            continue block20;
                        }
                        case "\"": {
                            ptext = ptext + "\"";
                            state = 3;
                            continue block20;
                        }
                        case "}": {
                            items.addAll(this.evaluateXPath(this.context, nsbindings, ptext, this.params));
                            ptext = "";
                            state = 0;
                            continue block20;
                        }
                    }
                    ptext = ptext + ch;
                    continue block20;
                }
                case 2: {
                    if ("'".equals(ch)) {
                        ptext = ptext + "'";
                        state = 1;
                        continue block20;
                    }
                    ptext = ptext + ch;
                    continue block20;
                }
                case 3: {
                    if ("\"".equals(ch)) {
                        ptext = ptext + "\"";
                        state = 1;
                        continue block20;
                    }
                    ptext = ptext + ch;
                }
            }
        }
        if (state != 0) {
            throw XProcException.stepError(67);
        }
        if (!"".equals(ptext)) {
            items.add((XdmItem)new XdmAtomicValue(ptext));
        }
        return items;
    }

    @Override
    public void processComment(XdmNode node) {
        String value = node.getStringValue();
        if (value.contains("{") || value.contains("}")) {
            Vector<XdmItem> items = this.parse(node, value);
            StringBuilder newvalue = new StringBuilder();
            for (XdmItem item : items) {
                newvalue.append(item.getStringValue());
            }
            this.matcher.addComment(newvalue.toString());
        } else {
            this.matcher.addComment(value);
        }
    }

    @Override
    public void processPI(XdmNode node) {
        String value = node.getStringValue();
        if (value.contains("{") || value.contains("}")) {
            Vector<XdmItem> items = this.parse(node, value);
            StringBuilder newvalue = new StringBuilder();
            for (XdmItem item : items) {
                newvalue.append(item.getStringValue());
            }
            this.matcher.addPI(node.getNodeName().getLocalName(), newvalue.toString());
        } else {
            this.matcher.addPI(node.getNodeName().getLocalName(), value);
        }
    }

    public void processAttribute(XdmNode node) {
        throw new UnsupportedOperationException("This can't happen.");
    }
}

