/*
 * Decompiled with CFR 0.152.
 */
package com.xmlcalabash.library;

import com.xmlcalabash.core.XMLCalabash;
import com.xmlcalabash.core.XProcRuntime;
import com.xmlcalabash.io.ReadablePipe;
import com.xmlcalabash.io.WritablePipe;
import com.xmlcalabash.library.DefaultStep;
import com.xmlcalabash.model.RuntimeValue;
import com.xmlcalabash.runtime.XAtomicStep;
import com.xmlcalabash.util.AxisNodes;
import com.xmlcalabash.util.ProcessMatch;
import com.xmlcalabash.util.ProcessMatchingNodes;
import com.xmlcalabash.util.S9apiUtils;
import com.xmlcalabash.util.TypeUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Vector;
import net.sf.saxon.om.AttributeInfo;
import net.sf.saxon.om.AttributeMap;
import net.sf.saxon.om.FingerprintedQName;
import net.sf.saxon.om.NamespaceUri;
import net.sf.saxon.s9api.Axis;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.XdmItem;
import net.sf.saxon.s9api.XdmNode;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.SimpleType;

@XMLCalabash(name="p:string-replace", type="{http://www.w3.org/ns/xproc}string-replace")
public class StringReplace
extends DefaultStep
implements ProcessMatchingNodes {
    private static final QName _match = new QName("", "match");
    private static final QName _replace = new QName("", "replace");
    private ReadablePipe source = null;
    private WritablePipe result = null;
    private ProcessMatch matcher = null;
    private RuntimeValue replace = null;
    private final HashMap<String, NamespaceUri> rns = new HashMap();
    private static final HashMap<QName, RuntimeValue> atomicStepsGetNoInScopeOptions = new HashMap();

    public StringReplace(XProcRuntime runtime, XAtomicStep step) {
        super(runtime, step);
    }

    @Override
    public void setInput(String port, ReadablePipe pipe) {
        this.source = pipe;
    }

    @Override
    public void setOutput(String port, WritablePipe pipe) {
        this.result = pipe;
    }

    @Override
    public void reset() {
        this.source.resetReader();
        this.result.resetWriter();
    }

    @Override
    public void run() throws SaxonApiException {
        super.run();
        RuntimeValue match = this.getOption(_match);
        this.replace = this.getOption(_replace);
        for (String prefix : this.replace.getNamespaceBindings().keySet()) {
            this.rns.put(prefix, this.replace.getNamespaceBindings().get(prefix));
        }
        this.matcher = new ProcessMatch(this.runtime, this);
        this.matcher.match(this.source.read(), match);
        this.result.write(this.matcher.getResult());
    }

    @Override
    public boolean processStartDocument(XdmNode node) {
        return true;
    }

    @Override
    public void processEndDocument(XdmNode node) {
    }

    @Override
    public AttributeMap processAttributes(XdmNode node, AttributeMap matchingAttributes, AttributeMap nonMatchingAttributes) {
        ArrayList<AttributeInfo> alist = new ArrayList<AttributeInfo>();
        for (AttributeInfo attr : nonMatchingAttributes) {
            alist.add(attr);
        }
        for (AttributeInfo attr : matchingAttributes) {
            XdmNode attrNode = null;
            for (XdmNode anode : new AxisNodes(node, Axis.ATTRIBUTE)) {
                FingerprintedQName aname = TypeUtils.fqName(anode.getNodeName());
                if (!aname.equals(attr.getNodeName())) continue;
                attrNode = anode;
            }
            alist.add(new AttributeInfo(attr.getNodeName(), (SimpleType)BuiltInAtomicType.UNTYPED_ATOMIC, this.computeReplacement(attrNode), attr.getLocation(), 0));
        }
        return S9apiUtils.mapFromList(alist);
    }

    @Override
    public boolean processStartElement(XdmNode node, AttributeMap attributes) {
        String newValue = this.computeReplacement(node);
        this.matcher.addText(newValue);
        return false;
    }

    @Override
    public void processEndElement(XdmNode node) {
    }

    @Override
    public void processText(XdmNode node) {
        String newValue = this.computeReplacement(node);
        this.matcher.addText(newValue);
    }

    @Override
    public void processComment(XdmNode node) {
        String newValue = this.computeReplacement(node);
        this.matcher.addText(newValue);
    }

    @Override
    public void processPI(XdmNode node) {
        String newValue = this.computeReplacement(node);
        this.matcher.addText(newValue);
    }

    private String computeReplacement(XdmNode node) {
        Vector<XdmItem> values = this.evaluateXPath(node, this.rns, this.replace.getString(), atomicStepsGetNoInScopeOptions);
        StringBuilder newValue = new StringBuilder();
        for (XdmItem item : values) {
            newValue.append(item.getStringValue());
        }
        return newValue.toString();
    }
}

