/*
 * Decompiled with CFR 0.152.
 */
package com.xmlcalabash.library;

import com.xmlcalabash.core.XMLCalabash;
import com.xmlcalabash.core.XProcConstants;
import com.xmlcalabash.core.XProcRuntime;
import com.xmlcalabash.io.WritablePipe;
import com.xmlcalabash.library.DefaultStep;
import com.xmlcalabash.model.RuntimeValue;
import com.xmlcalabash.runtime.XAtomicStep;
import com.xmlcalabash.util.TreeWriter;
import com.xmlcalabash.util.TypeUtils;
import java.util.HashMap;
import net.sf.saxon.om.AttributeMap;
import net.sf.saxon.om.EmptyAttributeMap;
import net.sf.saxon.om.NamespaceUri;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.XdmAtomicValue;
import net.sf.saxon.s9api.XdmItem;
import net.sf.saxon.s9api.XdmNode;
import net.sf.saxon.s9api.XdmValue;

@XMLCalabash(name="p:parameters", type="{http://www.w3.org/ns/xproc}parameters")
public class Parameters
extends DefaultStep {
    private static final QName c_param_set = XProcConstants.qNameFor(XProcConstants.NS_XPROC_STEP, "param-set");
    private static final QName c_param = XProcConstants.qNameFor(XProcConstants.NS_XPROC_STEP, "param");
    private static final QName cx_item = XProcConstants.qNameFor(XProcConstants.NS_CALABASH_EX, "item");
    private static final QName _name = new QName("name");
    private static final QName _namespace = new QName("namespace");
    private static final QName _value = new QName("value");
    private static final QName _type = new QName("type");
    private WritablePipe result = null;
    HashMap<QName, RuntimeValue> parameters = new HashMap();

    public Parameters(XProcRuntime runtime, XAtomicStep step) {
        super(runtime, step);
    }

    @Override
    public void setOutput(String port, WritablePipe pipe) {
        this.result = pipe;
    }

    @Override
    public void setParameter(String port, QName name, RuntimeValue value) {
        this.parameters.put(name, value);
    }

    @Override
    public void setParameter(QName name, RuntimeValue value) {
        this.parameters.put(name, value);
    }

    @Override
    public void reset() {
        this.result.resetWriter();
    }

    @Override
    public void run() throws SaxonApiException {
        super.run();
        TreeWriter treeWriter = new TreeWriter(this.runtime);
        treeWriter.startDocument(this.step.getNode().getBaseURI());
        treeWriter.addStartElement(c_param_set);
        for (QName param : this.parameters.keySet()) {
            EmptyAttributeMap attr = EmptyAttributeMap.getInstance();
            String value = this.parameters.get(param).getStringValue().getStringValue();
            attr = attr.put(TypeUtils.attributeInfo(_name, param.getLocalName()));
            attr = param.getNamespaceUri() != NamespaceUri.NULL ? attr.put(TypeUtils.attributeInfo(_namespace, param.getNamespaceUri().toString())) : attr.put(TypeUtils.attributeInfo(_namespace, ""));
            if (this.runtime.getAllowGeneralExpressions()) {
                XdmItem item;
                XdmValue xdmvalue = this.parameters.get(param).getValue();
                XdmAtomicValue atom = null;
                if (xdmvalue.size() == 1 && (item = xdmvalue.itemAt(0)).isAtomicValue()) {
                    atom = (XdmAtomicValue)item;
                }
                if (atom != null && xdmvalue.size() == 1) {
                    attr = attr.put(TypeUtils.attributeInfo(_value, value));
                    treeWriter.addStartElement(c_param, (AttributeMap)attr);
                    treeWriter.addEndElement();
                    continue;
                }
                treeWriter.addStartElement(c_param, (AttributeMap)attr);
                for (XdmItem next : xdmvalue) {
                    QName type;
                    EmptyAttributeMap itemattr = EmptyAttributeMap.getInstance();
                    QName qName = type = next.isAtomicValue() ? ((XdmAtomicValue)next).getPrimitiveTypeName() : null;
                    if (type != null) {
                        itemattr = XProcConstants.NS_XMLSCHEMA == type.getNamespaceUri() ? itemattr.put(TypeUtils.attributeInfo(_type, type.getLocalName())) : itemattr.put(TypeUtils.attributeInfo(_type, type.getClarkName()));
                    }
                    if (next.isAtomicValue()) {
                        itemattr = itemattr.put(TypeUtils.attributeInfo(_value, next.getStringValue()));
                        treeWriter.addStartElement(cx_item, (AttributeMap)itemattr);
                        treeWriter.addEndElement();
                        continue;
                    }
                    treeWriter.addStartElement(cx_item, (AttributeMap)itemattr);
                    treeWriter.addSubtree((XdmNode)next);
                    treeWriter.addEndElement();
                }
                continue;
            }
            attr = attr.put(TypeUtils.attributeInfo(_value, value));
            treeWriter.addStartElement(c_param, (AttributeMap)attr);
            treeWriter.addEndElement();
        }
        treeWriter.addEndElement();
        treeWriter.endDocument();
        this.result.write(treeWriter.getResult());
    }
}

