/*
 * Decompiled with CFR 0.152.
 */
package com.xmlcalabash.library;

import com.xmlcalabash.core.XMLCalabash;
import com.xmlcalabash.core.XProcException;
import com.xmlcalabash.core.XProcRuntime;
import com.xmlcalabash.io.ReadablePipe;
import com.xmlcalabash.io.WritablePipe;
import com.xmlcalabash.library.DefaultStep;
import com.xmlcalabash.model.RuntimeValue;
import com.xmlcalabash.runtime.XAtomicStep;
import com.xmlcalabash.util.TreeWriter;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.XdmNode;

@XMLCalabash(name="p:pack", type="{http://www.w3.org/ns/xproc}pack")
public class Pack
extends DefaultStep {
    protected static final String logger = "org.xproc.library.identity";
    private static final QName _wrapper = new QName("wrapper");
    private static final QName _wrapper_prefix = new QName("wrapper-prefix");
    private static final QName _wrapper_namespace = new QName("wrapper-namespace");
    private ReadablePipe source = null;
    private ReadablePipe alternate = null;
    private WritablePipe result = null;

    public Pack(XProcRuntime runtime, XAtomicStep step) {
        super(runtime, step);
    }

    @Override
    public void setInput(String port, ReadablePipe pipe) {
        if ("source".equals(port)) {
            this.source = pipe;
        } else {
            this.alternate = pipe;
        }
    }

    @Override
    public void setOutput(String port, WritablePipe pipe) {
        this.result = pipe;
    }

    @Override
    public void reset() {
        this.source.resetReader();
        this.result.resetWriter();
    }

    @Override
    public void run() throws SaxonApiException {
        super.run();
        RuntimeValue wrapperNameValue = this.getOption(_wrapper);
        String wrapperNameStr = wrapperNameValue.getString();
        String wpfx = this.getOption(_wrapper_prefix, (String)null);
        String wns = this.getOption(_wrapper_namespace, (String)null);
        if (wpfx != null && wns == null) {
            throw XProcException.dynamicError(34, "You can't specify a prefix without a namespace");
        }
        if (wns != null && wrapperNameStr.contains(":")) {
            throw XProcException.dynamicError(34, "You can't specify a namespace if the wrapper name contains a colon");
        }
        QName wrapper = null;
        wrapper = wrapperNameStr.contains(":") ? new QName(wrapperNameStr, wrapperNameValue.getNode()) : new QName(wpfx == null ? "" : wpfx, wns, wrapperNameStr);
        while (this.source.moreDocuments() || this.alternate.moreDocuments()) {
            XdmNode sdoc = null;
            XdmNode adoc = null;
            if (this.source.moreDocuments()) {
                sdoc = this.source.read();
            }
            if (this.alternate.moreDocuments()) {
                adoc = this.alternate.read();
            }
            TreeWriter tree = new TreeWriter(this.runtime);
            tree.startDocument(this.step.getNode().getBaseURI());
            tree.addStartElement(wrapper);
            if (sdoc != null) {
                tree.addSubtree(sdoc);
            }
            if (adoc != null) {
                tree.addSubtree(adoc);
            }
            tree.endDocument();
            this.result.write(tree.getResult());
        }
    }
}

