/*
 * Decompiled with CFR 0.152.
 */
package com.xmlcalabash.library;

import com.xmlcalabash.core.XMLCalabash;
import com.xmlcalabash.core.XProcConstants;
import com.xmlcalabash.core.XProcException;
import com.xmlcalabash.core.XProcRuntime;
import com.xmlcalabash.io.ReadablePipe;
import com.xmlcalabash.io.WritablePipe;
import com.xmlcalabash.library.DefaultStep;
import com.xmlcalabash.model.RuntimeValue;
import com.xmlcalabash.runtime.XAtomicStep;
import com.xmlcalabash.util.ProcessMatch;
import com.xmlcalabash.util.ProcessMatchingNodes;
import net.sf.saxon.om.AttributeInfo;
import net.sf.saxon.om.AttributeMap;
import net.sf.saxon.om.FingerprintedQName;
import net.sf.saxon.om.NameOfNode;
import net.sf.saxon.om.NamespaceMap;
import net.sf.saxon.om.NamespaceUri;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.XdmNode;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.SimpleType;
import net.sf.saxon.type.Untyped;

@XMLCalabash(name="p:namespace-rename", type="{http://www.w3.org/ns/xproc}namespace-rename")
public class NamespaceRename
extends DefaultStep
implements ProcessMatchingNodes {
    private static final QName _from = new QName("from");
    private static final QName _to = new QName("to");
    private static final QName _apply_to = new QName("apply-to");
    private ReadablePipe source = null;
    private WritablePipe result = null;
    private ProcessMatch matcher = null;
    private NamespaceUri from = null;
    private NamespaceUri to = null;
    private String applyTo = null;

    public NamespaceRename(XProcRuntime runtime, XAtomicStep step) {
        super(runtime, step);
    }

    @Override
    public void setInput(String port, ReadablePipe pipe) {
        this.source = pipe;
    }

    @Override
    public void setOutput(String port, WritablePipe pipe) {
        this.result = pipe;
    }

    @Override
    public void reset() {
        this.source.resetReader();
        this.result.resetWriter();
    }

    @Override
    public void run() throws SaxonApiException {
        super.run();
        this.from = this.getOption(_from) != null ? NamespaceUri.of((String)this.getOption(_from).getString()) : NamespaceUri.NULL;
        this.to = this.getOption(_to) != null ? NamespaceUri.of((String)this.getOption(_to).getString()) : NamespaceUri.NULL;
        this.applyTo = this.getOption(_apply_to, "all");
        if (this.from == XProcConstants.NS_XML || this.to == XProcConstants.NS_XML || this.from == XProcConstants.NS_XML_ATTR || this.to == XProcConstants.NS_XML_ATTR) {
            throw XProcException.stepError(14);
        }
        if (this.from.equals(this.to)) {
            this.result.write(this.source.read());
        } else {
            this.matcher = new ProcessMatch(this.runtime, this);
            this.matcher.match(this.source.read(), new RuntimeValue("*", this.step.getNode()));
            this.result.write(this.matcher.getResult());
        }
        if (this.source.moreDocuments()) {
            throw XProcException.dynamicError(6, "Reading source on " + this.getStep().getName());
        }
    }

    @Override
    public boolean processStartDocument(XdmNode node) {
        return true;
    }

    @Override
    public void processEndDocument(XdmNode node) {
        this.matcher.addEndElement();
    }

    @Override
    public AttributeMap processAttributes(XdmNode node, AttributeMap matchingAttributes, AttributeMap nonMatchingAttributes) {
        throw new UnsupportedOperationException("processAttribute can't be called in NamespaceRename--but it was!?");
    }

    @Override
    public boolean processStartElement(XdmNode node, AttributeMap attributes) {
        String pfx;
        NamespaceUri uri;
        SimpleType atype;
        NodeName nameCode;
        NodeInfo inode = node.getUnderlyingNode();
        NamespaceMap nsmap = inode.getAllNamespaces();
        NamespaceMap newNS = inode.getAllNamespaces();
        NodeName startName = NameOfNode.makeName((NodeInfo)inode);
        SchemaType startType = inode.getSchemaType();
        AttributeMap startAttr = inode.attributes();
        if (!"attributes".equals(this.applyTo) && this.from == node.getNodeName().getNamespaceUri()) {
            String prefix = node.getNodeName().getPrefix();
            startName = new FingerprintedQName(prefix, this.to, node.getNodeName().getLocalName());
            startType = Untyped.INSTANCE;
            newNS = newNS.remove(prefix);
            newNS = newNS.put(prefix, this.to);
        }
        if ("all".equals(this.applyTo)) {
            for (AttributeInfo attr : inode.attributes()) {
                nameCode = attr.getNodeName();
                atype = attr.getType();
                uri = NamespaceUri.of((String)nameCode.getURI());
                if (this.from == uri) {
                    startAttr = startAttr.remove(nameCode);
                    pfx = nameCode.getPrefix();
                    newNS = newNS.remove(pfx);
                    nameCode = new FingerprintedQName(pfx, this.to, nameCode.getLocalPart());
                    atype = BuiltInAtomicType.UNTYPED_ATOMIC;
                    newNS = newNS.put(pfx, this.to);
                }
                startAttr = startAttr.put(new AttributeInfo(nameCode, atype, attr.getValue(), attr.getLocation(), 0));
            }
        }
        if ("elements".equals(this.applyTo)) {
            for (AttributeInfo attr : inode.attributes()) {
                nameCode = attr.getNodeName();
                atype = attr.getType();
                uri = NamespaceUri.of((String)nameCode.getURI());
                if (this.from == uri) {
                    startAttr = startAttr.remove(nameCode);
                    pfx = this.prefixFor(newNS, this.from);
                    nameCode = new FingerprintedQName(pfx, this.from, nameCode.getLocalPart());
                    atype = BuiltInAtomicType.UNTYPED_ATOMIC;
                    newNS = newNS.put(pfx, this.from);
                }
                startAttr = startAttr.put(new AttributeInfo(nameCode, atype, attr.getValue(), attr.getLocation(), 0));
            }
        }
        if ("attributes".equals(this.applyTo)) {
            for (AttributeInfo attr : inode.attributes()) {
                nameCode = attr.getNodeName();
                startAttr = startAttr.remove(nameCode);
                String pfx2 = nameCode.getPrefix();
                uri = NamespaceUri.of((String)nameCode.getURI());
                if (this.from == uri) {
                    pfx2 = this.prefixFor(newNS, this.to);
                    nameCode = new FingerprintedQName(pfx2, this.to, nameCode.getLocalPart());
                    newNS = newNS.put(pfx2, this.to);
                }
                startAttr = startAttr.put(new AttributeInfo(nameCode, (SimpleType)BuiltInAtomicType.UNTYPED_ATOMIC, attr.getValue(), attr.getLocation(), 0));
            }
        }
        this.matcher.addStartElement(startName, startAttr, startType, newNS);
        return true;
    }

    @Override
    public void processEndElement(XdmNode node) {
        this.matcher.addEndElement();
    }

    @Override
    public void processText(XdmNode node) {
        this.matcher.addText(node.getStringValue());
    }

    @Override
    public void processComment(XdmNode node) {
        this.matcher.addComment(node.getStringValue());
    }

    @Override
    public void processPI(XdmNode node) {
        this.matcher.addPI(node.getNodeName().getLocalName(), node.getStringValue());
    }
}

