/*
 * Decompiled with CFR 0.152.
 */
package com.xmlcalabash.library;

import com.xmlcalabash.core.XMLCalabash;
import com.xmlcalabash.core.XProcConstants;
import com.xmlcalabash.core.XProcException;
import com.xmlcalabash.core.XProcRuntime;
import com.xmlcalabash.io.DataStore;
import com.xmlcalabash.io.ReadablePipe;
import com.xmlcalabash.io.WritablePipe;
import com.xmlcalabash.library.DefaultStep;
import com.xmlcalabash.runtime.XAtomicStep;
import com.xmlcalabash.util.AxisNodes;
import com.xmlcalabash.util.Base64;
import com.xmlcalabash.util.HttpUtils;
import com.xmlcalabash.util.JSONtoXML;
import com.xmlcalabash.util.MIMEReader;
import com.xmlcalabash.util.S9apiUtils;
import com.xmlcalabash.util.TreeWriter;
import com.xmlcalabash.util.TypeUtils;
import com.xmlcalabash.util.XMLtoJSON;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.List;
import java.util.Vector;
import net.sf.saxon.om.AttributeInfo;
import net.sf.saxon.om.AttributeMap;
import net.sf.saxon.om.EmptyAttributeMap;
import net.sf.saxon.om.NamespaceUri;
import net.sf.saxon.om.SingletonAttributeMap;
import net.sf.saxon.s9api.Axis;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.Serializer;
import net.sf.saxon.s9api.XdmNode;
import net.sf.saxon.s9api.XdmNodeKind;
import net.sf.saxon.s9api.XdmSequenceIterator;
import org.apache.http.ConnectionClosedException;
import org.apache.http.Consts;
import org.apache.http.Header;
import org.apache.http.HeaderElement;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.AuthCache;
import org.apache.http.client.CookieStore;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpPatch;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.cookie.Cookie;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.entity.mime.FormBodyPartBuilder;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.ByteArrayBody;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.StringBody;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.BasicAuthCache;
import org.apache.http.impl.client.BasicCookieStore;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.StandardHttpRequestRetryHandler;
import org.apache.http.message.BasicHeader;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.json.JSONTokener;
import org.xml.sax.InputSource;

@XMLCalabash(name="p:http-request", type="{http://www.w3.org/ns/xproc}http-request")
public class HttpRequest
extends DefaultStep {
    private static final QName c_request = XProcConstants.qNameFor(XProcConstants.NS_XPROC_STEP, "request");
    private static final QName cx_timeout = XProcConstants.qNameFor(XProcConstants.NS_CALABASH_EX, "timeout");
    private static final QName cx_cookies = XProcConstants.qNameFor(XProcConstants.NS_CALABASH_EX, "cookies");
    private static final QName cx_save_cookies = XProcConstants.qNameFor(XProcConstants.NS_CALABASH_EX, "save-cookies");
    private static final QName cx_use_cookies = XProcConstants.qNameFor(XProcConstants.NS_CALABASH_EX, "use-cookies");
    private static final QName cx_send_binary = XProcConstants.qNameFor(XProcConstants.NS_CALABASH_EX, "send-binary");
    public static final QName _href = new QName("", "href");
    public static final QName _detailed = new QName("", "detailed");
    public static final QName _status_only = new QName("", "status-only");
    public static final QName _username = new QName("", "username");
    public static final QName _password = new QName("", "password");
    public static final QName _auth_method = new QName("", "auth-method");
    public static final QName _send_authorization = new QName("", "send-authorization");
    public static final QName _override_content_type = new QName("", "override-content-type");
    public static final QName _content_type = new QName("", "content-type");
    public static final QName _name = new QName("", "name");
    public static final QName _value = new QName("", "value");
    public static final QName _id = new QName("", "id");
    public static final QName _description = new QName("", "description");
    public static final QName _disposition = new QName("", "disposition");
    public static final QName _status = new QName("", "status");
    public static final QName _boundary = new QName("", "boundary");
    public static final QName _charset = new QName("", "charset");
    private static final int bufSize = 7296;
    private boolean detailed = false;
    private boolean sendAuthorization = false;
    private URI requestURI = null;
    private final Vector<Header> headers = new Vector();
    private String overrideContentType = null;
    private String headerContentType = null;
    private boolean encodeBinary = false;
    private HttpClientBuilder builder = HttpClientBuilder.create();
    private ReadablePipe source = null;
    private WritablePipe result = null;

    public HttpRequest(XProcRuntime runtime, XAtomicStep step) {
        super(runtime, step);
    }

    @Override
    public void setInput(String port, ReadablePipe pipe) {
        this.source = pipe;
    }

    @Override
    public void setOutput(String port, WritablePipe pipe) {
        this.result = pipe;
    }

    @Override
    public void reset() {
        this.source.resetReader();
        this.result.resetWriter();
        this.builder = HttpClientBuilder.create();
    }

    @Override
    public void run() throws SaxonApiException {
        TreeWriter tree;
        block62: {
            Object httpRequest;
            super.run();
            XdmNode requestDoc = this.source.read();
            XdmNode start = S9apiUtils.getDocumentElement(requestDoc);
            assert (start != null);
            if (!c_request.equals((Object)start.getNodeName())) {
                throw XProcException.stepError(40);
            }
            XdmSequenceIterator iter = start.axisIterator(Axis.ATTRIBUTE);
            boolean ok = true;
            while (iter.hasNext()) {
                XdmNode attr = (XdmNode)iter.next();
                QName name = attr.getNodeName();
                if (_method.equals((Object)name) || _href.equals((Object)name) || _detailed.equals((Object)name) || _status_only.equals((Object)name) || _username.equals((Object)name) || _password.equals((Object)name) || _auth_method.equals((Object)name) || _send_authorization.equals((Object)name) || _override_content_type.equals((Object)name) || name.getNamespaceUri() != NamespaceUri.NULL) continue;
                throw new XProcException(this.step.getNode(), "Unsupported attribute on c:request for p:http-request: " + name);
            }
            String send = this.step.getExtensionAttribute(cx_send_binary);
            this.encodeBinary = !"true".equals(send);
            boolean statusOnly = "true".equals(start.getAttributeValue(_status_only));
            String method = start.getAttributeValue(_method);
            this.detailed = "true".equals(start.getAttributeValue(_detailed));
            this.sendAuthorization = "true".equals(start.getAttributeValue(_send_authorization));
            this.overrideContentType = start.getAttributeValue(_override_content_type);
            if (method == null) {
                throw XProcException.stepError(6);
            }
            if (statusOnly && !this.detailed) {
                throw XProcException.stepError(4);
            }
            if (start.getAttributeValue(_href) == null) {
                throw new XProcException(this.step.getNode(), "The 'href' attribute must be specified on c:request for p:http-request");
            }
            this.requestURI = start.getBaseURI().resolve(start.getAttributeValue(_href));
            String scheme = this.requestURI.getScheme();
            if (!"http".equalsIgnoreCase(scheme) && !"https".equalsIgnoreCase(scheme)) {
                this.doFile(start.getAttributeValue(_href), start.getBaseURI().toASCIIString());
                return;
            }
            RequestConfig.Builder rqbuilder = RequestConfig.custom();
            rqbuilder.setCookieSpec("default");
            HttpClientContext localContext = HttpClientContext.create();
            String saveCookieKey = this.step.getExtensionAttribute(cx_save_cookies);
            String useCookieKeys = this.step.getExtensionAttribute(cx_use_cookies);
            String cookieKey = this.step.getExtensionAttribute(cx_cookies);
            if (saveCookieKey == null) {
                saveCookieKey = cookieKey;
            }
            if (useCookieKeys == null) {
                useCookieKeys = cookieKey;
            }
            BasicCookieStore cookieStore = new BasicCookieStore();
            if (useCookieKeys != null && useCookieKeys.equals(saveCookieKey)) {
                cookieStore = this.runtime.getCookieStore(useCookieKeys);
            } else if (useCookieKeys != null) {
                CookieStore useCookieStore = this.runtime.getCookieStore(useCookieKeys);
                for (Cookie cookie : useCookieStore.getCookies()) {
                    cookieStore.addCookie(cookie);
                }
            }
            this.builder.setDefaultCookieStore((CookieStore)cookieStore);
            String timeOutStr = this.step.getExtensionAttribute(cx_timeout);
            if (timeOutStr != null) {
                rqbuilder.setSocketTimeout(Integer.parseInt(timeOutStr));
            }
            this.builder.setDefaultRequestConfig(rqbuilder.build());
            if (start.getAttributeValue(_username) != null) {
                List<String> authpref;
                String user = start.getAttributeValue(_username);
                String pass = start.getAttributeValue(_password);
                String meth = start.getAttributeValue(_auth_method);
                String host = this.requestURI.getHost();
                int port = this.requestURI.getPort();
                AuthScope scope = new AuthScope(host, port);
                BasicCredentialsProvider bCredsProvider = new BasicCredentialsProvider();
                bCredsProvider.setCredentials(scope, (Credentials)new UsernamePasswordCredentials(user, pass));
                if ("basic".equalsIgnoreCase(meth)) {
                    authpref = Collections.singletonList("Basic");
                    if (this.sendAuthorization) {
                        BasicAuthCache authCache = new BasicAuthCache();
                        BasicScheme basicAuth = new BasicScheme();
                        authCache.put(new HttpHost(host, port), (AuthScheme)basicAuth);
                        localContext.setCredentialsProvider((CredentialsProvider)bCredsProvider);
                        localContext.setAuthCache((AuthCache)authCache);
                    }
                } else if ("digest".equalsIgnoreCase(meth)) {
                    authpref = Collections.singletonList("Digest");
                } else {
                    throw XProcException.stepError(3, "Unsupported auth-method: " + meth);
                }
                rqbuilder.setProxyPreferredAuthSchemes(authpref);
                this.builder.setDefaultCredentialsProvider((CredentialsProvider)bCredsProvider);
            }
            iter = start.axisIterator(Axis.CHILD);
            XdmNode body = null;
            while (iter.hasNext()) {
                XdmNode event = (XdmNode)iter.next();
                if (event.getNodeKind() != XdmNodeKind.ELEMENT) continue;
                if (body != null) {
                    throw new UnsupportedOperationException("Elements follow c:multipart or c:body");
                }
                if (XProcConstants.c_header.equals((Object)event.getNodeName())) {
                    String name = event.getAttributeValue(_name);
                    if (name == null) continue;
                    if (name.equalsIgnoreCase("content-type")) {
                        this.headerContentType = event.getAttributeValue(_value).toLowerCase();
                        continue;
                    }
                    this.headers.add((Header)new BasicHeader(event.getAttributeValue(_name), event.getAttributeValue(_value)));
                    continue;
                }
                if (XProcConstants.c_multipart.equals((Object)event.getNodeName()) || XProcConstants.c_body.equals((Object)event.getNodeName())) {
                    body = event;
                    continue;
                }
                throw new UnsupportedOperationException("Unexpected request element: " + event.getNodeName());
            }
            String lcMethod = method.toUpperCase();
            if (body != null && ("HEAD".equals(lcMethod) || "GET".equals(lcMethod))) {
                throw XProcException.stepError(5);
            }
            HttpResponse httpResult = null;
            switch (lcMethod) {
                case "GET": {
                    httpRequest = this.doGet();
                    break;
                }
                case "POST": {
                    httpRequest = this.doPost(body);
                    break;
                }
                case "PUT": {
                    httpRequest = this.doPut(body);
                    break;
                }
                case "PATCH": {
                    httpRequest = this.doPatch(body);
                    break;
                }
                case "HEAD": {
                    httpRequest = this.doHead();
                    break;
                }
                case "DELETE": {
                    httpRequest = this.doDelete();
                    break;
                }
                default: {
                    httpRequest = body != null ? this.doGenericMethodWithBody(lcMethod, body) : this.doGenericMethod(lcMethod);
                }
            }
            tree = new TreeWriter(this.runtime);
            try {
                InputStream bodyStream;
                this.builder.setRetryHandler((HttpRequestRetryHandler)new StandardHttpRequestRetryHandler(3, false));
                for (String pscheme : this.runtime.getConfiguration().proxies.keySet()) {
                    String proxy = this.runtime.getConfiguration().proxies.get(pscheme);
                    int pos = proxy.indexOf(":");
                    String host = proxy.substring(0, pos);
                    int port = Integer.parseInt(proxy.substring(pos + 1));
                    Header[] httpProxy = new HttpHost(host, port, pscheme);
                    this.builder.setProxy((HttpHost)httpProxy);
                }
                CloseableHttpClient httpClient = this.builder.build();
                if (httpClient == null) {
                    throw new XProcException("HTTP requests have been disabled");
                }
                httpResult = httpClient.execute((HttpUriRequest)httpRequest, (HttpContext)localContext);
                int statusCode = httpResult.getStatusLine().getStatusCode();
                HttpHost host = (HttpHost)localContext.getAttribute("http.target_host");
                HttpUriRequest req = (HttpUriRequest)localContext.getAttribute("http.request");
                URI root = new URI(host.getSchemeName(), null, host.getHostName(), host.getPort(), "/", null, null);
                tree.startDocument(root.resolve(req.getURI()));
                if (saveCookieKey != null) {
                    this.runtime.setCookieStore(saveCookieKey, (CookieStore)cookieStore);
                }
                String contentType = this.getContentType(httpResult);
                if (this.overrideContentType != null) {
                    if (this.xmlContentType(contentType) && this.overrideContentType.startsWith("image/") || contentType.startsWith("text/") && this.overrideContentType.startsWith("image/") || contentType.startsWith("image/") && this.xmlContentType(this.overrideContentType) || contentType.startsWith("image/") && this.overrideContentType.startsWith("text/") || contentType.startsWith("multipart/") && !this.overrideContentType.startsWith("multipart/") || !contentType.startsWith("multipart/") && this.overrideContentType.startsWith("multipart/")) {
                        throw XProcException.stepError(30);
                    }
                    contentType = this.overrideContentType;
                }
                if (this.detailed) {
                    tree.addStartElement(XProcConstants.c_response, (AttributeMap)SingletonAttributeMap.of((AttributeInfo)TypeUtils.attributeInfo(_status, "" + statusCode)));
                    for (Header header : httpResult.getAllHeaders()) {
                        String h = header.toString();
                        int cp = h.indexOf(":");
                        String name = header.getName();
                        String value = h.substring(cp + 1).trim();
                        EmptyAttributeMap attr = EmptyAttributeMap.getInstance();
                        attr = attr.put(TypeUtils.attributeInfo(_name, name));
                        attr = attr.put(TypeUtils.attributeInfo(_value, value));
                        tree.addStartElement(XProcConstants.c_header, (AttributeMap)attr);
                        tree.addEndElement();
                    }
                    if (!statusOnly && httpResult.getEntity() != null && (bodyStream = httpResult.getEntity().getContent()) != null) {
                        this.readBodyContent(tree, bodyStream, httpResult);
                    }
                    tree.addEndElement();
                    break block62;
                }
                if (statusOnly) {
                    break block62;
                }
                if (httpResult.getEntity() != null) {
                    ByteArrayOutputStream baos;
                    block63: {
                        bodyStream = httpResult.getEntity().getContent();
                        baos = new ByteArrayOutputStream();
                        try {
                            byte[] buf = new byte[4096];
                            int len = bodyStream.read(buf);
                            while (len >= 0) {
                                baos.write(buf, 0, len);
                                len = bodyStream.read(buf);
                            }
                        }
                        catch (ConnectionClosedException ex) {
                            if (ex.getMessage().contains("closing chunk expected")) break block63;
                            throw ex;
                        }
                    }
                    bodyStream = new ByteArrayInputStream(baos.toByteArray());
                    this.readBodyContent(tree, bodyStream, httpResult);
                    break block62;
                }
                throw XProcException.dynamicError(6, "Reading HTTP response on " + this.getStep().getName());
            }
            catch (XProcException e) {
                throw e;
            }
            catch (Exception e) {
                throw new XProcException(e);
            }
            finally {
                if (httpResult != null) {
                    EntityUtils.consumeQuietly((HttpEntity)httpResult.getEntity());
                }
            }
        }
        tree.endDocument();
        XdmNode resultNode = tree.getResult();
        this.result.write(resultNode);
    }

    private HttpGenericMethod doGenericMethod(String methodName) {
        HttpGenericMethod method = new HttpGenericMethod(methodName, this.requestURI);
        for (Header header : this.headers) {
            method.addHeader(header);
        }
        return method;
    }

    private HttpGenericMethodWithBody doGenericMethodWithBody(String methodName, XdmNode body) {
        HttpGenericMethodWithBody method = new HttpGenericMethodWithBody(methodName, this.requestURI);
        this.doPutOrPost((HttpEntityEnclosingRequest)method, body);
        return method;
    }

    private HttpGet doGet() {
        HttpGet method = new HttpGet(this.requestURI);
        for (Header header : this.headers) {
            method.addHeader(header);
        }
        return method;
    }

    private HttpHead doHead() {
        HttpHead method = new HttpHead(this.requestURI);
        for (Header header : this.headers) {
            method.addHeader(header);
        }
        return method;
    }

    private HttpDelete doDelete() {
        HttpDelete method = new HttpDelete(this.requestURI);
        for (Header header : this.headers) {
            method.addHeader(header);
        }
        return method;
    }

    private HttpPut doPut(XdmNode body) {
        HttpPut method = new HttpPut(this.requestURI);
        this.doPutOrPost((HttpEntityEnclosingRequest)method, body);
        return method;
    }

    private HttpPost doPost(XdmNode body) {
        HttpPost method = new HttpPost(this.requestURI);
        this.doPutOrPost((HttpEntityEnclosingRequest)method, body);
        return method;
    }

    private HttpPatch doPatch(XdmNode body) {
        HttpPatch method = new HttpPatch(this.requestURI);
        this.doPutOrPost((HttpEntityEnclosingRequest)method, body);
        return method;
    }

    private void doPutOrPost(HttpEntityEnclosingRequest method, XdmNode body) {
        if (XProcConstants.c_multipart.equals((Object)body.getNodeName())) {
            this.doPutOrPostMultipart(method, body);
        } else {
            this.doPutOrPostSinglepart(method, body);
        }
    }

    private void doPutOrPostSinglepart(HttpEntityEnclosingRequest method, XdmNode body) {
        String contentType = body.getAttributeValue(_content_type);
        if (contentType == null) {
            throw new XProcException(this.step.getNode(), "Content-type on c:body is required.");
        }
        String bodyId = body.getAttributeValue(_id);
        String bodyDescription = body.getAttributeValue(_description);
        String bodyDisposition = body.getAttributeValue(_disposition);
        boolean descriptionHeader = false;
        boolean idHeader = false;
        boolean dispositionHeader = false;
        if (bodyDescription != null) {
            for (Header header : this.headers) {
                if (!header.getName().equalsIgnoreCase("content-description")) continue;
                String headDescription = header.getValue();
                descriptionHeader = true;
                if (bodyDescription.equals(headDescription)) continue;
                throw XProcException.stepError(20);
            }
            if (!descriptionHeader) {
                this.headers.add((Header)new BasicHeader("Content-Description", bodyDescription));
            }
        }
        if (bodyId != null) {
            for (Header header : this.headers) {
                if (!header.getName().equalsIgnoreCase("content-id")) continue;
                String headId = header.getValue();
                idHeader = true;
                if (bodyId.equals(headId)) continue;
                throw XProcException.stepError(20);
            }
            if (!idHeader) {
                this.headers.add((Header)new BasicHeader("Content-Id", bodyId));
            }
        }
        if (bodyDisposition != null) {
            for (Header header : this.headers) {
                if (!header.getName().equalsIgnoreCase("content-disposition")) continue;
                String headDisposition = header.getValue();
                dispositionHeader = true;
                if (bodyDisposition.equals(headDisposition)) continue;
                throw XProcException.stepError(20);
            }
            if (!dispositionHeader) {
                this.headers.add((Header)new BasicHeader("Content-Disposition", bodyDisposition));
            }
        }
        if (this.headerContentType != null && !this.headerContentType.equals(contentType.toLowerCase())) {
            throw XProcException.stepError(20);
        }
        for (Header header : this.headers) {
            method.addHeader(header);
        }
        String encoding = body.getAttributeValue(_encoding);
        if (encoding != null && !"base64".equals(encoding)) {
            throw XProcException.stepError(52);
        }
        StringEntity requestEntity = null;
        try {
            if ("base64".equals(encoding)) {
                String charset = body.getAttributeValue(_charset);
                String content = this.extractText(body);
                byte[] decoded = Base64.decode(content);
                requestEntity = charset == null ? new ByteArrayEntity(decoded, ContentType.create((String)contentType)) : new ByteArrayEntity(decoded, ContentType.create((String)contentType, (String)charset));
            } else if (this.jsonContentType(contentType)) {
                requestEntity = new StringEntity(XMLtoJSON.convert(body), ContentType.create((String)contentType, (String)"UTF-8"));
            } else if (this.xmlContentType(contentType)) {
                Serializer serializer = this.makeSerializer();
                try {
                    S9apiUtils.assertDocumentContent((XdmSequenceIterator<XdmNode>)body.axisIterator(Axis.CHILD));
                }
                catch (XProcException xe) {
                    throw XProcException.stepError(22);
                }
                Vector<XdmNode> content = new Vector<XdmNode>();
                XdmSequenceIterator iter = body.axisIterator(Axis.CHILD);
                while (iter.hasNext()) {
                    XdmNode node = (XdmNode)iter.next();
                    content.add(node);
                }
                StringWriter writer = new StringWriter();
                serializer.setOutputWriter((Writer)writer);
                S9apiUtils.serialize(this.runtime, content, serializer);
                writer.close();
                requestEntity = new StringEntity(writer.toString(), ContentType.create((String)contentType, (String)"UTF-8"));
            } else {
                requestEntity = new StringEntity(this.extractText(body), ContentType.create((String)contentType, (String)"UTF-8"));
            }
            method.setEntity((HttpEntity)requestEntity);
        }
        catch (IOException | SaxonApiException ioe) {
            throw new XProcException(ioe);
        }
    }

    private void doPutOrPostMultipart(HttpEntityEnclosingRequest method, XdmNode document) {
        String contentType = document.getAttributeValue(_content_type);
        if (contentType == null) {
            contentType = "multipart/mixed";
        }
        if (this.headerContentType != null && !this.headerContentType.equals(contentType.toLowerCase())) {
            throw XProcException.stepError(20);
        }
        if (!contentType.startsWith("multipart/")) {
            throw new UnsupportedOperationException("Multipart content-type must be multipart/...");
        }
        for (Header header : this.headers) {
            method.addHeader(header);
        }
        String boundary = document.getAttributeValue(_boundary);
        if (boundary == null) {
            throw new XProcException(this.step.getNode(), "A boundary value must be specified on c:multipart");
        }
        if (boundary.startsWith("--")) {
            throw XProcException.stepError(2);
        }
        MultipartEntityBuilder entityBuilder = MultipartEntityBuilder.create();
        entityBuilder.setBoundary(boundary);
        entityBuilder.setContentType(ContentType.create((String)contentType));
        int partCount = 0;
        for (XdmNode body : new AxisNodes(document, Axis.CHILD, 7)) {
            String bodyEncoding;
            if (!XProcConstants.c_body.equals((Object)body.getNodeName())) {
                throw new XProcException(this.step.getNode(), "A c:multipart may only contain c:body elements.");
            }
            String bodyContentType = body.getAttributeValue(_content_type);
            if (bodyContentType == null) {
                throw new XProcException(this.step.getNode(), "Content-type on c:body is required.");
            }
            ++partCount;
            String bodyId = body.getAttributeValue(_id);
            String bodyDescription = body.getAttributeValue(_description);
            String bodyDisposition = body.getAttributeValue(_disposition);
            if (bodyContentType.contains(";")) {
                int pos = bodyContentType.indexOf(";");
                bodyContentType = bodyContentType.substring(0, pos);
            }
            if ((bodyEncoding = body.getAttributeValue(_encoding)) != null && !"base64".equals(bodyEncoding)) {
                throw new UnsupportedOperationException("The '" + bodyEncoding + "' encoding is not supported");
            }
            String bodyCharset = HttpUtils.getCharset(bodyContentType);
            if (bodyCharset == null) {
                bodyCharset = "UTF-8";
            }
            FormBodyPartBuilder part = FormBodyPartBuilder.create();
            ContentType partCT = ContentType.create((String)bodyContentType, (String)bodyCharset);
            part.setName("part" + partCount);
            if (bodyDescription != null) {
                part = part.addField("Content-Description", bodyDescription);
            }
            if (bodyId != null) {
                part = part.addField("Content-Id", bodyId);
            }
            if (bodyDisposition != null) {
                part = part.addField("Content-Disposition", bodyDisposition);
            }
            if (bodyEncoding != null && this.encodeBinary) {
                part = part.addField("Content-Tranfer-Encoding", bodyEncoding);
            }
            try {
                if (this.xmlContentType(bodyContentType)) {
                    Serializer serializer = this.makeSerializer();
                    Vector<XdmNode> content = new Vector<XdmNode>();
                    XdmSequenceIterator iter = body.axisIterator(Axis.CHILD);
                    while (iter.hasNext()) {
                        XdmNode node = (XdmNode)iter.next();
                        content.add(node);
                    }
                    StringWriter writer = new StringWriter();
                    serializer.setOutputWriter((Writer)writer);
                    S9apiUtils.serialize(this.runtime, content, serializer);
                    writer.close();
                    part = part.setBody((ContentBody)new StringBody(writer.toString(), partCT));
                    entityBuilder = entityBuilder.addPart(part.build());
                    continue;
                }
                if (this.jsonContentType(contentType)) {
                    part.setBody((ContentBody)new StringBody(XMLtoJSON.convert(body), partCT));
                    entityBuilder = entityBuilder.addPart(part.build());
                    continue;
                }
                if (!this.encodeBinary && "base64".equals(bodyEncoding)) {
                    byte[] decoded = Base64.decode(body.getStringValue());
                    part.setBody((ContentBody)new ByteArrayBody(decoded, partCT, "fred"));
                    entityBuilder = entityBuilder.addPart(part.build());
                    continue;
                }
                part.setBody((ContentBody)new StringBody(this.extractText(body), partCT));
                entityBuilder = entityBuilder.addPart(part.build());
            }
            catch (IOException | SaxonApiException ioe) {
                throw new XProcException(ioe);
            }
        }
        method.setEntity(entityBuilder.build());
    }

    private String getFullContentType(HttpResponse method) {
        Header contentTypeHeader = method.getLastHeader("Content-Type");
        return this.getFullContentType(contentTypeHeader);
    }

    private String getFullContentType(Header contentTypeHeader) {
        if (contentTypeHeader == null) {
            return "application/octet-stream";
        }
        HeaderElement[] contentTypes = contentTypeHeader.getElements();
        if (contentTypes == null || contentTypes.length == 0) {
            return null;
        }
        StringBuilder ctype = new StringBuilder(contentTypes[0].getName());
        NameValuePair[] params = contentTypes[0].getParameters();
        if (params != null) {
            for (NameValuePair pair : params) {
                ctype.append(";").append(pair.getName()).append("=\"").append(pair.getValue()).append("\"");
            }
        }
        return ctype.toString();
    }

    private String getHeaderValue(Header header) {
        if (header == null) {
            return null;
        }
        HeaderElement[] elems = header.getElements();
        if (elems == null || elems.length == 0) {
            return null;
        }
        return elems[0].getName();
    }

    private String getContentType(HttpResponse method) {
        Header contentTypeHeader = method.getLastHeader("Content-Type");
        String contentType = this.getContentType(contentTypeHeader);
        if (contentType == null) {
            return "application/octet-stream";
        }
        return contentType;
    }

    private String getContentType(Header contentTypeHeader) {
        return this.getHeaderValue(contentTypeHeader);
    }

    private String getContentBoundary(HttpResponse method) {
        Header contentTypeHeader = method.getLastHeader("Content-Type");
        return this.getContentBoundary(contentTypeHeader);
    }

    private String getContentBoundary(Header contentTypeHeader) {
        if (contentTypeHeader == null) {
            return null;
        }
        HeaderElement[] contentTypes = contentTypeHeader.getElements();
        if (contentTypes == null || contentTypes.length == 0) {
            return null;
        }
        NameValuePair boundary = contentTypes[0].getParameterByName("boundary");
        return boundary == null ? null : boundary.getValue();
    }

    private String getContentCharset(Header contentTypeHeader) {
        if (contentTypeHeader == null) {
            return null;
        }
        HeaderElement[] contentTypes = contentTypeHeader.getElements();
        if (contentTypes == null || contentTypes.length == 0) {
            return null;
        }
        NameValuePair cpair = contentTypes[0].getParameterByName("charset");
        if (cpair == null) {
            return "US-ASCII";
        }
        return cpair.getValue();
    }

    private boolean xmlContentType(String contentType) {
        return HttpUtils.xmlContentType(contentType);
    }

    private boolean jsonContentType(String contentType) {
        return this.runtime.transparentJSON() && HttpUtils.jsonContentType(contentType);
    }

    private boolean textContentType(String contentType) {
        return HttpUtils.textContentType(contentType);
    }

    private void readBodyContent(TreeWriter tree, InputStream bodyStream, HttpResponse method) throws SaxonApiException, IOException {
        String contentType = this.getFullContentType(method);
        Charset cs = ContentType.getOrDefault((HttpEntity)method.getEntity()).getCharset();
        String charset = cs == null ? Consts.ISO_8859_1.name() : cs.name();
        String boundary = this.getContentBoundary(method);
        if (this.overrideContentType != null) {
            contentType = this.overrideContentType;
        }
        if (contentType.startsWith("multipart/")) {
            EmptyAttributeMap attr = EmptyAttributeMap.getInstance();
            attr = attr.put(TypeUtils.attributeInfo(_content_type, contentType));
            attr = attr.put(TypeUtils.attributeInfo(_boundary, boundary));
            tree.addStartElement(XProcConstants.c_multipart, (AttributeMap)attr);
            this.readMultipartContent(tree, bodyStream, boundary);
            tree.addEndElement();
        } else if (!this.detailed && (this.xmlContentType(contentType) || this.jsonContentType(contentType))) {
            this.readBodyContentPart(tree, bodyStream, contentType, charset);
        } else {
            EmptyAttributeMap attr = EmptyAttributeMap.getInstance();
            attr = attr.put(TypeUtils.attributeInfo(_content_type, contentType));
            if (!(this.xmlContentType(contentType) || this.textContentType(contentType) || this.jsonContentType(contentType))) {
                attr = attr.put(TypeUtils.attributeInfo(_encoding, "base64"));
            }
            tree.addStartElement(XProcConstants.c_body, (AttributeMap)attr);
            this.readBodyContentPart(tree, bodyStream, contentType, charset);
            tree.addEndElement();
        }
    }

    private void readMultipartContent(TreeWriter tree, InputStream bodyStream, String boundary) throws IOException, SaxonApiException {
        MIMEReader reader = new MIMEReader(bodyStream, boundary);
        boolean done = false;
        while (reader.readHeaders()) {
            BufferedReader preader;
            Header pctype = reader.getHeader("Content-Type");
            Header pclen = reader.getHeader("Content-Length");
            String contentType = this.getHeaderValue(pctype);
            String charset = this.getContentCharset(pctype);
            String partType = this.getHeaderValue(pctype);
            InputStream partStream = null;
            if (pclen != null) {
                int len = Integer.parseInt(this.getHeaderValue(pclen));
                partStream = reader.readBodyPart(len);
            } else {
                partStream = reader.readBodyPart();
            }
            EmptyAttributeMap attr = EmptyAttributeMap.getInstance();
            attr = attr.put(TypeUtils.attributeInfo(_content_type, contentType));
            if (!this.xmlContentType(contentType) && !this.textContentType(contentType)) {
                attr = attr.put(TypeUtils.attributeInfo(_encoding, "base64"));
            }
            tree.addStartElement(XProcConstants.c_body, (AttributeMap)attr);
            if (this.xmlContentType(partType)) {
                preader = new BufferedReader(new InputStreamReader(partStream, charset));
                tree.addSubtree(this.runtime.parse(new InputSource(preader)));
            } else if (this.textContentType(partType)) {
                preader = new BufferedReader(new InputStreamReader(partStream, charset));
                char[] buf = new char[7296];
                int len = preader.read(buf, 0, 7296);
                while (len >= 0) {
                    char[] fbuf = new char[7296];
                    int flen = 0;
                    for (int pos = 0; pos < len; ++pos) {
                        if (buf[pos] == '\r') {
                            if (pos + 1 == len || buf[pos + 1] == '\n') continue;
                            int n = flen;
                            flen = (char)(flen + 1);
                            fbuf[n] = 10;
                            continue;
                        }
                        int n = flen;
                        flen = (char)(flen + 1);
                        fbuf[n] = buf[pos];
                    }
                    tree.addText(new String(fbuf, 0, flen));
                    len = preader.read(buf, 0, 7296);
                }
            } else {
                byte[] bytes = new byte[7296];
                int pos = 0;
                int readLen = 7296;
                int len = partStream.read(bytes, 0, 7296);
                while (len >= 0) {
                    pos += len;
                    if ((readLen -= len) == 0) {
                        tree.addText(Base64.encodeBytes(bytes));
                        pos = 0;
                        readLen = 7296;
                    }
                    len = partStream.read(bytes, pos, readLen);
                }
                if (pos > 0) {
                    byte[] lastBytes = new byte[pos];
                    System.arraycopy(bytes, 0, lastBytes, 0, pos);
                    tree.addText(Base64.encodeBytes(lastBytes));
                }
                tree.addText("\n");
            }
            tree.addEndElement();
        }
    }

    public void readBodyContentPart(TreeWriter tree, InputStream bodyStream, String contentType, String charset) throws SaxonApiException, IOException {
        if (this.xmlContentType(contentType)) {
            tree.addSubtree(this.runtime.parse(new InputSource(bodyStream)));
        } else if (this.textContentType(contentType)) {
            InputStreamReader reader = new InputStreamReader(bodyStream, charset);
            char[] buf = new char[7296];
            int len = reader.read(buf, 0, 7296);
            while (len >= 0) {
                String s = new String(buf, 0, len);
                tree.addText(s);
                len = reader.read(buf, 0, 7296);
            }
        } else if (this.jsonContentType(contentType)) {
            InputStreamReader reader = new InputStreamReader(bodyStream);
            JSONTokener jt = new JSONTokener(reader);
            XdmNode jsonDoc = JSONtoXML.convert(this.runtime.getProcessor(), jt, this.runtime.jsonFlavor());
            tree.addSubtree(jsonDoc);
        } else {
            byte[] bytes = new byte[7296];
            int pos = 0;
            int readLen = 7296;
            int len = bodyStream.read(bytes, 0, 7296);
            while (len >= 0) {
                pos += len;
                if ((readLen -= len) == 0) {
                    String encoded = Base64.encodeBytes(bytes);
                    tree.addText(encoded);
                    pos = 0;
                    readLen = 7296;
                }
                len = bodyStream.read(bytes, pos, readLen);
            }
            if (pos > 0) {
                byte[] lastBytes = new byte[pos];
                System.arraycopy(bytes, 0, lastBytes, 0, pos);
                tree.addText(Base64.encodeBytes(lastBytes));
            }
            tree.addText("\n");
        }
    }

    private String extractText(XdmNode doc) {
        StringBuilder content = new StringBuilder();
        XdmSequenceIterator iter = doc.axisIterator(Axis.CHILD);
        while (iter.hasNext()) {
            XdmNode child = (XdmNode)iter.next();
            if (child.getNodeKind() != XdmNodeKind.TEXT) {
                throw XProcException.stepError(28);
            }
            content.append(child.getStringValue());
        }
        return content.toString();
    }

    private void doFile(String href, String base) {
        try {
            DataStore store = this.runtime.getDataStore();
            store.readEntry(href, base, "application/xml, text/xml, */*", this.overrideContentType, new DataStore.DataReader(){

                @Override
                public void load(URI id, String contentType, InputStream bodyStream, long len) throws IOException {
                    String defCharset = System.getProperty("file.encoding", "UTF-8");
                    String charset = HttpUtils.getCharset(contentType, defCharset);
                    TreeWriter tree = new TreeWriter(HttpRequest.this.runtime);
                    tree.startDocument(id);
                    try {
                        if (HttpRequest.this.xmlContentType(contentType)) {
                            HttpRequest.this.readBodyContentPart(tree, bodyStream, contentType, charset);
                        } else {
                            EmptyAttributeMap attr = EmptyAttributeMap.getInstance();
                            attr = attr.put(TypeUtils.attributeInfo(_content_type, contentType));
                            if (!HttpRequest.this.xmlContentType(contentType) && !HttpRequest.this.textContentType(contentType)) {
                                attr = attr.put(TypeUtils.attributeInfo(DefaultStep._encoding, "base64"));
                            }
                            tree.addStartElement(XProcConstants.c_body, (AttributeMap)attr);
                            HttpRequest.this.readBodyContentPart(tree, bodyStream, contentType, charset);
                            tree.addEndElement();
                        }
                        tree.endDocument();
                        XdmNode doc = tree.getResult();
                        HttpRequest.this.result.write(doc);
                    }
                    catch (SaxonApiException sae) {
                        throw new XProcException(sae);
                    }
                }
            });
        }
        catch (IOException fnfe) {
            throw new XProcException(fnfe);
        }
    }

    private class HttpGenericMethodWithBody
    extends HttpEntityEnclosingRequestBase {
        private String method;

        public HttpGenericMethodWithBody(String method, URI requestURI) {
            this.method = method;
            this.setURI(requestURI);
        }

        public String getMethod() {
            return this.method;
        }
    }

    private class HttpGenericMethod
    extends HttpEntityEnclosingRequestBase {
        private String method;

        public HttpGenericMethod(String method, URI requestURI) {
            this.method = method;
            this.setURI(requestURI);
        }

        public String getMethod() {
            return this.method;
        }
    }
}

