/*
 * Decompiled with CFR 0.152.
 */
package com.xmlcalabash.library;

import com.xmlcalabash.core.XMLCalabash;
import com.xmlcalabash.core.XProcConstants;
import com.xmlcalabash.core.XProcException;
import com.xmlcalabash.core.XProcRuntime;
import com.xmlcalabash.io.ReadablePipe;
import com.xmlcalabash.io.WritablePipe;
import com.xmlcalabash.library.DefaultStep;
import com.xmlcalabash.runtime.XAtomicStep;
import com.xmlcalabash.util.MessageFormatter;
import com.xmlcalabash.util.TreeWriter;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.regex.Pattern;
import net.sf.saxon.lib.ModuleURIResolver;
import net.sf.saxon.s9api.Destination;
import net.sf.saxon.s9api.Processor;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.Serializer;
import net.sf.saxon.s9api.XQueryCompiler;
import net.sf.saxon.s9api.XQueryEvaluator;
import net.sf.saxon.s9api.XQueryExecutable;
import net.sf.saxon.s9api.XdmItem;
import net.sf.saxon.s9api.XdmNode;
import org.xml.sax.InputSource;

@XMLCalabash(name="p:exec", type="{http://www.w3.org/ns/xproc}exec")
public class Exec
extends DefaultStep {
    private static final QName c_result = XProcConstants.qNameFor(XProcConstants.NS_XPROC_STEP, "result");
    private static final QName c_line = XProcConstants.qNameFor(XProcConstants.NS_XPROC_STEP, "line");
    private static final QName cx_show_stderr = XProcConstants.qNameFor(XProcConstants.NS_CALABASH_EX, "show-stderr");
    private static final QName _command = new QName("", "command");
    private static final QName _args = new QName("", "args");
    private static final QName _cwd = new QName("", "cwd");
    private static final QName _source_is_xml = new QName("", "source-is-xml");
    private static final QName _result_is_xml = new QName("", "result-is-xml");
    private static final QName _wrap_result_lines = new QName("", "wrap-result-lines");
    private static final QName _errors_is_xml = new QName("", "errors-is-xml");
    private static final QName _wrap_error_lines = new QName("", "wrap-error-lines");
    private static final QName _path_separator = new QName("", "path-separator");
    private static final QName _failure_threshold = new QName("", "failure-threshold");
    private static final QName _arg_separator = new QName("", "arg-separator");
    private ReadablePipe source = null;
    private WritablePipe result = null;
    private WritablePipe errors = null;
    private WritablePipe status = null;
    private String pathSeparator = null;
    private boolean failureThreshold = false;
    private int failureThresholdValue = 0;
    private String argSeparator = null;

    public Exec(XProcRuntime runtime, XAtomicStep step) {
        super(runtime, step);
    }

    @Override
    public void setInput(String port, ReadablePipe pipe) {
        this.source = pipe;
    }

    @Override
    public void setOutput(String port, WritablePipe pipe) {
        if ("result".equals(port)) {
            this.result = pipe;
        } else if ("errors".equals(port)) {
            this.errors = pipe;
        } else {
            this.status = pipe;
        }
    }

    @Override
    public void reset() {
        this.source.resetReader();
        this.result.resetWriter();
        this.errors.resetWriter();
        this.status.resetWriter();
    }

    @Override
    public void run() throws SaxonApiException {
        super.run();
        if (this.runtime.getSafeMode()) {
            throw XProcException.dynamicError(21);
        }
        String command = this.getOption(_command).getString();
        String args = this.getOption(_args, (String)null);
        String cwd = this.getOption(_cwd, (String)null);
        boolean sourceIsXML = this.getOption(_source_is_xml, false);
        boolean resultIsXML = this.getOption(_result_is_xml, false);
        boolean errorsIsXML = this.getOption(_errors_is_xml, false);
        boolean wrapResultLines = this.getOption(_wrap_result_lines, false);
        boolean wrapErrorLines = this.getOption(_wrap_error_lines, false);
        if (this.getOption(_path_separator) != null) {
            this.pathSeparator = this.getOption(_path_separator).getString();
            if (this.pathSeparator.length() != 1) {
                throw XProcException.stepError(63);
            }
        }
        if (this.getOption(_failure_threshold) != null) {
            this.failureThreshold = true;
            this.failureThresholdValue = Integer.parseInt(this.getOption(_failure_threshold).getString());
        }
        if (this.getOption(_arg_separator) != null) {
            this.argSeparator = this.getOption(_arg_separator).getString();
            if (this.argSeparator.length() != 1) {
                throw XProcException.stepError(66);
            }
        }
        String slash = System.getProperty("file.separator");
        if (command == null || "".equals(command)) {
            throw XProcException.stepError(33);
        }
        if (resultIsXML && wrapResultLines || errorsIsXML && wrapErrorLines) {
            throw new XProcException(XProcException.stepError(34));
        }
        if (this.pathSeparator != null) {
            command = command.replaceAll(Pattern.quote(this.pathSeparator), slash);
        }
        StringBuilder showCmd = new StringBuilder();
        try {
            ArrayList<String> command_line = new ArrayList<String>();
            command_line.add(command);
            showCmd.append(command);
            if (args != null && !"".equals(args)) {
                String[] arglist;
                if (this.pathSeparator != null) {
                    args = args.replaceAll(Pattern.quote(this.pathSeparator), slash);
                }
                for (String arg : arglist = args.split("\\" + this.argSeparator)) {
                    command_line.add(arg);
                    showCmd.append(" ").append(arg);
                }
            }
            ProcessBuilder builder = new ProcessBuilder(command_line);
            if (cwd != null) {
                File dir = new File(cwd);
                if (!dir.isDirectory() || !dir.canRead()) {
                    throw XProcException.stepError(34, "Cannot change to requested directory: " + cwd);
                }
                builder.directory(new File(cwd));
            }
            this.logger.trace(MessageFormatter.nodeMessage(this.step.getNode(), "Exec: " + showCmd.toString()));
            Process process = builder.start();
            boolean showStderr = !"false".equals(this.step.getExtensionAttribute(cx_show_stderr));
            ProcessOutputReader stdoutReader = new ProcessOutputReader(process.getInputStream(), resultIsXML, wrapResultLines, false);
            ProcessOutputReader stderrReader = new ProcessOutputReader(process.getErrorStream(), errorsIsXML, wrapErrorLines, showStderr);
            Thread stdoutThread = new Thread(stdoutReader);
            Thread stderrThread = new Thread(stderrReader);
            stdoutThread.start();
            stderrThread.start();
            if (this.source.moreDocuments()) {
                XdmNode srcDoc = this.source.read();
                if (this.source.moreDocuments()) {
                    throw XProcException.dynamicError(6, "Reading source on " + this.getStep().getName());
                }
                try (OutputStream os = process.getOutputStream();){
                    Serializer serializer = this.makeSerializer();
                    String queryexpr = null;
                    if (sourceIsXML) {
                        queryexpr = ".";
                    } else {
                        queryexpr = "//text()";
                        serializer.setOutputProperty(Serializer.Property.METHOD, "text");
                        serializer.setOutputProperty(Serializer.Property.OMIT_XML_DECLARATION, "yes");
                    }
                    Processor qtproc = this.runtime.getProcessor();
                    XQueryCompiler xqcomp = qtproc.newXQueryCompiler();
                    xqcomp.setModuleURIResolver((ModuleURIResolver)this.runtime.getResolver());
                    XQueryExecutable xqexec = xqcomp.compile(queryexpr);
                    XQueryEvaluator xqeval = xqexec.load();
                    xqeval.setContextItem((XdmItem)srcDoc);
                    serializer.setOutputStream(os);
                    xqeval.setDestination((Destination)serializer);
                    xqeval.run();
                }
            } else {
                OutputStream os = process.getOutputStream();
                os.close();
            }
            int rc = 0;
            try {
                rc = process.waitFor();
                stdoutThread.join();
                stderrThread.join();
            }
            catch (InterruptedException tie) {
                throw new XProcException(tie);
            }
            if (this.failureThreshold && rc > this.failureThresholdValue) {
                throw XProcException.stepError(64);
            }
            TreeWriter tree = new TreeWriter(this.runtime);
            tree.startDocument(this.step.getNode().getBaseURI());
            tree.addStartElement(c_result);
            tree.addText("" + rc);
            tree.addEndElement();
            tree.endDocument();
            XdmNode execResult = tree.getResult();
            this.status.write(execResult);
            execResult = stdoutReader.getResult();
            this.result.write(execResult);
            execResult = stderrReader.getResult();
            this.errors.write(execResult);
        }
        catch (IOException ex) {
            throw new XProcException(ex);
        }
    }

    private class ProcessOutputReader
    implements Runnable {
        private InputStream is;
        private boolean asXML;
        private boolean showLines;
        private boolean wrapLines;
        private TreeWriter tree;

        public ProcessOutputReader(InputStream is, boolean asXML, boolean wrapLines, boolean showLines) {
            this.is = is;
            this.asXML = asXML;
            this.wrapLines = wrapLines;
            this.showLines = showLines;
            this.tree = new TreeWriter(Exec.this.runtime);
        }

        public XdmNode getResult() {
            return this.tree.getResult();
        }

        @Override
        public void run() {
            this.tree.startDocument(Exec.this.step.getNode().getBaseURI());
            this.tree.addStartElement(c_result);
            if (this.asXML) {
                XdmNode doc = Exec.this.runtime.parse(new InputSource(this.is));
                this.tree.addSubtree(doc);
            } else {
                try {
                    if (this.wrapLines) {
                        BufferedReader br = new BufferedReader(new InputStreamReader(this.is));
                        String line = br.readLine();
                        while (line != null) {
                            if (this.showLines) {
                                System.err.println(line);
                            }
                            this.tree.addStartElement(c_line);
                            this.tree.addText(line);
                            this.tree.addEndElement();
                            this.tree.addText("\n");
                            line = br.readLine();
                        }
                    } else {
                        InputStreamReader r = new InputStreamReader(this.is);
                        char[] buf = new char[1000];
                        int len = r.read(buf, 0, buf.length);
                        while (len >= 0) {
                            if (len == 0) {
                                Thread.sleep(1000L);
                                continue;
                            }
                            String s = new String(buf, 0, len);
                            if (this.showLines) {
                                System.err.print(s);
                            }
                            this.tree.addText(s);
                            len = r.read(buf, 0, buf.length);
                        }
                    }
                }
                catch (IOException ioe) {
                    throw new XProcException(ioe);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            this.tree.addEndElement();
            this.tree.endDocument();
        }
    }
}

