/*
 * Decompiled with CFR 0.152.
 */
package com.xmlcalabash.library;

import com.xmlcalabash.core.XMLCalabash;
import com.xmlcalabash.core.XProcConstants;
import com.xmlcalabash.core.XProcException;
import com.xmlcalabash.core.XProcRuntime;
import com.xmlcalabash.io.ReadablePipe;
import com.xmlcalabash.io.WritablePipe;
import com.xmlcalabash.library.DefaultStep;
import com.xmlcalabash.model.RuntimeValue;
import com.xmlcalabash.runtime.XAtomicStep;
import com.xmlcalabash.util.TreeWriter;
import com.xmlcalabash.util.TypeUtils;
import net.sf.saxon.om.AttributeMap;
import net.sf.saxon.om.EmptyAttributeMap;
import net.sf.saxon.om.NamespaceMap;
import net.sf.saxon.om.NamespaceUri;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.XdmNode;

@XMLCalabash(name="p:error", type="{http://www.w3.org/ns/xproc}error")
public class Error
extends DefaultStep {
    private static final QName c_error = XProcConstants.qNameFor(XProcConstants.NS_XPROC_STEP, "error");
    private static final QName _name = new QName("name");
    private static final QName _code = new QName("code");
    private static final QName _code_prefix = new QName("code-prefix");
    private static final QName _code_namespace = new QName("code-namespace");
    private static final QName _type = new QName("type");
    private ReadablePipe source = null;

    public Error(XProcRuntime runtime, XAtomicStep step) {
        super(runtime, step);
    }

    @Override
    public void setInput(String port, ReadablePipe pipe) {
        this.source = pipe;
    }

    @Override
    public void setOutput(String port, WritablePipe pipe) {
    }

    @Override
    public void reset() {
        this.source.resetReader();
    }

    @Override
    public void run() throws SaxonApiException {
        super.run();
        XdmNode doc = this.source.read();
        if (doc == null) {
            this.logger.trace("Error step read empty");
        } else {
            this.logger.trace("Error step read " + doc.getDocumentURI());
        }
        RuntimeValue codeNameValue = this.getOption(_code);
        String codeNameStr = codeNameValue.getString();
        String cpfx = this.getOption(_code_prefix, (String)null);
        NamespaceUri cns = NamespaceUri.of((String)this.getOption(_code_namespace, (String)null));
        if (cpfx == null && cns != NamespaceUri.NULL) {
            cpfx = "ERR";
        }
        if (cpfx != null && cns == NamespaceUri.NULL) {
            throw XProcException.dynamicError(34, "You can't specify a prefix without a namespace");
        }
        if (cns != NamespaceUri.NULL && codeNameStr.contains(":")) {
            throw XProcException.dynamicError(34, "You can't specify a namespace if the code name contains a colon");
        }
        QName errorCode = null;
        errorCode = codeNameStr.contains(":") ? new QName(codeNameStr, codeNameValue.getNode()) : new QName(cpfx == null ? "" : cpfx, cns.toString(), codeNameStr);
        cpfx = errorCode.getPrefix();
        cns = errorCode.getNamespaceUri();
        TreeWriter treeWriter = new TreeWriter(this.runtime);
        treeWriter.startDocument(this.step.getNode().getBaseURI());
        EmptyAttributeMap attr = EmptyAttributeMap.getInstance();
        NamespaceMap nsmap = NamespaceMap.emptyMap();
        nsmap = nsmap.put(cpfx, cns);
        attr = attr.put(TypeUtils.attributeInfo(_name, this.step.getName()));
        attr = attr.put(TypeUtils.attributeInfo(_type, "p:error"));
        attr = attr.put(TypeUtils.attributeInfo(_code, errorCode.toString()));
        treeWriter.addStartElement(c_error, (AttributeMap)attr, nsmap);
        if (doc != null) {
            treeWriter.addSubtree(doc);
        }
        treeWriter.addEndElement();
        treeWriter.endDocument();
        this.step.reportError(treeWriter.getResult());
        if (doc == null) {
            throw new XProcException(errorCode);
        }
        throw new XProcException(errorCode, doc, doc.getStringValue());
    }
}

