/*
 * Decompiled with CFR 0.152.
 */
package com.xmlcalabash.library;

import com.xmlcalabash.core.XMLCalabash;
import com.xmlcalabash.core.XProcConstants;
import com.xmlcalabash.core.XProcException;
import com.xmlcalabash.core.XProcRuntime;
import com.xmlcalabash.io.ReadablePipe;
import com.xmlcalabash.io.WritablePipe;
import com.xmlcalabash.library.DefaultStep;
import com.xmlcalabash.model.RuntimeValue;
import com.xmlcalabash.runtime.XAtomicStep;
import com.xmlcalabash.util.ProcessMatch;
import com.xmlcalabash.util.ProcessMatchingNodes;
import com.xmlcalabash.util.TypeUtils;
import net.sf.saxon.om.AttributeInfo;
import net.sf.saxon.om.AttributeMap;
import net.sf.saxon.om.NamespaceUri;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.XdmNode;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.SimpleType;

@XMLCalabash(name="p:add-attribute", type="{http://www.w3.org/ns/xproc}add-attribute")
public class AddAttribute
extends DefaultStep
implements ProcessMatchingNodes {
    private static final QName _match = new QName("", "match");
    private static final QName _attribute_name = new QName("", "attribute-name");
    private static final QName _attribute_value = new QName("", "attribute-value");
    private static final QName _attribute_prefix = new QName("", "attribute-prefix");
    private static final QName _attribute_namespace = new QName("", "attribute-namespace");
    private QName attrName = null;
    private String attrValue = null;
    private ProcessMatch matcher = null;
    private ReadablePipe source = null;
    private WritablePipe result = null;

    public AddAttribute(XProcRuntime runtime, XAtomicStep step) {
        super(runtime, step);
    }

    @Override
    public void setInput(String port, ReadablePipe pipe) {
        this.source = pipe;
    }

    @Override
    public void setOutput(String port, WritablePipe pipe) {
        this.result = pipe;
    }

    @Override
    public void reset() {
        this.source.resetReader();
        this.result.resetWriter();
    }

    @Override
    public void run() throws SaxonApiException {
        super.run();
        RuntimeValue attrNameValue = this.getOption(_attribute_name);
        String attrNameStr = attrNameValue.getString();
        String apfx = this.getOption(_attribute_prefix, (String)null);
        String ans = this.getOption(_attribute_namespace, (String)null);
        if (apfx != null && ans == null) {
            throw XProcException.dynamicError(34, "You can't specify a prefix without a namespace");
        }
        if (ans != null && attrNameStr.contains(":")) {
            throw XProcException.dynamicError(34, "You can't specify a namespace if the attribute name contains a colon");
        }
        this.attrName = attrNameStr.contains(":") ? new QName(attrNameStr, attrNameValue.getNode()) : new QName(apfx == null ? "" : apfx, ans, attrNameStr);
        this.attrValue = this.getOption(_attribute_value).getString();
        if ("xmlns".equals(this.attrName.getLocalName()) || "xmlns".equals(this.attrName.getPrefix()) || this.attrName.getNamespaceUri() == XProcConstants.NS_XML_ATTR || !"xml".equals(this.attrName.getPrefix()) && this.attrName.getNamespaceUri() == XProcConstants.NS_XML || "xml".equals(this.attrName.getPrefix()) && this.attrName.getNamespaceUri() != XProcConstants.NS_XML) {
            throw XProcException.stepError(59);
        }
        this.matcher = new ProcessMatch(this.runtime, this);
        this.matcher.match(this.source.read(), this.getOption(_match));
        this.result.write(this.matcher.getResult());
    }

    @Override
    public boolean processStartDocument(XdmNode node) {
        throw XProcException.stepError(13);
    }

    @Override
    public void processEndDocument(XdmNode node) {
        throw XProcException.stepError(13);
    }

    @Override
    public AttributeMap processAttributes(XdmNode node, AttributeMap matchingAttributes, AttributeMap nonMatchingAttributes) {
        return null;
    }

    @Override
    public boolean processStartElement(XdmNode node, AttributeMap attributes) {
        QName instanceAttrName = this.attrName;
        if (this.attrName.getNamespaceUri() != NamespaceUri.NULL) {
            String prefix = this.attrName.getPrefix();
            for (AttributeInfo attr : attributes) {
                if (!prefix.equals(attr.getNodeName().getPrefix()) || this.attrName.getNamespaceUri() == NamespaceUri.of((String)attr.getNodeName().getURI())) continue;
                prefix = "";
            }
            if ("".equals(prefix)) {
                int acount = 0;
                String aprefix = "_0";
                boolean done = false;
                while (!done) {
                    aprefix = "_" + ++acount;
                    done = true;
                    for (AttributeInfo attr : attributes) {
                        done = done && !prefix.equals(attr.getNodeName().getPrefix());
                    }
                }
                instanceAttrName = new QName(aprefix, this.attrName.getNamespaceUri().toString(), this.attrName.getLocalName());
            }
        }
        AttributeInfo ainfo = new AttributeInfo((NodeName)TypeUtils.fqName(instanceAttrName), (SimpleType)BuiltInAtomicType.ANY_ATOMIC, this.attrValue, null, 0);
        this.matcher.addStartElement(node, attributes.put(ainfo));
        return true;
    }

    @Override
    public void processEndElement(XdmNode node) {
        this.matcher.addEndElement();
    }

    @Override
    public void processText(XdmNode node) {
        throw XProcException.stepError(23);
    }

    @Override
    public void processComment(XdmNode node) {
        throw XProcException.stepError(23);
    }

    @Override
    public void processPI(XdmNode node) {
        throw XProcException.stepError(23);
    }
}

