/*
 * Decompiled with CFR 0.152.
 */
package com.xmlcalabash.io;

import com.xmlcalabash.core.XProcException;
import com.xmlcalabash.core.XProcRuntime;
import com.xmlcalabash.io.DataStore;
import com.xmlcalabash.io.WritablePipe;
import com.xmlcalabash.model.Serialization;
import com.xmlcalabash.model.Step;
import com.xmlcalabash.util.MessageFormatter;
import com.xmlcalabash.util.S9apiUtils;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.Serializer;
import net.sf.saxon.s9api.XdmNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WritableDocument
implements WritablePipe {
    private Logger logger = LoggerFactory.getLogger(WritableDocument.class);
    private Serializer serializer = null;
    private int writeCount = 0;
    private String uri = null;
    private URI journal = null;
    private XProcRuntime runtime = null;
    private Serialization serial = null;
    private boolean writeSeqOk = false;
    private Step writer = null;
    private OutputStream ostream = null;

    public WritableDocument(XProcRuntime xproc, String uri, Serialization serial) {
        this.runtime = xproc;
        this.uri = uri;
        if (serial == null) {
            this.serial = new Serialization(xproc, null);
            this.serial.setIndent(xproc.getDebug());
        } else {
            this.serial = serial;
        }
    }

    public WritableDocument(XProcRuntime xproc, String uri, Serialization serial, OutputStream out) {
        this.runtime = xproc;
        this.uri = uri;
        this.ostream = out;
        if (serial == null) {
            this.serial = new Serialization(xproc, null);
            this.serial.setIndent(xproc.getDebug());
        } else {
            this.serial = serial;
        }
    }

    @Override
    public void canWriteSequence(boolean sequence) {
        this.writeSeqOk = sequence;
    }

    @Override
    public boolean writeSequence() {
        return this.writeSeqOk;
    }

    @Override
    public void resetWriter() {
        throw new UnsupportedOperationException("You can't resetWriter a WritableDocument");
    }

    @Override
    public void close() {
        if (this.ostream != null) {
            try {
                this.ostream.close();
            }
            catch (IOException ex) {
                throw new RuntimeException(ex.getMessage(), ex);
            }
        }
    }

    @Override
    public void setWriter(Step step) {
        this.writer = step;
    }

    @Override
    public void write(final XdmNode doc) {
        try {
            this.serializer = this.runtime.getProcessor().newSerializer();
            this.serializer.setOutputProperty(Serializer.Property.BYTE_ORDER_MARK, this.serial.getByteOrderMark() ? "yes" : "no");
            if (this.serial.getDoctypePublic() != null) {
                this.serializer.setOutputProperty(Serializer.Property.DOCTYPE_PUBLIC, this.serial.getDoctypePublic());
            }
            if (this.serial.getDoctypeSystem() != null) {
                this.serializer.setOutputProperty(Serializer.Property.DOCTYPE_SYSTEM, this.serial.getDoctypeSystem());
            }
            if (this.serial.getEncoding() != null) {
                this.serializer.setOutputProperty(Serializer.Property.ENCODING, this.serial.getEncoding());
            }
            this.serializer.setOutputProperty(Serializer.Property.ESCAPE_URI_ATTRIBUTES, this.serial.getEscapeURIAttributes() ? "yes" : "no");
            this.serializer.setOutputProperty(Serializer.Property.INCLUDE_CONTENT_TYPE, this.serial.getIncludeContentType() ? "yes" : "no");
            this.serializer.setOutputProperty(Serializer.Property.INDENT, this.serial.getIndent() ? "yes" : "no");
            String media = this.serial.getMediaType();
            if (media == null) {
                media = "application/xml";
            } else {
                this.serializer.setOutputProperty(Serializer.Property.MEDIA_TYPE, media);
            }
            if (this.serial.getMethod() != null) {
                this.serializer.setOutputProperty(Serializer.Property.METHOD, this.serial.getMethod().getLocalName());
            }
            if (this.serial.getNormalizationForm() != null) {
                this.serializer.setOutputProperty(Serializer.Property.NORMALIZATION_FORM, this.serial.getNormalizationForm());
            }
            this.serializer.setOutputProperty(Serializer.Property.OMIT_XML_DECLARATION, this.serial.getOmitXMLDeclaration() ? "yes" : "no");
            if (this.serial.getStandalone() != null) {
                String standalone = this.serial.getStandalone();
                if ("true".equals(standalone)) {
                    this.serializer.setOutputProperty(Serializer.Property.STANDALONE, "yes");
                } else if ("false".equals(standalone)) {
                    this.serializer.setOutputProperty(Serializer.Property.STANDALONE, "no");
                }
            }
            this.serializer.setOutputProperty(Serializer.Property.UNDECLARE_PREFIXES, this.serial.getUndeclarePrefixes() ? "yes" : "no");
            if (this.serial.getVersion() != null) {
                this.serializer.setOutputProperty(Serializer.Property.VERSION, this.serial.getVersion());
            }
            if (this.serial.getCdataSectionElements() != null) {
                this.serializer.setOutputProperty(Serializer.Property.CDATA_SECTION_ELEMENTS, this.serial.getCdataSectionElements());
            }
            if (this.ostream != null) {
                this.serializer.setOutputStream(this.ostream);
                S9apiUtils.serialize(this.runtime, doc, this.serializer);
            } else if (this.uri == null) {
                this.serializer.setOutputStream((OutputStream)System.out);
                S9apiUtils.serialize(this.runtime, doc, this.serializer);
            } else {
                try {
                    DataStore store = this.runtime.getDataStore();
                    store.writeEntry(this.uri, this.uri, media, new DataStore.DataWriter(){

                        @Override
                        public void store(OutputStream ostream) throws IOException {
                            WritableDocument.this.logger.trace("Attempt to write file: " + WritableDocument.this.uri);
                            WritableDocument.this.serializer.setOutputStream(ostream);
                            try {
                                S9apiUtils.serialize(WritableDocument.this.runtime, doc, WritableDocument.this.serializer);
                            }
                            catch (SaxonApiException e) {
                                throw new IOException(e);
                            }
                        }
                    });
                }
                catch (IOException ex) {
                    if (ex.getCause() instanceof SaxonApiException) {
                        throw (SaxonApiException)ex.getCause();
                    }
                    this.runtime.error(ex);
                }
            }
            ++this.writeCount;
            if ((this.ostream == null && this.uri == null && this.writeCount > 1 || System.out.equals(this.ostream)) && this.runtime.getDebug()) {
                System.out.println("\n--<document boundary>--------------------------------------------------------------------------");
            }
        }
        catch (SaxonApiException sae) {
            this.logger.debug(sae.getMessage(), (Throwable)sae);
            throw new XProcException(sae);
        }
        if (this.writer != null) {
            this.logger.trace(MessageFormatter.nodeMessage(this.writer.getNode(), this.writer.getName() + " wrote '" + (doc == null ? "null" : doc.getBaseURI())));
        }
    }

    public int documentsWritten() {
        return this.writeCount;
    }

    public int documentsRead() {
        return 1;
    }
}

