/*
 * Decompiled with CFR 0.152.
 */
package com.xmlcalabash.io;

import com.xmlcalabash.core.XProcException;
import com.xmlcalabash.core.XProcRuntime;
import com.xmlcalabash.io.DocumentSequence;
import com.xmlcalabash.io.ReadablePipe;
import com.xmlcalabash.model.NamespaceBinding;
import com.xmlcalabash.model.Step;
import com.xmlcalabash.util.MessageFormatter;
import com.xmlcalabash.util.S9apiUtils;
import net.sf.saxon.s9api.Destination;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.XPathCompiler;
import net.sf.saxon.s9api.XPathExecutable;
import net.sf.saxon.s9api.XPathSelector;
import net.sf.saxon.s9api.XdmDestination;
import net.sf.saxon.s9api.XdmItem;
import net.sf.saxon.s9api.XdmNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Select
implements ReadablePipe {
    private ReadablePipe source = null;
    private String select = null;
    private XdmNode context = null;
    private DocumentSequence documents = null;
    private XPathSelector selector = null;
    private XProcRuntime runtime = null;
    private boolean initialized = false;
    private int docindex = 0;
    private Step reader = null;
    private Logger logger = LoggerFactory.getLogger(Select.class);

    public Select(XProcRuntime runtime, ReadablePipe readFrom, String xpathExpr, XdmNode xpathContext) {
        this.source = readFrom;
        this.select = xpathExpr;
        this.context = xpathContext;
        this.runtime = runtime;
        this.documents = new DocumentSequence(runtime);
    }

    @Override
    public void canReadSequence(boolean sequence) {
    }

    @Override
    public boolean readSequence() {
        return true;
    }

    private void readSource() {
        this.initialized = true;
        try {
            NamespaceBinding bindings = new NamespaceBinding(this.runtime, this.context);
            XPathCompiler xcomp = this.runtime.newXPathCompiler(this.context.getBaseURI(), bindings.getNamespaceBindings());
            XPathExecutable xexec = xcomp.compile(this.select);
            this.selector = xexec.load();
        }
        catch (SaxonApiException sae) {
            throw new XProcException(sae);
        }
        while (this.source.moreDocuments()) {
            try {
                XdmNode doc = this.source.read();
                if (this.reader != null) {
                    this.logger.trace(MessageFormatter.nodeMessage(this.reader.getNode(), this.reader.getName() + " select read '" + (doc == null ? "null" : doc.getBaseURI()) + "' from " + this.source));
                }
                this.selector.setContextItem((XdmItem)doc);
                for (XdmItem item : this.selector) {
                    XdmNode node = null;
                    try {
                        node = (XdmNode)item;
                    }
                    catch (ClassCastException cce) {
                        throw new XProcException(this.context, "Select matched non-node!?");
                    }
                    XdmDestination dest = new XdmDestination();
                    S9apiUtils.writeXdmValue(this.runtime, (XdmItem)node, (Destination)dest, node.getBaseURI());
                    XdmNode sdoc = dest.getXdmNode();
                    if (this.reader != null) {
                        this.logger.trace(MessageFormatter.nodeMessage(this.reader.getNode(), this.reader.getName() + " select wrote '" + (sdoc == null ? "null" : sdoc.getBaseURI()) + "' to " + this.documents));
                    }
                    this.documents.add(sdoc);
                }
            }
            catch (SaxonApiException sae) {
                throw new XProcException(sae);
            }
        }
    }

    @Override
    public void resetReader() {
        this.docindex = 0;
    }

    @Override
    public boolean moreDocuments() {
        if (!this.initialized) {
            this.readSource();
        }
        return this.docindex < this.documents.size();
    }

    @Override
    public boolean closed() {
        return true;
    }

    @Override
    public int documentCount() {
        if (!this.initialized) {
            this.readSource();
        }
        return this.documents.size();
    }

    @Override
    public DocumentSequence documents() {
        return this.documents;
    }

    @Override
    public void setReader(Step step) {
        this.reader = step;
    }

    @Override
    public void setNames(String stepName, String portName) {
    }

    @Override
    public XdmNode read() {
        if (!this.initialized) {
            this.readSource();
        }
        XdmNode doc = null;
        if (this.moreDocuments()) {
            doc = this.documents.get(this.docindex++);
        }
        if (this.reader != null) {
            this.logger.trace(MessageFormatter.nodeMessage(this.reader.getNode(), this.reader.getName() + " read '" + (doc == null ? "null" : doc.getBaseURI()) + "' from " + this));
        }
        return doc;
    }
}

