/*
 * Decompiled with CFR 0.152.
 */
package com.xmlcalabash.io;

import com.xmlcalabash.core.XProcException;
import com.xmlcalabash.core.XProcRuntime;
import com.xmlcalabash.io.DataStore;
import com.xmlcalabash.io.DocumentSequence;
import com.xmlcalabash.io.ReadablePipe;
import com.xmlcalabash.model.Step;
import com.xmlcalabash.util.HttpUtils;
import com.xmlcalabash.util.JSONtoXML;
import com.xmlcalabash.util.MessageFormatter;
import com.xmlcalabash.util.XPointer;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.Vector;
import java.util.regex.Pattern;
import net.sf.saxon.s9api.Processor;
import net.sf.saxon.s9api.XdmNode;
import org.json.JSONTokener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReadableDocument
implements ReadablePipe {
    private static final String ACCEPT_XML = "application/xml, text/xml, application/xml-external-parsed-entity, text/xml-external-parsed-entity";
    private static final String ACCEPT_JSON = "application/json, application/javascript, text/javascript, text/*, */*";
    private Logger logger = LoggerFactory.getLogger(ReadableDocument.class);
    protected DocumentSequence documents = null;
    protected String uri = null;
    protected XProcRuntime runtime = null;
    private int pos = 0;
    private String base = null;
    private XdmNode node = null;
    private boolean readDoc = false;
    private Step reader = null;
    private Pattern pattern = null;

    public ReadableDocument(XProcRuntime runtime) {
        this.runtime = runtime;
        this.documents = new DocumentSequence(runtime);
    }

    public ReadableDocument(XProcRuntime runtime, XdmNode node, String uri, String base, String mask) {
        this.runtime = runtime;
        this.node = node;
        this.uri = uri;
        this.base = base;
        if (mask != null) {
            this.pattern = Pattern.compile(mask);
        }
        this.documents = new DocumentSequence(runtime);
    }

    @Override
    public void canReadSequence(boolean sequence) {
    }

    @Override
    public boolean readSequence() {
        return false;
    }

    @Override
    public void resetReader() {
        this.pos = 0;
    }

    @Override
    public void setReader(Step step) {
        this.reader = step;
    }

    @Override
    public void setNames(String stepName, String portName) {
    }

    @Override
    public boolean moreDocuments() {
        if (!this.readDoc) {
            this.readDoc();
        }
        return this.pos < this.documents.size();
    }

    @Override
    public boolean closed() {
        return true;
    }

    @Override
    public int documentCount() {
        return this.documents.size();
    }

    @Override
    public DocumentSequence documents() {
        return this.documents;
    }

    @Override
    public XdmNode read() {
        if (!this.readDoc) {
            this.readDoc();
        }
        XdmNode doc = this.documents.get(this.pos++);
        if (this.reader != null) {
            this.logger.trace(MessageFormatter.nodeMessage(this.reader.getNode(), this.reader.getName() + " select read '" + (doc == null ? "null" : doc.getBaseURI()) + "' from " + this));
        }
        return doc;
    }

    protected void readDoc() {
        block9: {
            this.readDoc = true;
            if (this.uri != null) {
                try {
                    boolean sameDocumentReference = this.uri.startsWith("#");
                    URI baseURI = URI.create(this.base);
                    if (!sameDocumentReference && "file".equalsIgnoreCase(baseURI.resolve(this.uri).getScheme())) {
                        final DataStore store = this.runtime.getDataStore();
                        store.infoEntry(this.uri, this.base, "*/*", new DataStore.DataInfo(){

                            @Override
                            public void list(URI id, String media, long lastModified) throws IOException {
                                final String accept = ReadableDocument.this.pattern == null ? ReadableDocument.ACCEPT_XML : "*/*";
                                final DataStore.DataReader handler = new DataStore.DataReader(){

                                    @Override
                                    public void load(URI id, String media, InputStream content, long len) throws IOException {
                                        content.close();
                                        String name = new File(id).getName();
                                        if (ReadableDocument.this.pattern == null || ReadableDocument.this.pattern.matcher(name).matches()) {
                                            ReadableDocument.this.documents.add(ReadableDocument.this.parse(id.toASCIIString(), ReadableDocument.this.base));
                                        }
                                    }
                                };
                                String entry = id.toASCIIString();
                                if (media == null) {
                                    store.listEachEntry(entry, entry, accept, new DataStore.DataInfo(){

                                        @Override
                                        public void list(URI id, String media, long lastModified) throws IOException {
                                            String entry = id.toASCIIString();
                                            store.readEntry(entry, entry, accept, null, handler);
                                        }
                                    });
                                } else {
                                    store.readEntry(entry, entry, accept, null, handler);
                                }
                            }
                        });
                        break block9;
                    }
                    try {
                        this.documents.add(this.parse(this.uri, this.base));
                    }
                    catch (XProcException xe) {
                        if (this.runtime.transparentJSON()) {
                            try {
                                DataStore store = this.runtime.getDataStore();
                                store.readEntry(this.uri, this.base, ACCEPT_JSON, null, new DataStore.DataReader(){

                                    @Override
                                    public void load(URI id, String media, InputStream content, long len) throws IOException {
                                        String cs = HttpUtils.getCharset(media);
                                        if (cs == null) {
                                            cs = Charset.defaultCharset().name();
                                        }
                                        InputStreamReader reader = new InputStreamReader(content, cs);
                                        JSONTokener jt = new JSONTokener(reader);
                                        Processor processor = ReadableDocument.this.runtime.getProcessor();
                                        String flavor = ReadableDocument.this.runtime.jsonFlavor();
                                        ReadableDocument.this.documents.add(JSONtoXML.convert(processor, jt, flavor));
                                    }
                                });
                                return;
                            }
                            catch (Exception e) {
                                throw xe;
                            }
                        }
                        throw xe;
                    }
                }
                catch (Exception except) {
                    throw XProcException.dynamicError(11, this.node, except, "Could not read: " + this.uri);
                }
            }
        }
    }

    private XdmNode parse(String uri, String base) {
        XdmNode doc = this.runtime.parse(uri, base);
        if (uri.contains("#")) {
            XPointer xptr;
            Vector<XdmNode> nodes;
            int pos = uri.indexOf("#");
            String ptr = uri.substring(pos + 1);
            if (ptr.matches("^[\\w]+$")) {
                ptr = "element(" + ptr + ")";
            }
            if ((nodes = (xptr = new XPointer(this.runtime, ptr, 1024000)).selectNodes(this.runtime, doc)).size() == 1) {
                doc = nodes.get(0);
            } else if (nodes.size() != 0) {
                throw new XProcException(this.node, "XPointer matches more than one node!?");
            }
        }
        return doc;
    }
}

