/*
 * Decompiled with CFR 0.152.
 */
package com.xmlcalabash.io;

import com.xmlcalabash.core.XProcConstants;
import com.xmlcalabash.core.XProcException;
import com.xmlcalabash.core.XProcRuntime;
import com.xmlcalabash.io.DataStore;
import com.xmlcalabash.io.DocumentSequence;
import com.xmlcalabash.io.ReadablePipe;
import com.xmlcalabash.model.Step;
import com.xmlcalabash.util.Base64;
import com.xmlcalabash.util.HttpUtils;
import com.xmlcalabash.util.JSONtoXML;
import com.xmlcalabash.util.MessageFormatter;
import com.xmlcalabash.util.TreeWriter;
import com.xmlcalabash.util.TypeUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URISyntaxException;
import net.sf.saxon.om.AttributeMap;
import net.sf.saxon.om.EmptyAttributeMap;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.XdmNode;
import org.json.JSONTokener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReadableData
implements ReadablePipe {
    public static final QName _contentType = new QName("", "content-type");
    public static final QName c_contentType = XProcConstants.qNameFor(XProcConstants.NS_XPROC_STEP, "content-type");
    public static final QName _encoding = new QName("", "encoding");
    public static final QName c_encoding = XProcConstants.qNameFor(XProcConstants.NS_XPROC_STEP, "encoding");
    private String contentType = null;
    private final Logger logger = LoggerFactory.getLogger(ReadablePipe.class);
    private int pos = 0;
    private QName wrapper = null;
    private String uri = null;
    private InputStream inputStream = null;
    private String serverContentType = "content/unknown";
    private XProcRuntime runtime = null;
    private DocumentSequence documents = null;
    private Step reader = null;

    public ReadableData(XProcRuntime runtime, QName wrapper, String uri, String contentType) {
        this(runtime, wrapper, uri, null, contentType);
    }

    public ReadableData(XProcRuntime runtime, QName wrapper, InputStream inputStream, String contentType) {
        this(runtime, wrapper, null, inputStream, contentType);
    }

    private ReadableData(XProcRuntime runtime, QName wrapper, String uri, InputStream inputStream, String contentType) {
        this.runtime = runtime;
        this.uri = uri;
        this.inputStream = inputStream;
        this.wrapper = wrapper;
        this.contentType = contentType;
    }

    private DocumentSequence ensureDocuments() {
        block11: {
            if (this.documents != null) {
                return this.documents;
            }
            this.documents = new DocumentSequence(this.runtime);
            if (this.uri == null && this.inputStream == null) {
                return this.documents;
            }
            try {
                final String userContentType = this.parseContentType(this.contentType);
                if (this.uri == null) {
                    try {
                        this.read(userContentType, null, this.inputStream, this.getContentType());
                        break block11;
                    }
                    finally {
                        this.inputStream.close();
                    }
                }
                if ("-".equals(this.uri)) {
                    this.read(userContentType, this.getDataUri("-"), System.in, this.getContentType());
                } else {
                    String accept = "application/json, text/json, text/*, */*";
                    if (userContentType != null) {
                        accept = userContentType + ", */*";
                    }
                    DataStore store = this.runtime.getDataStore();
                    store.readEntry(this.uri, this.uri, accept, null, new DataStore.DataReader(){

                        @Override
                        public void load(URI dataURI, String serverContentType, InputStream stream, long len) throws IOException {
                            ReadableData.this.read(userContentType, dataURI, stream, serverContentType);
                        }
                    });
                }
            }
            catch (IOException ioe) {
                throw new XProcException(XProcConstants.dynamicError(29), (Throwable)ioe);
            }
        }
        return this.documents;
    }

    private void read(String userContentType, URI dataURI, InputStream stream, String serverContentType) throws IOException {
        this.serverContentType = serverContentType;
        this.contentType = serverContentType;
        if (this.uri != null && ("-".equals(this.uri) || "file".equals(dataURI.getScheme())) && userContentType != null) {
            this.contentType = userContentType;
        }
        String charset = this.parseCharset(this.contentType);
        TreeWriter tree = new TreeWriter(this.runtime);
        tree.startDocument(dataURI);
        if (this.contentType != null && "content/unknown".equals(serverContentType)) {
            serverContentType = this.contentType;
        }
        String serverBaseContentType = this.parseContentType(serverContentType);
        String serverCharset = this.parseCharset(serverContentType);
        if (serverCharset != null) {
            serverContentType = serverBaseContentType + "; charset=\"" + serverCharset + "\"";
        }
        if (this.runtime.transparentJSON() && HttpUtils.jsonContentType(this.contentType)) {
            if (charset == null) {
                charset = "UTF-8";
            }
            InputStreamReader reader = new InputStreamReader(stream, charset);
            JSONTokener jt = new JSONTokener(reader);
            XdmNode jsonDoc = JSONtoXML.convert(this.runtime.getProcessor(), jt, this.runtime.jsonFlavor());
            tree.addSubtree(jsonDoc);
        } else {
            EmptyAttributeMap attr = EmptyAttributeMap.getInstance();
            if (XProcConstants.c_data.equals((Object)this.wrapper)) {
                attr = "content/unknown".equals(this.contentType) ? attr.put(TypeUtils.attributeInfo(_contentType, "application/octet-stream")) : attr.put(TypeUtils.attributeInfo(_contentType, this.contentType));
                if (!this.isText(this.contentType, charset)) {
                    attr = attr.put(TypeUtils.attributeInfo(_encoding, "base64"));
                }
            } else {
                attr = "content/unknown".equals(this.contentType) ? attr.put(TypeUtils.attributeInfo(c_contentType, "application/octet-stream")) : attr.put(TypeUtils.attributeInfo(c_contentType, this.contentType));
                if (!this.isText(this.contentType, charset)) {
                    attr = attr.put(TypeUtils.attributeInfo(c_encoding, "base64"));
                }
            }
            tree.addStartElement(this.wrapper, (AttributeMap)attr);
            if (this.isText(this.contentType, charset)) {
                if (charset == null) {
                    charset = "UTF-8";
                }
                BufferedReader bufreader = new BufferedReader(new InputStreamReader(stream, charset));
                int maxlen = 12288;
                char[] chars = new char[maxlen];
                int read = bufreader.read(chars, 0, maxlen);
                while (read >= 0) {
                    if (read > 0) {
                        String data = new String(chars, 0, read);
                        tree.addText(data);
                    }
                    read = bufreader.read(chars, 0, maxlen);
                }
                bufreader.close();
            } else {
                int maxlen = 12288;
                byte[] bytes = new byte[maxlen];
                int pos = 0;
                int readlen = maxlen;
                boolean done = false;
                while (!done) {
                    int read = stream.read(bytes, pos, readlen);
                    if (read >= 0) {
                        pos += read;
                        readlen -= read;
                    } else {
                        done = true;
                    }
                    if (readlen != 0 && !done) continue;
                    String base64 = Base64.encodeBytes(bytes, 0, pos);
                    tree.addText(base64 + "\n");
                    pos = 0;
                    readlen = maxlen;
                }
                stream.close();
            }
            tree.addEndElement();
        }
        tree.endDocument();
        this.documents.add(tree.getResult());
    }

    @Override
    public void canReadSequence(boolean sequence) {
    }

    @Override
    public boolean readSequence() {
        return false;
    }

    @Override
    public void resetReader() {
        this.pos = 0;
    }

    @Override
    public void setReader(Step step) {
        this.reader = step;
    }

    @Override
    public void setNames(String stepName, String portName) {
    }

    @Override
    public boolean moreDocuments() {
        DocumentSequence docs = this.ensureDocuments();
        return this.pos < docs.size();
    }

    @Override
    public boolean closed() {
        return true;
    }

    @Override
    public int documentCount() {
        DocumentSequence docs = this.ensureDocuments();
        return docs.size();
    }

    @Override
    public DocumentSequence documents() {
        return this.ensureDocuments();
    }

    @Override
    public XdmNode read() {
        DocumentSequence docs = this.ensureDocuments();
        XdmNode doc = docs.get(this.pos++);
        if (this.reader != null) {
            this.logger.trace(MessageFormatter.nodeMessage(this.reader.getNode(), this.reader.getName() + " read '" + (doc == null ? "null" : doc.getBaseURI()) + "' from " + this));
        }
        return doc;
    }

    protected URI getDataUri(String uri) {
        try {
            return new URI(uri);
        }
        catch (URISyntaxException use) {
            throw new XProcException(use);
        }
    }

    protected String getContentType() {
        return this.serverContentType;
    }

    private boolean isText(String contentType, String charset) {
        return "application/xml".equals(contentType) || contentType.endsWith("+xml") || contentType.startsWith("text/") || "utf-8".equals(charset);
    }

    private String parseContentType(String contentType) {
        if (contentType == null) {
            return null;
        }
        int pos = contentType.indexOf(";");
        if (pos > 0) {
            return contentType.substring(0, pos).trim();
        }
        return contentType;
    }

    private String parseCharset(String contentType) {
        String charset = HttpUtils.getCharset(contentType);
        if (charset != null) {
            return charset.toLowerCase();
        }
        return null;
    }
}

