/*
 * Decompiled with CFR 0.152.
 */
package com.xmlcalabash.io;

import com.xmlcalabash.core.XProcConfiguration;
import com.xmlcalabash.core.XProcConstants;
import com.xmlcalabash.core.XProcRuntime;
import com.xmlcalabash.model.Log;
import com.xmlcalabash.util.LogOptions;
import com.xmlcalabash.util.S9apiUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.GregorianCalendar;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.Serializer;
import net.sf.saxon.s9api.XdmNode;

public class PipeLogger {
    private static final QName cx_basename = XProcConstants.qNameFor("cx", XProcConstants.NS_CALABASH_EX, "basename");
    private static final QName cx_logstyle = XProcConstants.qNameFor("cx", XProcConstants.NS_CALABASH_EX, "logstyle");
    private Log log = null;
    private Serializer serializer = null;
    private PrintStream stream = null;
    private XProcRuntime runtime = null;
    private boolean logging = false;
    private XProcConfiguration config = null;
    private LogOptions logstyle = null;
    private String basename = null;
    private File baseDir = null;
    private int outputCount = 1;

    public PipeLogger(XProcRuntime xproc, Log log) {
        this.runtime = xproc;
        this.log = log;
        this.config = xproc.getConfiguration();
        this.basename = this.runtime.getEpisode();
        this.logstyle = this.config.logOpt;
        String ext = log.getExtensionAttribute(cx_basename);
        if (ext != null) {
            this.basename = ext;
        }
        ext = log.getExtensionAttribute(cx_logstyle);
        if (this.logstyle != LogOptions.OFF && ext != null) {
            if (ext.equals("off")) {
                this.logstyle = LogOptions.OFF;
            } else if (ext.equals("plain")) {
                this.logstyle = LogOptions.PLAIN;
            } else if (ext.equals("wrapped")) {
                this.logstyle = LogOptions.WRAPPED;
            } else if (ext.equals("directory")) {
                this.logstyle = LogOptions.DIRECTORY;
            } else {
                System.err.println("Invalid cx:logstyle ignored: " + ext);
            }
        }
        if (this.logstyle == LogOptions.OFF) {
            return;
        }
        this.serializer = this.runtime.getProcessor().newSerializer();
        this.serializer.setOutputProperty(Serializer.Property.METHOD, "xml");
        this.serializer.setOutputProperty(Serializer.Property.ENCODING, "utf-8");
        this.serializer.setOutputProperty(Serializer.Property.OMIT_XML_DECLARATION, "yes");
    }

    private String dateTime() {
        GregorianCalendar cal = new GregorianCalendar();
        String rfc822tz = String.format("%1$tz", cal);
        return String.format("%1$tFT%1$tT", cal) + rfc822tz.substring(0, 3) + ":" + rfc822tz.substring(3);
    }

    public void startLogging() {
        String dt = this.dateTime();
        switch (this.logstyle) {
            case PLAIN: 
            case WRAPPED: {
                if (this.log.getHref() == null) {
                    this.stream = System.out;
                    break;
                }
                try {
                    String href = this.log.getHref().toASCIIString();
                    if (href.startsWith("file:///")) {
                        href = href.substring(7);
                    } else if (href.startsWith("file:/")) {
                        href = href.substring(5);
                    }
                    this.stream = new PrintStream(new File(href));
                }
                catch (FileNotFoundException fnfe) {
                    System.err.println("Failed to create log: " + this.log.getHref());
                    this.stream = System.err;
                }
                break;
            }
            case DIRECTORY: {
                String dirstr = null;
                if (this.log.getHref() != null) {
                    if (this.log.getHref().getScheme() != null && !this.log.getHref().getScheme().equals("file")) {
                        System.err.println("Only file: scheme URIs are supported for directory logging.");
                        this.logstyle = LogOptions.WRAPPED;
                        this.stream = System.err;
                        break;
                    }
                } else {
                    System.err.println("Directory logging requires a directory.");
                    this.logstyle = LogOptions.WRAPPED;
                    this.stream = System.out;
                    break;
                }
                dirstr = this.log.getHref().getPath();
                this.baseDir = new File(dirstr);
                if (this.baseDir.isDirectory()) break;
                if (this.baseDir.exists()) {
                    System.err.println("Log location is not a directory: " + this.log.getHref());
                    this.logstyle = LogOptions.WRAPPED;
                    this.stream = System.err;
                    break;
                }
                try {
                    this.baseDir.mkdirs();
                }
                catch (Exception e) {
                    System.err.println("Could not create log directory: " + this.log.getHref());
                    this.logstyle = LogOptions.WRAPPED;
                    this.stream = System.err;
                }
                break;
            }
        }
        this.serializer.setOutputStream((OutputStream)this.stream);
        if (this.logstyle == LogOptions.OFF) {
            return;
        }
        if (this.logstyle != LogOptions.DIRECTORY) {
            if (this.logstyle == LogOptions.WRAPPED) {
                this.stream.println("<px:document-sequence xmlns:px='http://xmlcalabash.com/ns/document-sequence'");
                this.stream.println("                      port='" + this.log.getPort() + "'");
                this.stream.println("                      xpl-file='" + this.log.xplFile() + "'");
                this.stream.println("                      xpl-line='" + this.log.xplLine() + "'");
                this.stream.println("                      dateTime='" + dt + "'>");
            } else {
                this.stream.println("<!-- Start of Calabash output " + this.log + " on " + dt + " -->");
            }
        }
        this.logging = true;
    }

    public void stopLogging() {
        if (this.logging) {
            if (this.logstyle == LogOptions.WRAPPED) {
                this.stream.print("</px:document-sequence>");
            }
            if (this.logstyle == LogOptions.PLAIN) {
                this.stream.print("\n");
                this.stream.println("<!-- End of Calabash output log -->");
            }
        }
        this.logging = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void log(XdmNode node) {
        if (this.logstyle == LogOptions.OFF) {
            return;
        }
        if (!this.logging) {
            this.startLogging();
        }
        switch (this.logstyle) {
            case WRAPPED: {
                this.stream.print("<px:document>");
                try {
                    S9apiUtils.serialize(this.runtime, node, this.serializer);
                }
                catch (SaxonApiException sae) {
                    System.err.println("Logging failed: " + (Object)((Object)sae));
                }
                this.stream.println("</px:document>");
                break;
            }
            case PLAIN: {
                try {
                    S9apiUtils.serialize(this.runtime, node, this.serializer);
                }
                catch (SaxonApiException sae) {
                    System.err.println("Logging failed: " + (Object)((Object)sae));
                }
                break;
            }
            case DIRECTORY: {
                String filename = String.format("%1$s-%2$04d.xml", this.basename, this.outputCount++);
                File output = new File(this.baseDir, filename);
                try {
                    this.stream = new PrintStream(output);
                }
                catch (FileNotFoundException fnfe) {
                    System.err.println("Failed to create log: " + this.log.getHref());
                    this.stream = System.err;
                }
                try {
                    this.serializer.setOutputStream((OutputStream)this.stream);
                    this.stream.println("<!-- Start of Calabash output " + this.log + " on " + this.dateTime() + " -->");
                    S9apiUtils.serialize(this.runtime, node, this.serializer);
                    break;
                }
                catch (SaxonApiException sae) {
                    System.err.println("Logging failed: " + (Object)((Object)sae));
                    break;
                }
                finally {
                    if (!System.err.equals(this.stream)) {
                        this.stream.close();
                    }
                }
            }
        }
    }
}

