/*
 * Decompiled with CFR 0.152.
 */
package com.xmlcalabash.io;

import com.xmlcalabash.core.XProcException;
import com.xmlcalabash.io.DataStore;
import com.xmlcalabash.util.URIUtils;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileDataStore
implements DataStore {
    private Logger logger = LoggerFactory.getLogger(FileDataStore.class);
    private final DataStore fallback;
    private final Properties contentTypes;
    private HashMap<String, String> cachedMapping = null;

    public FileDataStore(DataStore fallback) {
        this.fallback = fallback;
        this.contentTypes = new Properties();
        this.loadDefaultContentTypes(this.contentTypes);
        this.loadContentTypes(this.contentTypes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public URI writeEntry(String href, String base, String media, DataStore.DataWriter handler) throws MalformedURLException, FileNotFoundException, IOException {
        URI baseURI = URI.create(base);
        URI uri = baseURI.resolve(href);
        if ("file".equalsIgnoreCase(uri.getScheme())) {
            File file = URIUtils.toFile(uri);
            String suffix = this.getFileSuffixFromType(media);
            if (file.isDirectory() || uri.getPath().endsWith("/")) {
                if (!file.isDirectory() && !file.mkdirs()) {
                    throw new FileNotFoundException(file.getAbsolutePath());
                }
                File temp = File.createTempFile("calabash", suffix, file);
                try (FileOutputStream out = new FileOutputStream(temp);){
                    handler.store(out);
                }
                return temp.toURI();
            }
            File dir = file.getParentFile();
            if (!dir.isDirectory() && !dir.mkdirs()) {
                throw new FileNotFoundException(dir.getAbsolutePath());
            }
            File temp = File.createTempFile("calabash-temp", suffix, dir);
            try {
                try (FileOutputStream out = new FileOutputStream(temp);){
                    handler.store(out);
                }
                file.delete();
                temp.renameTo(file);
                URI uRI = file.toURI();
                return uRI;
            }
            finally {
                if (temp.exists()) {
                    temp.delete();
                }
            }
        }
        return this.fallback.writeEntry(href, base, media, handler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void readEntry(String href, String base, String accept, String overrideContentType, DataStore.DataReader handler) throws MalformedURLException, FileNotFoundException, IOException {
        URI baseURI = URI.create(base);
        URI uri = baseURI.resolve(href);
        if ("file".equalsIgnoreCase(uri.getScheme())) {
            File file = URIUtils.toFile(uri);
            String type = this.getContentTypeFromName(file.getName());
            if (overrideContentType != null) {
                type = overrideContentType;
            }
            try (FileInputStream in = new FileInputStream(file);){
                handler.load(file.toURI(), type, in, file.length());
            }
        } else {
            this.fallback.readEntry(href, base, accept, overrideContentType, handler);
        }
    }

    @Override
    public void infoEntry(String href, String base, String accept, DataStore.DataInfo handler) throws MalformedURLException, FileNotFoundException, IOException {
        URI baseURI = URI.create(base);
        URI uri = baseURI.resolve(href);
        if ("file".equalsIgnoreCase(uri.getScheme())) {
            String type;
            File file = URIUtils.toFile(uri);
            if (file.isFile()) {
                type = this.getContentTypeFromName(file.getName());
            } else if (file.exists()) {
                type = null;
            } else {
                throw new FileNotFoundException(file.getAbsolutePath());
            }
            handler.list(file.toURI(), type, file.lastModified());
        } else {
            this.fallback.infoEntry(href, base, accept, handler);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void listEachEntry(String href, String base, String accept, DataStore.DataInfo handler) throws MalformedURLException, FileNotFoundException, IOException {
        URI baseURI = URI.create(base);
        URI uri = baseURI.resolve(href);
        if ("file".equalsIgnoreCase(uri.getScheme())) {
            File file = URIUtils.toFile(uri);
            if (!file.canRead()) {
                throw XProcException.stepError(12);
            }
            if (!file.isDirectory()) throw new FileNotFoundException(file.getAbsolutePath() + " is not a directory");
            for (File f : this.listAcceptableFiles(file, accept)) {
                String type = f.isDirectory() ? null : this.getContentTypeFromName(f.getName());
                handler.list(f.toURI(), type, f.lastModified());
            }
            return;
        } else {
            this.fallback.listEachEntry(href, base, accept, handler);
        }
    }

    @Override
    public URI createList(String href, String base) throws MalformedURLException, FileNotFoundException, IOException {
        URI baseURI = URI.create(base);
        URI uri = baseURI.resolve(href);
        if ("file".equalsIgnoreCase(uri.getScheme())) {
            File file = URIUtils.toFile(uri);
            if (file.isDirectory()) {
                return file.toURI();
            }
            if (file.exists()) {
                throw new FileNotFoundException(file.toURI().toASCIIString());
            }
            if (file.mkdirs()) {
                return file.toURI();
            }
            throw new IOException("Could not create directory: " + file.getAbsolutePath());
        }
        return this.fallback.createList(href, base);
    }

    @Override
    public void deleteEntry(String href, String base) throws MalformedURLException, FileNotFoundException, IOException {
        URI baseURI = URI.create(base);
        URI uri = baseURI.resolve(href);
        if ("file".equalsIgnoreCase(uri.getScheme())) {
            File file = URIUtils.toFile(uri);
            if (!file.exists()) {
                throw new FileNotFoundException(file.toURI().toASCIIString());
            }
            if (!file.delete()) {
                throw new IOException("Could not delete " + file.toURI().toASCIIString());
            }
        } else {
            this.fallback.deleteEntry(href, base);
        }
    }

    protected File[] listAcceptableFiles(File dir, final String accept) {
        if (accept.contains("*/*")) {
            File[] list = dir.listFiles();
            if (list == null) {
                return new File[0];
            }
            return list;
        }
        File[] list = dir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                if (!file.isFile()) {
                    return false;
                }
                String type = FileDataStore.this.getContentTypeFromName(file.getName());
                String primary = type.substring(0, type.indexOf(47));
                return accept.contains(type) || accept.contains(primary + "/*");
            }
        });
        if (list == null) {
            return new File[0];
        }
        return list;
    }

    protected String getContentTypeFromName(String name) {
        String ext = this.getFileExtension(name);
        if (ext == null) {
            return "application/octet-stream";
        }
        if (this.cachedMapping == null) {
            this.cachedMapping = new HashMap();
            Enumeration<?> types = this.contentTypes.propertyNames();
            while (types.hasMoreElements()) {
                String[] tokens;
                String type = (String)types.nextElement();
                String attrs = this.contentTypes.getProperty(type);
                for (String tok : tokens = attrs.split(";")) {
                    String[] exts;
                    if (!tok.startsWith("file_extensions=")) continue;
                    String extList = tok.substring(16);
                    for (String e : exts = extList.split(",")) {
                        this.cachedMapping.put(e, type);
                    }
                }
            }
        }
        if (this.cachedMapping.containsKey(ext)) {
            return this.cachedMapping.get(ext);
        }
        return "application/octet-stream";
    }

    protected String getFileSuffixFromType(String media) {
        String attr;
        int i = media.indexOf(59);
        if (i > 0) {
            media = media.substring(0, i);
        }
        if ((i = media.indexOf(44)) > 0) {
            media = media.substring(0, i);
        }
        if ((attr = (String)this.contentTypes.get(media.trim())) != null && attr.indexOf("file_extensions") >= 0) {
            int start = attr.indexOf(61, attr.indexOf("file_extensions")) + 1;
            int end = attr.indexOf(44, start);
            if (end < 0) {
                end = attr.indexOf(59, start);
            }
            if (end < 0) {
                end = attr.length();
            }
            return attr.substring(start, end).trim();
        }
        int plus = media.lastIndexOf(43);
        if (plus > 0) {
            String primary = media.substring(0, media.indexOf(47) + 1);
            String subtype = media.substring(plus + 1);
            return this.getFileSuffixFromType(primary + subtype);
        }
        if (!media.startsWith("application/")) {
            String subtype = media.substring(media.indexOf(47) + 1);
            return this.getFileSuffixFromType("application/" + subtype);
        }
        return "";
    }

    private String getFileExtension(String fname) {
        int start;
        int end = fname.indexOf(35);
        if (end < 0) {
            end = fname.length();
        }
        if ((start = fname.lastIndexOf(46, end)) >= 0 && fname.charAt(start) == '.') {
            return fname.substring(start, end).toLowerCase();
        }
        return null;
    }

    private void loadDefaultContentTypes(Properties contentTypes) {
        contentTypes.put("application/json", "file_extensions=.json");
        contentTypes.put("application/javascript", "file_extensions=.js");
        contentTypes.put("text/css", "file_extensions=.css");
        contentTypes.put("application/xml", "file_extensions=.xml");
        contentTypes.put("application/zip", "file_extensions=.zip");
        contentTypes.put("text/plain", "file_extensions=.txt");
    }

    private void loadContentTypes(Properties contentTypes) {
        block7: {
            File file = null;
            try {
                String userTablePath = System.getProperty("content.types.user.table");
                if (userTablePath == null) break block7;
                file = new File(userTablePath);
                try (BufferedInputStream is = new BufferedInputStream(new FileInputStream(file));){
                    contentTypes.load(is);
                }
            }
            catch (IOException e) {
                this.logger.warn("Failed to load content types: " + file.getAbsolutePath());
                this.logger.debug(e.getMessage(), (Throwable)e);
            }
        }
    }
}

