/*
 * Decompiled with CFR 0.152.
 */
package com.xmlcalabash.functions;

import com.xmlcalabash.core.XProcConstants;
import com.xmlcalabash.core.XProcException;
import com.xmlcalabash.core.XProcRuntime;
import com.xmlcalabash.functions.XProcExtensionFunctionDefinition;
import com.xmlcalabash.runtime.XCompoundStep;
import com.xmlcalabash.runtime.XStep;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.lib.ExtensionFunctionCall;
import net.sf.saxon.om.NamespaceResolver;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.StringValue;

public class SystemProperty
extends XProcExtensionFunctionDefinition {
    private static StructuredQName funcname = new StructuredQName("p", XProcConstants.NS_XPROC, "system-property");

    protected SystemProperty() {
    }

    public SystemProperty(XProcRuntime runtime) {
        this.registry.registerRuntime((Object)this, runtime);
    }

    public StructuredQName getFunctionQName() {
        return funcname;
    }

    public int getMinimumNumberOfArguments() {
        return 1;
    }

    public int getMaximumNumberOfArguments() {
        return 1;
    }

    public SequenceType[] getArgumentTypes() {
        return new SequenceType[]{SequenceType.SINGLE_STRING};
    }

    public SequenceType getResultType(SequenceType[] suppliedArgumentTypes) {
        return SequenceType.SINGLE_STRING;
    }

    public ExtensionFunctionCall makeCallExpression() {
        return new SystemPropertyCall(this);
    }

    private class SystemPropertyCall
    extends ExtensionFunctionCall {
        private StaticContext staticContext = null;
        private XProcExtensionFunctionDefinition xdef = null;

        public SystemPropertyCall(XProcExtensionFunctionDefinition def) {
            this.xdef = def;
        }

        public void supplyStaticContext(StaticContext context, int locationId, Expression[] arguments) throws XPathException {
            this.staticContext = context;
        }

        public AtomicValue call(XPathContext xPathContext, Sequence[] sequences) throws XPathException {
            QName propertyName = null;
            XProcRuntime runtime = SystemProperty.this.registry.getRuntime((Object)this.xdef);
            XStep step = runtime.getXProcData().getStep();
            if (step != null && !(step instanceof XCompoundStep)) {
                throw XProcException.dynamicError(23);
            }
            try {
                String lexicalQName = sequences[0].head().getStringValue();
                StructuredQName qpropertyName = StructuredQName.fromLexicalQName((String)lexicalQName, (boolean)false, (boolean)false, (NamespaceResolver)this.staticContext.getNamespaceResolver());
                propertyName = new QName(qpropertyName);
            }
            catch (XPathException e) {
                String local;
                String string = local = e.getErrorCodeQName() == null ? null : e.getErrorCodeQName().getLocalPart();
                if (local == null || "FOCA0002".equals(local) || "FONS0004".equals(local)) {
                    e.setErrorCode("XTDE1390");
                }
                throw e;
            }
            String value = runtime.getSystemProperty(propertyName);
            if (value == null) {
                value = "";
            }
            return new StringValue(value);
        }
    }
}

