/*
 * Decompiled with CFR 0.152.
 */
package com.xmlcalabash.extensions.fileutils;

import com.xmlcalabash.core.XMLCalabash;
import com.xmlcalabash.core.XProcConstants;
import com.xmlcalabash.core.XProcException;
import com.xmlcalabash.core.XProcRuntime;
import com.xmlcalabash.io.DataStore;
import com.xmlcalabash.io.WritablePipe;
import com.xmlcalabash.library.DefaultStep;
import com.xmlcalabash.model.RuntimeValue;
import com.xmlcalabash.runtime.XAtomicStep;
import com.xmlcalabash.util.TreeWriter;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.util.Vector;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;

@XMLCalabash(name="pxf:tail", type="{http://exproc.org/proposed/steps/file}tail {http://xmlcalabash.com/ns/extensions/fileutils}tail")
public class Tail
extends DefaultStep {
    private static final QName _href = new QName("href");
    private static final QName _count = new QName("count");
    private static final QName _fail_on_error = new QName("fail-on-error");
    private static final QName c_line = XProcConstants.qNameFor(XProcConstants.NS_XPROC_STEP, "line");
    private WritablePipe result = null;

    public Tail(XProcRuntime runtime, XAtomicStep step) {
        super(runtime, step);
    }

    @Override
    public void setOutput(String port, WritablePipe pipe) {
        this.result = pipe;
    }

    @Override
    public void reset() {
        this.result.resetWriter();
    }

    @Override
    public void run() throws SaxonApiException {
        super.run();
        if (this.runtime.getSafeMode()) {
            throw XProcException.dynamicError(21);
        }
        boolean failOnError = this.getOption(_fail_on_error, true);
        int count = this.getOption(_count, 10);
        final boolean tail = count >= 0;
        final int maxCount = count >= 0 ? count : -count;
        RuntimeValue href = this.getOption(_href);
        try {
            DataStore store = this.runtime.getDataStore();
            store.readEntry(href.getString(), href.getBaseURI().toASCIIString(), "text/*, */*", null, new DataStore.DataReader(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void load(URI id, String media, InputStream content, long len) throws IOException {
                    TreeWriter tree = new TreeWriter(Tail.this.runtime);
                    tree.startDocument(id);
                    tree.addStartElement(XProcConstants.c_result);
                    InputStreamReader rdr = new InputStreamReader(content);
                    Vector<String> lines = new Vector<String>();
                    try (BufferedReader brdr = new BufferedReader(rdr);){
                        int count = 0;
                        String line = brdr.readLine();
                        while (line != null) {
                            lines.add(line);
                            if (++count > maxCount) {
                                line = (String)lines.remove(0);
                                if (!tail) {
                                    tree.addStartElement(c_line);
                                    tree.addText(line);
                                    tree.addEndElement();
                                    tree.addText("\n");
                                }
                            }
                            line = brdr.readLine();
                        }
                    }
                    if (tail) {
                        for (String lline : lines) {
                            tree.addStartElement(c_line);
                            tree.addText(lline);
                            tree.addEndElement();
                            tree.addText("\n");
                        }
                    }
                    tree.addEndElement();
                    tree.endDocument();
                    Tail.this.result.write(tree.getResult());
                }
            });
        }
        catch (FileNotFoundException fnfe) {
            URI uri = href.getBaseURI().resolve(href.getString());
            throw new XProcException(href.getNode(), "Cannot read: file does not exist: " + uri.toASCIIString());
        }
        catch (IOException ioe) {
            throw new XProcException(ioe);
        }
    }
}

