/*
 * Decompiled with CFR 0.152.
 */
package com.xmlcalabash.extensions.fileutils;

import com.xmlcalabash.core.XMLCalabash;
import com.xmlcalabash.core.XProcConstants;
import com.xmlcalabash.core.XProcException;
import com.xmlcalabash.core.XProcRuntime;
import com.xmlcalabash.io.DataStore;
import com.xmlcalabash.io.WritablePipe;
import com.xmlcalabash.library.DefaultStep;
import com.xmlcalabash.model.RuntimeValue;
import com.xmlcalabash.runtime.XAtomicStep;
import com.xmlcalabash.util.TreeWriter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;

@XMLCalabash(name="pxf:move", type="{http://exproc.org/proposed/steps/file}move {http://xmlcalabash.com/ns/extensions/fileutils}move")
public class Move
extends DefaultStep {
    private static final QName _href = new QName("href");
    private static final QName _target = new QName("target");
    private static final int bufsize = 8192;
    private WritablePipe result = null;

    public Move(XProcRuntime runtime, XAtomicStep step) {
        super(runtime, step);
    }

    @Override
    public void setOutput(String port, WritablePipe pipe) {
        this.result = pipe;
    }

    @Override
    public void reset() {
        this.result.resetWriter();
    }

    @Override
    public void run() throws SaxonApiException {
        super.run();
        if (this.runtime.getSafeMode()) {
            throw XProcException.dynamicError(21);
        }
        RuntimeValue href = this.getOption(_href);
        try {
            final DataStore store = this.runtime.getDataStore();
            String base = href.getBaseURI().toASCIIString();
            store.readEntry(href.getString(), base, "*/*", null, new DataStore.DataReader(){

                @Override
                public void load(URI id, String media, final InputStream src, long len) throws IOException {
                    RuntimeValue target = Move.this.getOption(_target);
                    URI uri = store.writeEntry(target.getString(), target.getBaseURI().toASCIIString(), media, new DataStore.DataWriter(){

                        @Override
                        public void store(OutputStream dst) throws IOException {
                            byte[] buffer = new byte[8192];
                            int read = src.read(buffer, 0, 8192);
                            while (read >= 0) {
                                dst.write(buffer, 0, read);
                                read = src.read(buffer, 0, 8192);
                            }
                        }
                    });
                    TreeWriter tree = new TreeWriter(Move.this.runtime);
                    tree.startDocument(Move.this.step.getNode().getBaseURI());
                    tree.addStartElement(XProcConstants.c_result);
                    tree.addText(uri.toASCIIString());
                    tree.addEndElement();
                    tree.endDocument();
                    Move.this.result.write(tree.getResult());
                }
            });
            store.deleteEntry(href.getString(), base);
        }
        catch (FileNotFoundException fnfe) {
            URI uri = href.getBaseURI().resolve(href.getString());
            throw new XProcException(this.step.getNode(), "Cannot copy: file does not exist: " + uri.toASCIIString());
        }
        catch (IOException ioe) {
            throw new XProcException(this.step.getNode(), (Throwable)ioe);
        }
    }
}

