/*
 * Decompiled with CFR 0.152.
 */
package com.xmlcalabash.extensions.fileutils;

import com.xmlcalabash.core.XMLCalabash;
import com.xmlcalabash.core.XProcConstants;
import com.xmlcalabash.core.XProcException;
import com.xmlcalabash.core.XProcRuntime;
import com.xmlcalabash.io.DataStore;
import com.xmlcalabash.io.WritablePipe;
import com.xmlcalabash.library.DefaultStep;
import com.xmlcalabash.model.RuntimeValue;
import com.xmlcalabash.runtime.XAtomicStep;
import com.xmlcalabash.util.TreeWriter;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;

@XMLCalabash(name="pxf:head", type="{http://exproc.org/proposed/steps/file}head {http://xmlcalabash.com/ns/extensions/fileutils}head")
public class Head
extends DefaultStep {
    private static final QName _href = new QName("href");
    private static final QName _count = new QName("count");
    private static final QName _fail_on_error = new QName("fail-on-error");
    private static final QName c_line = XProcConstants.qNameFor(XProcConstants.NS_XPROC_STEP, "line");
    private WritablePipe result = null;

    public Head(XProcRuntime runtime, XAtomicStep step) {
        super(runtime, step);
    }

    @Override
    public void setOutput(String port, WritablePipe pipe) {
        this.result = pipe;
    }

    @Override
    public void reset() {
        this.result.resetWriter();
    }

    @Override
    public void run() throws SaxonApiException {
        super.run();
        if (this.runtime.getSafeMode()) {
            throw XProcException.dynamicError(21);
        }
        boolean failOnError = this.getOption(_fail_on_error, true);
        final int maxCount = this.getOption(_count, 10);
        final int negMaxCount = -maxCount;
        RuntimeValue href = this.getOption(_href);
        final TreeWriter tree = new TreeWriter(this.runtime);
        tree.startDocument(this.step.getNode().getBaseURI());
        tree.addStartElement(XProcConstants.c_result);
        try {
            DataStore store = this.runtime.getDataStore();
            store.readEntry(href.getString(), href.getBaseURI().toASCIIString(), "text/*, */*", null, new DataStore.DataReader(){

                @Override
                public void load(URI id, String media, InputStream content, long len) throws IOException {
                    InputStreamReader rdr = new InputStreamReader(content);
                    try (BufferedReader brdr = new BufferedReader(rdr);){
                        int count;
                        String line = null;
                        if (maxCount >= 0) {
                            line = brdr.readLine();
                            for (count = 0; line != null && count < maxCount; ++count) {
                                tree.addStartElement(c_line);
                                tree.addText(line);
                                tree.addEndElement();
                                tree.addText("\n");
                                line = brdr.readLine();
                            }
                        } else {
                            line = "not null";
                            while (line != null && count < negMaxCount) {
                                ++count;
                                line = brdr.readLine();
                            }
                            line = brdr.readLine();
                            while (line != null) {
                                tree.addStartElement(c_line);
                                tree.addText(line);
                                tree.addEndElement();
                                tree.addText("\n");
                                line = brdr.readLine();
                            }
                        }
                    }
                }
            });
        }
        catch (FileNotFoundException fnfe) {
            URI uri = href.getBaseURI().resolve(href.getString());
            throw new XProcException(this.step.getNode(), "Cannot read: file does not exist: " + uri.toASCIIString());
        }
        catch (IOException ioe) {
            throw new XProcException(ioe);
        }
        tree.addEndElement();
        tree.endDocument();
        this.result.write(tree.getResult());
    }
}

