/*
 * Decompiled with CFR 0.152.
 */
package com.xmlcalabash.extensions;

import com.xmlcalabash.core.XMLCalabash;
import com.xmlcalabash.core.XProcConstants;
import com.xmlcalabash.core.XProcRuntime;
import com.xmlcalabash.io.Pipe;
import com.xmlcalabash.io.WritablePipe;
import com.xmlcalabash.library.DefaultStep;
import com.xmlcalabash.library.HttpRequest;
import com.xmlcalabash.model.RuntimeValue;
import com.xmlcalabash.runtime.XAtomicStep;
import com.xmlcalabash.util.AxisNodes;
import com.xmlcalabash.util.MessageFormatter;
import com.xmlcalabash.util.S9apiUtils;
import com.xmlcalabash.util.TreeWriter;
import com.xmlcalabash.util.TypeUtils;
import java.io.File;
import java.net.URI;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import net.sf.saxon.om.AttributeMap;
import net.sf.saxon.om.EmptyAttributeMap;
import net.sf.saxon.s9api.Axis;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.XdmNode;

@XMLCalabash(name="cx:uri-info", type="{http://xmlcalabash.com/ns/extensions}uri-info")
public class UriInfo
extends DefaultStep {
    private static final QName _href = new QName("href");
    private static final QName _method = new QName("method");
    private static final QName _status_only = new QName("status-only");
    private static final QName _detailed = new QName("detailed");
    private static final QName _status = new QName("status");
    private static final QName _name = new QName("name");
    private static final QName _value = new QName("value");
    private static final QName _username = new QName("username");
    private static final QName _password = new QName("password");
    private static final QName _auth_method = new QName("auth_method");
    private static final QName _send_authorization = new QName("send_authorization");
    protected static final QName c_uriinfo = XProcConstants.qNameFor(XProcConstants.NS_XPROC_STEP, "uri-info");
    private static final QName _uri = new QName("uri");
    private static final QName _readable = new QName("readable");
    private static final QName _writable = new QName("writable");
    private static final QName _exists = new QName("exists");
    private static final QName _absolute = new QName("absolute");
    private static final QName _directory = new QName("directory");
    private static final QName _hidden = new QName("hidden");
    private static final QName _file = new QName("file");
    private static final QName _last_modified = new QName("last-modified");
    private static final QName _size = new QName("size");
    private static final QName _absolute_path = new QName("absolute-path");
    private static final QName _canonical_path = new QName("canonical-path");
    private WritablePipe result = null;

    public UriInfo(XProcRuntime runtime, XAtomicStep step) {
        super(runtime, step);
    }

    @Override
    public void setOutput(String port, WritablePipe pipe) {
        this.result = pipe;
    }

    @Override
    public void reset() {
        this.result.resetWriter();
    }

    @Override
    public void run() throws SaxonApiException {
        super.run();
        RuntimeValue href = this.getOption(_href);
        URI uri = href.getBaseURI().resolve(href.getString());
        this.logger.trace(MessageFormatter.nodeMessage(this.step.getNode(), "Checking uri-info for " + uri));
        TreeWriter tree = new TreeWriter(this.runtime);
        tree.startDocument(this.step.getNode().getBaseURI());
        if (uri.getScheme().equals("file")) {
            String fn = href.getString();
            if (fn.startsWith("file:") && (fn = fn.substring(5)).startsWith("///")) {
                fn = fn.substring(2);
            }
            File f = new File(fn);
            EmptyAttributeMap attr = EmptyAttributeMap.getInstance();
            attr = attr.put(TypeUtils.attributeInfo(_href, href.getString()));
            attr = attr.put(TypeUtils.attributeInfo(_exists, f.exists() ? "true" : "false"));
            attr = attr.put(TypeUtils.attributeInfo(_readable, f.canRead() ? "true" : "false"));
            if (f.exists()) {
                attr = attr.put(TypeUtils.attributeInfo(_writable, f.canWrite() ? "true" : "false"));
                attr = attr.put(TypeUtils.attributeInfo(_size, String.valueOf(f.length())));
                attr = attr.put(TypeUtils.attributeInfo(_absolute, f.isAbsolute() ? "true" : "false"));
                attr = attr.put(TypeUtils.attributeInfo(_directory, f.isDirectory() ? "true" : "false"));
                attr = attr.put(TypeUtils.attributeInfo(_hidden, f.isHidden() ? "true" : "false"));
                attr = attr.put(TypeUtils.attributeInfo(_file, f.isFile() ? "true" : "false"));
                GregorianCalendar cal = new GregorianCalendar();
                cal.setTimeInMillis(f.lastModified());
                TimeZone tz = TimeZone.getDefault();
                long gmt = f.lastModified() - (long)tz.getRawOffset();
                if (tz.useDaylightTime() && tz.inDaylightTime(cal.getTime())) {
                    gmt -= (long)tz.getDSTSavings();
                }
                cal.setTimeInMillis(gmt);
                attr = attr.put(TypeUtils.attributeInfo(_last_modified, String.format("%1$04d-%2$02d-%3$02dT%4$02d:%5$02d:%6$02dZ", cal.get(1), cal.get(2) + 1, cal.get(5), cal.get(11), cal.get(12), cal.get(13))));
            } else {
                String path = f.getAbsolutePath();
                int slash = path.lastIndexOf("/");
                File parent = new File(path = path.substring(0, slash));
                attr = attr.put(TypeUtils.attributeInfo(_writable, parent.canWrite() ? "true" : "false"));
            }
            attr = attr.put(TypeUtils.attributeInfo(_absolute_path, f.getAbsolutePath()));
            attr = attr.put(TypeUtils.attributeInfo(_uri, f.toURI().toASCIIString()));
            try {
                String cp = f.getCanonicalPath();
                attr = attr.put(TypeUtils.attributeInfo(_canonical_path, cp));
            }
            catch (Exception cp) {
                // empty catch block
            }
            tree.addStartElement(c_uriinfo, (AttributeMap)attr);
            tree.addEndElement();
        } else {
            HttpRequest httpReq = new HttpRequest(this.runtime, this.step);
            Pipe inputPipe = new Pipe(this.runtime);
            Pipe outputPipe = new Pipe(this.runtime);
            httpReq.setInput("source", inputPipe);
            httpReq.setOutput("result", outputPipe);
            TreeWriter req = new TreeWriter(this.runtime);
            req.startDocument(this.step.getNode().getBaseURI());
            EmptyAttributeMap attr = EmptyAttributeMap.getInstance();
            attr = attr.put(TypeUtils.attributeInfo(_method, "HEAD"));
            attr = attr.put(TypeUtils.attributeInfo(_href, uri.toASCIIString()));
            attr = attr.put(TypeUtils.attributeInfo(_status_only, "true"));
            attr = attr.put(TypeUtils.attributeInfo(_detailed, "true"));
            for (QName name : new QName[]{_username, _password, _auth_method, _send_authorization}) {
                RuntimeValue v = this.getOption(name);
                if (v == null) continue;
                attr = attr.put(TypeUtils.attributeInfo(name, v.getString()));
            }
            req.addStartElement(XProcConstants.c_request, (AttributeMap)attr);
            req.addEndElement();
            req.endDocument();
            inputPipe.write(req.getResult());
            httpReq.run();
            XdmNode result = S9apiUtils.getDocumentElement(outputPipe.read());
            assert (result != null);
            int status = Integer.parseInt(result.getAttributeValue(_status));
            attr = EmptyAttributeMap.getInstance();
            attr = attr.put(TypeUtils.attributeInfo(_href, href.getString()));
            attr = attr.put(TypeUtils.attributeInfo(_status, "" + status));
            attr = attr.put(TypeUtils.attributeInfo(_readable, status >= 200 && status < 400 ? "true" : "false"));
            attr = attr.put(TypeUtils.attributeInfo(_exists, status >= 400 && status < 500 ? "false" : "true"));
            attr = attr.put(TypeUtils.attributeInfo(_uri, uri.toASCIIString()));
            for (XdmNode node : new AxisNodes(result, Axis.CHILD, 7)) {
                if ("Last-Modified".equals(node.getAttributeValue(_name))) {
                    String[] months = new String[]{"JAN", "FEB", "MAR", "APR", "MAY", "JUN", "JUL", "AUG", "SEP", "OCT", "NOV", "DEC"};
                    String dateStr = node.getAttributeValue(_value);
                    String dayStr = dateStr.substring(5, 7);
                    String monthStr = dateStr.substring(8, 11).toUpperCase();
                    String yearStr = dateStr.substring(12, 16);
                    String timeStr = dateStr.substring(17, 25);
                    String tzStr = dateStr.substring(26, 29);
                    int month = 0;
                    for (month = 0; month < 12 && !months[month].equals(monthStr); ++month) {
                    }
                    attr = attr.put(TypeUtils.attributeInfo(_last_modified, String.format("%1$04d-%2$02d-%3$02dT%4$s%5$s", Integer.parseInt(yearStr), month + 1, Integer.parseInt(dayStr), timeStr, "GMT".equals(tzStr) ? "Z" : "")));
                }
                if (!"Content-Length".equals(node.getAttributeValue(_name))) continue;
                attr = attr.put(TypeUtils.attributeInfo(_size, node.getAttributeValue(_value)));
            }
            tree.addStartElement(c_uriinfo, (AttributeMap)attr);
            for (XdmNode node : new AxisNodes(result, Axis.CHILD, 7)) {
                tree.addSubtree(node);
            }
            tree.addEndElement();
        }
        tree.endDocument();
        this.result.write(tree.getResult());
    }
}

