/*
 * Decompiled with CFR 0.152.
 */
package com.xmlcalabash.extensions;

import com.xmlcalabash.core.XMLCalabash;
import com.xmlcalabash.core.XProcConstants;
import com.xmlcalabash.core.XProcException;
import com.xmlcalabash.core.XProcRuntime;
import com.xmlcalabash.io.ReadablePipe;
import com.xmlcalabash.io.WritablePipe;
import com.xmlcalabash.library.DefaultStep;
import com.xmlcalabash.model.RuntimeValue;
import com.xmlcalabash.runtime.XAtomicStep;
import com.xmlcalabash.util.Base64;
import com.xmlcalabash.util.HashUtils;
import com.xmlcalabash.util.JSONtoXML;
import com.xmlcalabash.util.S9apiUtils;
import com.xmlcalabash.util.TreeWriter;
import com.xmlcalabash.util.XMLtoJSON;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import net.sf.saxon.om.NamespaceUri;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.Serializer;
import net.sf.saxon.s9api.XdmNode;

@XMLCalabash(name="cx:hash-document", type="{http://xmlcalabash.com/ns/extensions}hash-document")
public class HashDocument
extends DefaultStep {
    private static final QName _content_type = new QName("content-type");
    private static final QName c_encoding = XProcConstants.qNameFor(XProcConstants.NS_XPROC_STEP, "encoding");
    private static final QName c_body = XProcConstants.qNameFor(XProcConstants.NS_XPROC_STEP, "body");
    private static final QName c_json = XProcConstants.qNameFor(XProcConstants.NS_XPROC_STEP, "json");
    private static final QName cx_decode = XProcConstants.qNameFor(XProcConstants.NS_CALABASH_EX, "decode");
    private static final QName _algorithm = new QName("", "algorithm");
    private static final QName _hash_version = new QName("", "hash-version");
    private static final QName _crc = new QName("", "crc");
    private static final QName _md = new QName("", "md");
    private static final QName _sha = new QName("", "sha");
    private static final QName _hmac = XProcConstants.qNameFor(XProcConstants.NS_CALABASH_EX, "hmac");
    private static final QName _accessKey = XProcConstants.qNameFor(XProcConstants.NS_CALABASH_EX, "accessKey");
    private final HashMap<QName, String> params = new HashMap();
    private ReadablePipe source = null;
    private WritablePipe result = null;

    public HashDocument(XProcRuntime runtime, XAtomicStep step) {
        super(runtime, step);
    }

    @Override
    public void setInput(String port, ReadablePipe pipe) {
        this.source = pipe;
    }

    @Override
    public void setOutput(String port, WritablePipe pipe) {
        this.result = pipe;
    }

    @Override
    public void setParameter(QName name, RuntimeValue value) {
        this.params.put(name, value.getString());
    }

    @Override
    public void reset() {
        this.params.clear();
        this.source.resetReader();
        this.result.resetWriter();
    }

    @Override
    public void run() throws SaxonApiException {
        XdmNode doc;
        super.run();
        QName algorithm = this.getOption(_algorithm).getQName();
        String hashVersion = null;
        if (this.getOption(_hash_version) != null) {
            hashVersion = this.getOption(_hash_version).getString();
        }
        if ((doc = this.source.read()) == null || this.source.moreDocuments()) {
            throw XProcException.dynamicError(6, "Reading source on " + this.getStep().getName());
        }
        XdmNode root = S9apiUtils.getDocumentElement(doc);
        assert (root != null);
        String decode = this.step.getExtensionAttribute(cx_decode);
        if (decode == null) {
            decode = root.getAttributeValue(cx_decode);
        }
        String contentType = root.getAttributeValue(_content_type);
        byte[] bytes = null;
        bytes = ("true".equals(decode) || "1".equals(decode)) && XProcConstants.NS_XPROC_STEP == root.getNodeName().getNamespaceUri() && "base64".equals(root.getAttributeValue(_encoding)) || NamespaceUri.NULL == root.getNodeName().getNamespaceUri() && "base64".equals(root.getAttributeValue(c_encoding)) ? this.binaryContent(doc) : (("true".equals(decode) || "1".equals(decode)) && XProcConstants.c_result.equals((Object)root.getNodeName()) && root.getAttributeValue(_content_type) != null && root.getAttributeValue(_content_type).startsWith("text/") ? this.textContent(doc) : (this.runtime.transparentJSON() && (c_body.equals((Object)root.getNodeName()) && ("application/json".equals(contentType) || "text/json".equals(contentType)) || c_json.equals((Object)root.getNodeName()) || JSONtoXML.JSONX_NS == root.getNodeName().getNamespaceUri() || JSONtoXML.JXML_NS == root.getNodeName().getNamespaceUri() || JSONtoXML.MLJS_NS == root.getNodeName().getNamespaceUri()) ? this.jsonContent(doc) : this.XmlContent(doc)));
        String hash = "";
        if (_crc.equals((Object)algorithm)) {
            hash = HashUtils.crc(bytes, hashVersion);
        } else if (_md.equals((Object)algorithm)) {
            hash = HashUtils.md(bytes, hashVersion);
        } else if (_sha.equals((Object)algorithm)) {
            hash = HashUtils.sha(bytes, hashVersion);
        } else if (_hmac.equals((Object)algorithm)) {
            hash = HashUtils.hmac(bytes, this.params.get(_accessKey));
        } else {
            throw XProcException.dynamicError(36);
        }
        TreeWriter tree = new TreeWriter(this.runtime);
        tree.startDocument(this.step.getNode().getBaseURI());
        tree.addStartElement(XProcConstants.c_result);
        tree.addText(hash);
        tree.addEndElement();
        tree.endDocument();
        this.result.write(tree.getResult());
    }

    private byte[] XmlContent(XdmNode doc) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            try {
                Serializer serializer = this.makeSerializer();
                serializer.setOutputStream((OutputStream)baos);
                S9apiUtils.serialize(this.runtime, doc, serializer);
            }
            catch (SaxonApiException e) {
                throw new XProcException(e);
            }
            finally {
                baos.close();
            }
        }
        catch (IOException e) {
            throw new XProcException(e);
        }
        return baos.toByteArray();
    }

    private byte[] binaryContent(XdmNode doc) {
        return Base64.decode(doc.getStringValue());
    }

    private byte[] textContent(XdmNode doc) {
        Serializer serializer = this.makeSerializer();
        serializer.setOutputProperty(Serializer.Property.METHOD, "text");
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        serializer.setOutputStream((OutputStream)baos);
        try {
            S9apiUtils.serialize(this.runtime, doc, serializer);
        }
        catch (SaxonApiException e) {
            throw new XProcException(e);
        }
        return baos.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] jsonContent(XdmNode doc) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            try {
                PrintWriter writer = new PrintWriter(new OutputStreamWriter((OutputStream)baos, StandardCharsets.UTF_8));
                String json = XMLtoJSON.convert(doc);
                writer.print(json);
            }
            finally {
                baos.close();
            }
        }
        catch (IOException e) {
            throw new XProcException(e);
        }
        return baos.toByteArray();
    }
}

