/*
 * Decompiled with CFR 0.152.
 */
package com.xmlcalabash.extensions;

import com.xmlcalabash.core.XMLCalabash;
import com.xmlcalabash.core.XProcException;
import com.xmlcalabash.core.XProcRuntime;
import com.xmlcalabash.io.DataStore;
import com.xmlcalabash.io.WritablePipe;
import com.xmlcalabash.library.DefaultStep;
import com.xmlcalabash.model.RuntimeValue;
import com.xmlcalabash.runtime.XAtomicStep;
import com.xmlcalabash.util.TreeWriter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.net.URI;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.XdmNode;
import org.commonmark.node.Node;
import org.commonmark.parser.Parser;
import org.commonmark.renderer.html.HtmlRenderer;
import org.xml.sax.InputSource;

@XMLCalabash(name="cx:commonmark", type="{http://xmlcalabash.com/ns/extensions}commonmark")
public class CommonMark
extends DefaultStep {
    private static final QName _href = new QName("href");
    private static final QName h_body = new QName("http://www.w3.org/1999/xhtml", "body");
    private WritablePipe result = null;

    public CommonMark(XProcRuntime runtime, XAtomicStep step) {
        super(runtime, step);
    }

    @Override
    public void setOutput(String port, WritablePipe pipe) {
        this.result = pipe;
    }

    @Override
    public void reset() {
        this.result.resetWriter();
    }

    @Override
    public void run() throws SaxonApiException {
        super.run();
        if (this.runtime.getSafeMode()) {
            throw XProcException.dynamicError(21);
        }
        RuntimeValue href = this.getOption(_href);
        try {
            DataStore store = this.runtime.getDataStore();
            store.readEntry(href.getString(), href.getBaseURI().toASCIIString(), "text/*, */*", null, new DataStore.DataReader(){

                @Override
                public void load(URI id, String media, InputStream content, long len) throws IOException {
                    InputStreamReader rdr = new InputStreamReader(content);
                    Parser parser = Parser.builder().build();
                    Node document = parser.parseReader((Reader)rdr);
                    HtmlRenderer renderer = HtmlRenderer.builder().build();
                    String markup = "<body xmlns='http://www.w3.org/1999/xhtml'>" + renderer.render(document) + "</body>";
                    XdmNode parsed = CommonMark.this.runtime.parse(new InputSource(new StringReader(markup)));
                    String path = id.getPath();
                    int lastSlash = path.lastIndexOf("/");
                    String base = path.substring(0, lastSlash + 1);
                    String filename = path.substring(lastSlash + 1);
                    int lastDot = filename.lastIndexOf(".");
                    base = lastDot > 0 ? base + filename.substring(0, lastDot) + ".html" : base + filename + ".html";
                    URI baseURI = id.resolve(base);
                    TreeWriter tree = new TreeWriter(CommonMark.this.runtime);
                    tree.startDocument(baseURI);
                    tree.addSubtree(parsed);
                    tree.endDocument();
                    CommonMark.this.result.write(tree.getResult());
                }
            });
        }
        catch (FileNotFoundException fnfe) {
            URI uri = href.getBaseURI().resolve(href.getString());
            throw new XProcException(href.getNode(), "Cannot read: file does not exist: " + uri.toASCIIString());
        }
        catch (IOException ioe) {
            throw new XProcException(ioe);
        }
    }
}

