/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jeuclid.elements.presentation.token;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.text.AttributedString;
import net.sourceforge.jeuclid.LayoutContext;
import net.sourceforge.jeuclid.context.Display;
import net.sourceforge.jeuclid.context.Parameter;
import net.sourceforge.jeuclid.elements.AbstractJEuclidElement;
import net.sourceforge.jeuclid.elements.JEuclidElement;
import net.sourceforge.jeuclid.elements.presentation.general.Mrow;
import net.sourceforge.jeuclid.elements.support.GraphicsSupport;
import net.sourceforge.jeuclid.elements.support.attributes.AttributesHelper;
import net.sourceforge.jeuclid.elements.support.operatordict.OperatorDictionary;
import net.sourceforge.jeuclid.elements.support.operatordict.OperatorDictionary2;
import net.sourceforge.jeuclid.elements.support.operatordict.UnknownAttributeException;
import net.sourceforge.jeuclid.elements.support.text.StringUtil;
import net.sourceforge.jeuclid.layout.GraphicsObject;
import net.sourceforge.jeuclid.layout.LayoutInfo;
import net.sourceforge.jeuclid.layout.LayoutStage;
import net.sourceforge.jeuclid.layout.LayoutView;
import net.sourceforge.jeuclid.layout.LayoutableNode;
import net.sourceforge.jeuclid.layout.TextObject;
import org.apache.batik.dom.AbstractDocument;
import org.apache.batik.dom.events.DOMEvent;
import org.w3c.dom.Attr;
import org.w3c.dom.Node;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventListener;
import org.w3c.dom.events.EventTarget;
import org.w3c.dom.mathml.MathMLOperatorElement;
import org.w3c.dom.mathml.MathMLScriptElement;
import org.w3c.dom.mathml.MathMLUnderOverElement;

public final class Mo
extends AbstractJEuclidElement
implements MathMLOperatorElement,
EventListener {
    public static final String ATTR_FORM = "form";
    public static final String ATTR_SEPARATOR = "separator";
    public static final String ATTR_LSPACE = "lspace";
    public static final String ATTR_RSPACE = "rspace";
    public static final String ATTR_MINSIZE = "minsize";
    public static final String ATTR_MAXSIZE = "maxsize";
    public static final String ATTR_MOVEABLEWRONG = "moveablelimits";
    public static final String ATTR_MOVABLELIMITS = "movablelimits";
    public static final String ATTR_ACCENT = "accent";
    public static final String ELEMENT = "mo";
    public static final float LARGEOP_CORRECTOR_INLINE = 1.2f;
    public static final float LARGEOP_CORRECTOR_BLOCK = 1.5f;
    public static final String ATTR_STRETCHY = "stretchy";
    public static final String VALUE_STRETCHY_HORIZONTAL = "horizontal";
    public static final String VALUE_STRETCHY_VERTICAL = "vertical";
    public static final String ATTR_LARGEOP = "largeop";
    public static final String ATTR_SYMMETRIC = "symmetric";
    public static final String ATTR_FENCE = "fence";
    public static final String MOEVENT = "MOEvent";
    private static final long serialVersionUID = 1L;
    private final OperatorDictionary opDict;
    private boolean inChangeHook;

    public Mo(String qname, AbstractDocument odoc) {
        super(qname, odoc);
        this.setDefaultMathAttribute(ATTR_FORM, "infix");
        this.setDefaultMathAttribute(ATTR_FENCE, "false");
        this.setDefaultMathAttribute(ATTR_SEPARATOR, "false");
        this.setDefaultMathAttribute(ATTR_LSPACE, "0.277778em");
        this.setDefaultMathAttribute(ATTR_RSPACE, "0.277778em");
        this.setDefaultMathAttribute(ATTR_STRETCHY, "false");
        this.setDefaultMathAttribute(ATTR_SYMMETRIC, "true");
        this.setDefaultMathAttribute(ATTR_MAXSIZE, "9999999pt");
        this.setDefaultMathAttribute(ATTR_MINSIZE, "1");
        this.setDefaultMathAttribute(ATTR_LARGEOP, "false");
        this.setDefaultMathAttribute(ATTR_MOVABLELIMITS, "false");
        this.setDefaultMathAttribute(ATTR_ACCENT, "false");
        this.opDict = OperatorDictionary2.getInstance();
    }

    protected Node newNode() {
        return new Mo(this.nodeName, this.ownerDocument);
    }

    private float getLspaceAsFloat(LayoutContext now) {
        if ((Integer)now.getParameter(Parameter.SCRIPTLEVEL) > 0) {
            return 0.0f;
        }
        return AttributesHelper.convertSizeToPt((String)this.getLspace(), (LayoutContext)now, (String)"pt");
    }

    public float getLargeOpCorrector(LayoutContext now) {
        if (Display.BLOCK.equals(now.getParameter(Parameter.DISPLAY))) {
            return 1.5f;
        }
        return 1.2f;
    }

    private float getRspaceAsFloat(LayoutContext now) {
        if ((Integer)now.getParameter(Parameter.SCRIPTLEVEL) > 0) {
            return 0.0f;
        }
        return AttributesHelper.convertSizeToPt((String)this.getRspace(), (LayoutContext)now, (String)"pt");
    }

    private boolean isFence() {
        return Boolean.parseBoolean(this.getFence());
    }

    public void setMaxsize(String maxsize) {
        this.setAttribute(ATTR_MAXSIZE, maxsize);
    }

    public String getMaxsize() {
        return this.getMathAttribute(ATTR_MAXSIZE);
    }

    public void setMinsize(String minsize) {
        this.setAttribute(ATTR_MINSIZE, minsize);
    }

    public String getMinsize() {
        return this.getMathAttribute(ATTR_MINSIZE);
    }

    private TextLayout produceUnstrechtedLayout(Graphics2D g, LayoutContext now) {
        assert (g != null) : "Graphics2d is null in produceUnstrechtedLayout";
        float fontSizeInPoint = GraphicsSupport.getFontsizeInPoint((LayoutContext)now);
        if (Boolean.parseBoolean(this.getLargeop())) {
            fontSizeInPoint *= this.getLargeOpCorrector(now);
        }
        String theText = this.getText();
        AttributedString aString = StringUtil.convertStringtoAttributedString(theText, this.getMathvariantAsVariant(), fontSizeInPoint, now);
        TextLayout theLayout = StringUtil.createTextLayoutFromAttributedString(g, aString, now);
        return theLayout;
    }

    public void changeHook() {
        super.changeHook();
        if (!this.inChangeHook) {
            this.inChangeHook = true;
            this.detectFormParameter();
            this.loadAttributeFromDictionary(ATTR_LARGEOP, "false");
            this.loadAttributeFromDictionary(ATTR_SYMMETRIC, "true");
            this.loadAttributeFromDictionary(ATTR_STRETCHY, "false");
            this.loadAttributeFromDictionary(ATTR_FENCE, "false");
            this.loadAttributeFromDictionary(ATTR_LSPACE, "0.277778em");
            this.loadAttributeFromDictionary(ATTR_RSPACE, "0.277778em");
            this.loadAttributeFromDictionary(ATTR_MOVABLELIMITS, "false");
            this.registerWithParentsForEvents();
            if (this.isFence()) {
                this.setDefaultMathAttribute(ATTR_STRETCHY, VALUE_STRETCHY_VERTICAL);
            }
            DOMEvent evt = new DOMEvent();
            evt.initEventNS(null, MOEVENT, true, false);
            this.dispatchEvent((Event)evt);
            this.inChangeHook = false;
        }
    }

    private void registerWithParentsForEvents() {
        JEuclidElement parent = this.getParent();
        while (parent != null) {
            if (parent instanceof EventTarget) {
                ((EventTarget)parent).addEventListener("DOMSubtreeModified", this, false);
            }
            if (parent instanceof Mrow && parent.getMathElementCount() > 1) {
                parent = null;
                continue;
            }
            parent = parent.getParent();
        }
    }

    private void loadAttributeFromDictionary(String attrname, String defvalue) {
        String attr;
        try {
            attr = this.opDict.getDefaultAttributeValue(this.getText(), this.getForm(), attrname);
        }
        catch (UnknownAttributeException e) {
            attr = defvalue;
        }
        if (attr.equals("NULL")) {
            attr = defvalue;
        }
        this.setDefaultMathAttribute(attrname, attr);
    }

    private void detectFormParameter() {
        int index;
        JEuclidElement parent = this.getParent();
        String form = parent != null && parent instanceof Mrow ? ((index = parent.getIndexOfMathElement((JEuclidElement)this)) == 0 && parent.getMathElementCount() > 0 ? "prefix" : (index == parent.getMathElementCount() - 1 && parent.getMathElementCount() > 0 ? "postfix" : "infix")) : "infix";
        this.setDefaultMathAttribute(ATTR_FORM, form);
    }

    public String getLargeop() {
        return this.getMathAttribute(ATTR_LARGEOP);
    }

    public String getLspace() {
        return this.getMathAttribute(ATTR_LSPACE);
    }

    public String getMovablelimits() {
        String wrongAttr = this.getMathAttribute(ATTR_MOVEABLEWRONG, false);
        if (wrongAttr == null) {
            return this.getMathAttribute(ATTR_MOVABLELIMITS);
        }
        return wrongAttr;
    }

    public String getRspace() {
        return this.getMathAttribute(ATTR_RSPACE);
    }

    public void setAccent(String accent) {
        this.setAttribute(ATTR_ACCENT, accent);
    }

    public void setFence(String fence) {
        this.setAttribute(ATTR_FENCE, fence);
    }

    public void setForm(String form) {
        this.setAttribute(ATTR_FORM, form);
    }

    public void setLargeop(String largeop) {
        this.setAttribute(ATTR_LARGEOP, largeop);
    }

    public void setLspace(String lspace) {
        this.setAttribute(ATTR_LSPACE, lspace);
    }

    public void setMovablelimits(String movablelimits) {
        this.setAttribute(ATTR_MOVABLELIMITS, movablelimits);
    }

    public void setRspace(String rspace) {
        this.setAttribute(ATTR_RSPACE, rspace);
    }

    public void setSeparator(String separator) {
        this.setAttribute(ATTR_SEPARATOR, separator);
    }

    public void setStretchy(String stretchy) {
        this.setAttribute(ATTR_STRETCHY, stretchy);
    }

    public void setSymmetric(String symmetric) {
        this.setAttribute(ATTR_SYMMETRIC, symmetric);
    }

    public String getFence() {
        return this.getMathAttribute(ATTR_FENCE);
    }

    public String getForm() {
        return this.getMathAttribute(ATTR_FORM);
    }

    public String getSeparator() {
        return this.getMathAttribute(ATTR_SEPARATOR);
    }

    public String getExtendedStretchy() {
        Attr attr = this.getAttributeNodeNS("http://jeuclid.sf.net/ns/ext", ATTR_STRETCHY);
        String retVal = attr == null ? this.getMathAttribute(ATTR_STRETCHY) : attr.getValue().trim();
        return retVal;
    }

    public String getStretchy() {
        String stretchVal = this.getExtendedStretchy();
        if (VALUE_STRETCHY_HORIZONTAL.equalsIgnoreCase(stretchVal) || VALUE_STRETCHY_VERTICAL.equalsIgnoreCase(stretchVal)) {
            return "true";
        }
        return stretchVal;
    }

    private boolean isStretchyHorizontal(String stretchValue) {
        return VALUE_STRETCHY_HORIZONTAL.equalsIgnoreCase(stretchValue) || Boolean.parseBoolean(stretchValue);
    }

    private boolean isStretchyVertical(String stretchValue) {
        return VALUE_STRETCHY_VERTICAL.equalsIgnoreCase(stretchValue) || Boolean.parseBoolean(stretchValue);
    }

    private boolean isStretchy() {
        String stretchValue = this.getExtendedStretchy();
        return this.isStretchyHorizontal(stretchValue) || this.isStretchyVertical(stretchValue);
    }

    public String getAccent() {
        return this.getMathAttribute(ATTR_ACCENT);
    }

    public String getSymmetric() {
        return this.getMathAttribute(ATTR_SYMMETRIC);
    }

    private boolean isSymmetric() {
        return Boolean.parseBoolean(this.getSymmetric());
    }

    public void layoutStage1(LayoutView view, LayoutInfo info, LayoutStage childMinStage, LayoutContext context) {
        LayoutContext now = this.applyLocalAttributesToContext(context);
        Graphics2D g = view.getGraphics();
        TextLayout t = this.produceUnstrechtedLayout(g, now);
        StringUtil.TextLayoutInfo tli = StringUtil.getTextLayoutInfo(t, true);
        float ascent = tli.getAscent();
        float descent = tli.getDescent();
        float xOffset = tli.getOffset();
        float contentWidth = tli.getWidth() + xOffset;
        JEuclidElement parent = this.getParent();
        float lspace = this.getLspaceAsFloat(now);
        float rspace = this.getRspaceAsFloat(now);
        rspace = parent != null && parent.hasChildPostscripts((JEuclidElement)this, context) ? 0.0f : this.getRspaceAsFloat(now);
        lspace = parent != null && parent.hasChildPrescripts((JEuclidElement)this) ? 0.0f : this.getLspaceAsFloat(now);
        info.setAscentHeight(ascent, LayoutStage.STAGE1);
        info.setDescentHeight(descent, LayoutStage.STAGE1);
        info.setHorizontalCenterOffset(lspace + contentWidth / 2.0f, LayoutStage.STAGE1);
        info.setWidth(lspace + contentWidth + rspace, LayoutStage.STAGE1);
        if (this.isStretchy()) {
            info.setLayoutStage(LayoutStage.STAGE1);
            info.setStretchAscent(0.0f);
            info.setStretchDescent(0.0f);
        } else {
            info.setGraphicsObject((GraphicsObject)new TextObject(t, lspace + tli.getOffset(), 0.0f, null, (Color)now.getParameter(Parameter.MATHCOLOR)));
            info.setLayoutStage(LayoutStage.STAGE2);
        }
    }

    public void layoutStage2(LayoutView view, LayoutInfo info, LayoutContext context) {
        float calcBaselineShift;
        float calcScaleY;
        float calcScaleX;
        boolean cont;
        LayoutContext now = this.applyLocalAttributesToContext(context);
        Graphics2D g = view.getGraphics();
        TextLayout t = this.produceUnstrechtedLayout(g, now);
        String stretchValue = this.getExtendedStretchy();
        boolean stretchVertically = this.isStretchyVertical(stretchValue);
        boolean stretchHorizontally = this.isStretchyHorizontal(stretchValue);
        Mo horizParent = null;
        Mo parent = this;
        do {
            boolean isBase;
            MathMLUnderOverElement munderover;
            Mo last = parent;
            parent = parent.getParent();
            cont = false;
            if (parent instanceof Mrow && parent.getMathElementCount() == 1) {
                cont = true;
                continue;
            }
            if (!(parent instanceof MathMLUnderOverElement) && !(parent instanceof MathMLScriptElement)) continue;
            if (parent instanceof MathMLUnderOverElement) {
                munderover = (MathMLUnderOverElement)parent;
                isBase = munderover.getBase() == last;
            } else {
                munderover = (MathMLScriptElement)parent;
                boolean bl = isBase = munderover.getBase() == last;
            }
            if (!isBase) {
                stretchVertically = false;
            }
            horizParent = parent;
            cont = true;
        } while (cont);
        if (horizParent == null) {
            horizParent = parent;
        }
        LayoutInfo parentInfo = view.getInfo((LayoutableNode)parent);
        StringUtil.TextLayoutInfo textLayoutInfo = StringUtil.getTextLayoutInfo(t, true);
        if (parentInfo == null) {
            calcScaleX = 1.0f;
            calcScaleY = 1.0f;
            calcBaselineShift = 0.0f;
        } else {
            if (stretchVertically) {
                float[] yf = this.calcYScaleFactorAndBaselineShift(info, parentInfo, textLayoutInfo, now, g);
                calcScaleY = yf[0];
                calcBaselineShift = yf[1];
            } else {
                calcScaleY = 1.0f;
                calcBaselineShift = 0.0f;
            }
            calcScaleX = stretchHorizontally ? this.calcXScaleFactor(info, view.getInfo((LayoutableNode)horizParent), textLayoutInfo) : 1.0f;
        }
        info.setGraphicsObject((GraphicsObject)new TextObject(t, this.getLspaceAsFloat(now) + textLayoutInfo.getOffset() * calcScaleX, calcBaselineShift, AffineTransform.getScaleInstance(calcScaleX, calcScaleY), (Color)now.getParameter(Parameter.MATHCOLOR)));
        info.setLayoutStage(LayoutStage.STAGE2);
    }

    private float calcXScaleFactor(LayoutInfo info, LayoutInfo parentInfo, StringUtil.TextLayoutInfo textLayoutInfo) {
        float calcScaleX;
        float rstretchWidth = parentInfo.getStretchWidth();
        if (rstretchWidth > 0.0f) {
            float realwidth = textLayoutInfo.getWidth();
            if (realwidth > 0.0f) {
                float stretchWidth = Math.max(realwidth, rstretchWidth);
                calcScaleX = stretchWidth / realwidth;
                info.setWidth(stretchWidth, LayoutStage.STAGE2);
                info.setHorizontalCenterOffset(stretchWidth / 2.0f, LayoutStage.STAGE2);
            } else {
                calcScaleX = 1.0f;
            }
        } else {
            calcScaleX = 1.0f;
        }
        return calcScaleX;
    }

    private float[] calcYScaleFactorAndBaselineShift(LayoutInfo info, LayoutInfo parentInfo, StringUtil.TextLayoutInfo textLayoutInfo, LayoutContext now, Graphics2D g2d) {
        float targetNDescent;
        float targetNAscent;
        float realDescent = textLayoutInfo.getDescent();
        float realAscent = textLayoutInfo.getAscent();
        if (this.isFence()) {
            targetNAscent = Math.max(parentInfo.getAscentHeight(LayoutStage.STAGE1), realAscent);
            targetNDescent = Math.max(parentInfo.getDescentHeight(LayoutStage.STAGE1), realDescent);
        } else {
            targetNAscent = Math.max(parentInfo.getStretchAscent(), realAscent);
            targetNDescent = Math.max(parentInfo.getStretchDescent(), realDescent);
        }
        if (this.isSymmetric()) {
            float middle = this.getMiddleShift(g2d, now);
            float ascentAboveMiddle = targetNAscent - middle;
            float descentBelowMiddle = targetNDescent + middle;
            float halfHeight = Math.max(ascentAboveMiddle, descentBelowMiddle);
            targetNAscent = halfHeight + middle;
            targetNDescent = halfHeight - middle;
        }
        float targetNHeight = targetNAscent + targetNDescent;
        float realHeight = realAscent + realDescent;
        float maxSize = AttributesHelper.parseRelativeSize((String)this.getMaxsize(), (LayoutContext)now, (float)realHeight);
        float minSize = AttributesHelper.parseRelativeSize((String)this.getMinsize(), (LayoutContext)now, (float)realHeight);
        float targetHeight = Math.max(Math.min(targetNHeight, maxSize), minSize);
        float targetDescent = targetHeight / targetNHeight * (targetNHeight / 2.0f) - (targetNHeight / 2.0f - targetNDescent);
        float calcScaleY = realHeight > 0.0f ? targetHeight / realHeight : 1.0f;
        float realDescentScaled = realDescent * calcScaleY;
        float calcBaselineShift = targetDescent - realDescentScaled;
        info.setDescentHeight(targetDescent, LayoutStage.STAGE2);
        info.setAscentHeight(targetHeight - targetDescent, LayoutStage.STAGE2);
        return new float[]{calcScaleY, calcBaselineShift};
    }

    @Override
    public void handleEvent(Event evt) {
        this.changeHook();
    }
}

