/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.jfx.media.player;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.MouseWheelEvent;
import java.net.URL;
import javafx.application.Platform;
import javafx.embed.swing.JFXPanel;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.media.MediaException;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.jfx.JFXUtil;
import ro.sync.jfx.media.ClosableJFXPanel;
import ro.sync.jfx.media.ErrorHandler;
import ro.sync.jfx.media.JFXComponent;
import ro.sync.jfx.media.player.AbstractMediaPlayer;

public abstract class AbstractMediaPlayerComponent
implements JFXComponent {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)AbstractMediaPlayerComponent.class.getName());
    protected static final int MIN_WIDTH = 480;
    protected ClosableJFXPanel jfxPanel;
    protected URL toPlayURL;
    private AbstractMediaPlayer abstractPlayer;
    protected ErrorHandler errorHandler;

    public AbstractMediaPlayerComponent(URL toPlayURL, ErrorHandler errorHandler) {
        this.toPlayURL = toPlayURL;
        this.errorHandler = errorHandler;
    }

    @Override
    public JComponent getSwingComponent(Rectangle allocation) {
        this.jfxPanel = new ClosableJFXPanel(){

            protected void processMouseWheelEvent(MouseWheelEvent e) {
                super.processMouseWheelEvent(e);
                if (!e.isConsumed()) {
                    SwingUtilities.invokeLater(() -> {
                        Container parent = SwingUtilities.getAncestorOfClass(JScrollPane.class, (Component)((Object)AbstractMediaPlayerComponent.this.jfxPanel));
                        if (parent != null) {
                            parent.dispatchEvent(SwingUtilities.convertMouseEvent((Component)((Object)AbstractMediaPlayerComponent.this.jfxPanel), e, parent));
                        }
                    });
                }
            }
        };
        Platform.runLater(() -> {
            block3: {
                if (this.jfxPanel.getScene() == null) {
                    try {
                        Dimension allocationSize = new Dimension(allocation.width, allocation.height);
                        this.abstractPlayer = this.createPlayer(allocationSize);
                        this.jfxPanel.setScene(new Scene((Parent)this.abstractPlayer.getPlayerView()));
                    }
                    catch (MediaException e) {
                        LOGGER.debug(e.getMessage(), (Throwable)e);
                        Scene newScene = JFXUtil.createErrorScene(e.getMessage());
                        this.jfxPanel.setScene(newScene);
                        if (this.errorHandler == null) break block3;
                        this.errorHandler.error(e.getMessage());
                    }
                }
            }
        });
        return this.jfxPanel;
    }

    protected abstract AbstractMediaPlayer createPlayer(Dimension var1);

    @Override
    public void dispose() {
        if (this.jfxPanel != null) {
            this.jfxPanel.dispose();
        }
        Platform.runLater(() -> {
            if (this.abstractPlayer != null) {
                this.abstractPlayer.stop();
                this.abstractPlayer.dispose();
            }
        });
    }

    public AbstractMediaPlayer getFxPlayerForTest() {
        return this.abstractPlayer;
    }

    public JFXPanel getJfxPanelForTests() {
        return this.jfxPanel;
    }

    @Override
    public void deactivate() {
        Platform.runLater(() -> {
            if (this.abstractPlayer != null) {
                this.abstractPlayer.pause();
            }
        });
    }
}

