/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.jfx.media.browser;

import java.util.Map;
import java.util.Set;
import javafx.scene.web.WebEngine;
import netscape.javascript.JSException;
import netscape.javascript.JSObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.jfx.JFXException;
import ro.sync.jfx.media.browser.IWebEngine;

public class JfxWebEngine
implements IWebEngine {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)JfxWebEngine.class.getName());
    private final WebEngine engine;

    public JfxWebEngine(WebEngine engine) {
        this.engine = engine;
    }

    @Override
    public void setMember(String name, Object value) throws JFXException {
        try {
            JSObject window = (JSObject)this.engine.executeScript("window");
            window.setMember(name, value);
        }
        catch (JSException e) {
            throw new JFXException("Exception encountered while setting member: " + name, e);
        }
    }

    @Override
    public Object call(String methodName, Object ... args) throws JFXException {
        try {
            JSObject window = (JSObject)this.engine.executeScript("window");
            return window.call(methodName, args);
        }
        catch (JSException e) {
            throw new JFXException("Exception encountered while calling Javascript function: " + methodName, e);
        }
    }

    @Override
    public Object[] convertToArray(Object jsArray) throws JFXException {
        Object[] parameters = null;
        if (jsArray instanceof JSObject) {
            LOGGER.debug("Array received from JS");
            JSObject jsObj = (JSObject)jsArray;
            Object length = jsObj.eval("this.length");
            LOGGER.debug("Array length: {}", length);
            if (length != null) {
                int size = Integer.parseInt(length.toString());
                parameters = new Object[size];
                for (int i = 0; i < size; ++i) {
                    Object slot = jsObj.getSlot(i);
                    LOGGER.debug("Slot: {} class: {}", slot, slot.getClass());
                    parameters[i] = slot;
                }
            }
        } else {
            LOGGER.warn("The received parameter is not an array.");
        }
        return parameters;
    }

    @Override
    public void setMembers(Map<String, Object> members) {
        JSObject window = (JSObject)this.engine.executeScript("window");
        Set<String> keys = members.keySet();
        for (String name : keys) {
            window.setMember(name, members.get(name));
        }
    }
}

