/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.publishing.template.binding;

import com.oxygenxml.publishing.template.binding.CloneUtil;
import com.oxygenxml.publishing.template.binding.HTMLFragment;
import com.oxygenxml.publishing.template.binding.HTMLPageTemplate;
import com.oxygenxml.publishing.template.binding.Parameter;
import com.oxygenxml.publishing.template.binding.PreviewImage;
import com.oxygenxml.publishing.template.binding.Tag;
import com.oxygenxml.publishing.template.binding.WebHelpResources;
import com.oxygenxml.publishing.template.binding.XSLTExtensionPoint;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAnyElement;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;

@XmlAccessorType(value=XmlAccessType.FIELD)
public class WebHelpTemplateInfo {
    @XmlElement(name="preview-image", namespace="")
    private PreviewImage previewImage;
    @XmlElementWrapper(name="html-page-layout-files")
    @XmlElement(name="page-layout-file")
    private List<HTMLPageTemplate> htmlPageTemplates;
    @XmlElementWrapper(name="xslt")
    @XmlElement(name="extension")
    private List<XSLTExtensionPoint> xslExtensionPoints;
    @XmlElementWrapper(name="html-fragments", namespace="")
    @XmlElement(name="fragment", namespace="")
    private List<HTMLFragment> htmlFragments;
    @XmlElementWrapper(name="parameters", namespace="")
    @XmlElement(name="parameter", namespace="")
    private List<Parameter> paramsList;
    @XmlElement(name="resources", namespace="")
    private WebHelpResources webhelpResources;
    @XmlElement(name="online-preview-url", namespace="")
    private String onlinePreviewUrl;
    @XmlElementWrapper(name="tags", namespace="")
    @XmlElement(name="tag", namespace="")
    private List<Tag> tags;
    @XmlAnyElement(lax=true)
    public Object[] others;

    public WebHelpTemplateInfo() {
    }

    public WebHelpTemplateInfo(WebHelpTemplateInfo source) {
        if (source.previewImage != null) {
            this.previewImage = new PreviewImage(source.previewImage);
        }
        this.htmlPageTemplates = CloneUtil.copyPageTemplates(source.htmlPageTemplates);
        this.xslExtensionPoints = CloneUtil.copyXsltExtensionPoints(source.xslExtensionPoints);
        this.htmlFragments = CloneUtil.copyHtmlFragments(source.htmlFragments);
        this.paramsList = CloneUtil.copyParameters(source.paramsList);
        if (source.webhelpResources != null) {
            this.webhelpResources = new WebHelpResources(source.webhelpResources);
        }
        this.tags = CloneUtil.copyTags(source.tags);
        this.onlinePreviewUrl = source.onlinePreviewUrl;
        if (source.others != null) {
            this.others = Arrays.copyOf(source.others, source.others.length);
        }
    }

    public HTMLPageTemplate getHTMLPageTemplate(String pageID) {
        HTMLPageTemplate pageTemplate = null;
        if (this.htmlPageTemplates != null) {
            for (HTMLPageTemplate htmlPageTemplate : this.htmlPageTemplates) {
                if (!pageID.equals(htmlPageTemplate.getPageID())) continue;
                pageTemplate = htmlPageTemplate;
                break;
            }
        }
        return pageTemplate;
    }

    public boolean hasPageTemplates() {
        return this.htmlPageTemplates != null;
    }

    public List<XSLTExtensionPoint> getXSLTExtensionPoints() {
        return this.xslExtensionPoints;
    }

    public List<HTMLFragment> getHTMLFragments() {
        return this.htmlFragments;
    }

    public void removeHTMLFragment(String placeholder) {
        if (this.htmlFragments != null && placeholder != null) {
            this.htmlFragments.removeIf(f -> placeholder.equals(f.getPlaceholder()));
        }
    }

    public void addHTMLFragments(List<HTMLFragment> fragments) {
        if (fragments != null) {
            if (this.htmlFragments == null) {
                this.htmlFragments = new ArrayList<HTMLFragment>();
            }
            this.htmlFragments.addAll(fragments);
        }
    }

    public List<Parameter> getParamsList() {
        return this.paramsList;
    }

    public void addParameters(List<Parameter> parameters) {
        if (parameters != null) {
            if (this.paramsList == null) {
                this.paramsList = new ArrayList<Parameter>();
            }
            this.paramsList.addAll(parameters);
        }
    }

    public void removeParameter(String name) {
        if (this.paramsList != null && name != null) {
            this.paramsList.removeIf(p -> name.equals(p.getName()));
        }
    }

    public WebHelpResources getWebhelpResources() {
        return this.webhelpResources;
    }

    public void setWebhelpResources(WebHelpResources webhelpResources) {
        this.webhelpResources = webhelpResources;
    }

    public PreviewImage getPreviewImage() {
        return this.previewImage;
    }

    public void setPreviewImage(PreviewImage previewImage) {
        this.previewImage = previewImage;
    }

    public String getOnlinePreviewUrl() {
        return this.onlinePreviewUrl;
    }

    public void setOnlinePreviewUrl(String onlinePreviewUrl) {
        this.onlinePreviewUrl = onlinePreviewUrl;
    }

    public List<HTMLPageTemplate> getHtmlPageTemplates() {
        return this.htmlPageTemplates;
    }

    public void setHtmlPageTemplates(List<HTMLPageTemplate> htmlPageTemplates) {
        this.htmlPageTemplates = htmlPageTemplates;
    }

    public List<Tag> getTags() {
        return this.tags;
    }

    public void setTags(List<Tag> tags) {
        this.tags = tags;
    }

    public String toString() {
        return String.format("WebHelpTemplateInfo [previewImage=%s, htmlPageTemplates=%s, xslExtensionPoints=%s, htmlFragments=%s, paramsList=%s, webhelpResources=%s, onlinePreviewUrl=%s]", this.previewImage, this.htmlPageTemplates, this.xslExtensionPoints, this.htmlFragments, this.paramsList, this.webhelpResources, this.onlinePreviewUrl);
    }
}

